/*====================================================================

			      ʹ¤

                                               S.Kurohashi 91.10. 9
                                               S.Kurohashi 93. 5.31

    $Id: case_analysis.c,v 1.145.2.1 2009/10/19 23:34:31 kawahara Exp $
====================================================================*/
#include "knp.h"

extern int Possibility;
extern int MAX_Case_frame_num;

CF_MATCH_MGR	*Cf_match_mgr = NULL;	/* ΰ */
TOTAL_MGR	Work_mgr;

int	DISTANCE_STEP	= 5;
int	RENKAKU_STEP	= 2;
int	STRONG_V_COST	= 8;
int	ADJACENT_TOUTEN_COST	= 5;
int	LEVELA_COST	= 4;
int	TEIDAI_STEP	= 2;

char *ETAG_name[] = {
    "", "", ":", ";", ":", 
    "ʸ", "ʸ"};

/*==================================================================*/
			  void realloc_cmm()
/*==================================================================*/
{
    Cf_match_mgr = (CF_MATCH_MGR *)realloc_data(Cf_match_mgr, 
						sizeof(CF_MATCH_MGR)*(MAX_Case_frame_num), 
						"realloc_cmm");
}

/*==================================================================*/
		 void init_case_frame(CASE_FRAME *cf)
/*==================================================================*/
{
    int j;

    for (j = 0; j < CF_ELEMENT_MAX; j++) {
	if (Thesaurus == USE_BGH) {
	    cf->ex[j] = 
		(char *)malloc_data(sizeof(char)*EX_ELEMENT_MAX*BGH_CODE_SIZE, 
				    "init_case_frame");
	}
	else if (Thesaurus == USE_NTT) {
	    cf->ex[j] = 
		(char *)malloc_data(sizeof(char)*SM_ELEMENT_MAX*SM_CODE_SIZE, 
				    "init_case_frame");
	}
	cf->sm[j] = 
	    (char *)malloc_data(sizeof(char)*SM_ELEMENT_MAX*SM_CODE_SIZE, 
				"init_case_frame");
	cf->ex_list[j] = (char **)malloc_data(sizeof(char *), 
					      "init_case_frame");
	cf->ex_list[j][0] = (char *)malloc_data(sizeof(char)*REPNAME_LEN_MAX, 
						"init_case_frame");
	cf->ex_freq[j] = (int *)malloc_data(sizeof(int), 
					    "init_case_frame");
    }
}

/*==================================================================*/
		    void init_case_analysis_cmm()
/*==================================================================*/
{
    if (OptAnalysis == OPT_CASE || 
	OptAnalysis == OPT_CASE2) {

	/* cmmΰ */
	Cf_match_mgr = 
	    (CF_MATCH_MGR *)malloc_data(sizeof(CF_MATCH_MGR)*ALL_CASE_FRAME_MAX, 
					"init_case_analysis_cmm");

	init_mgr_cf(&Work_mgr);
    }
}

/*==================================================================*/
		void clear_case_frame(CASE_FRAME *cf)
/*==================================================================*/
{
    int j;

    for (j = 0; j < CF_ELEMENT_MAX; j++) {
	free(cf->ex[j]);
	free(cf->sm[j]);
	free(cf->ex_list[j][0]);
	free(cf->ex_list[j]);
	free(cf->ex_freq[j]);
    }
}

/*====================================================================
		       ʽʸݥб
====================================================================*/

struct PP_STR_TO_CODE {
    char *hstr;
    char *kstr;
    int  code;
} PP_str_to_code[] = {          /* ʸPP_STRING_MAXˤ */
    {"", "", 0},		/* ʽΤʤ(ɽ) */
    {"", "", 1},
    {"", "", 2},
    {"", "", 3},
    {"", "", 4},
    {"", "", 5},
    {"", "", 6},
    {"", "", 7},
    {"", "", 8},
    {"ˤä", "˥å", 9}, /* ʣ缭ط(FUKUGOJI_STARTFUKUGOJI_ENDޤ) */
    {"ᤰ", "ᥰ", 10},	
    {"Ĥ", "ĥ", 11},
    {"Ĥ", "ĥ", 12},
    {"դ", "ե", 13},
    {"Ϥ", "ϥ", 14},
    {"ˤ", "˥", 15},
    {"ˤ", "˥", 16},
    {"ˤऱ", "˥ॱ", 17},
    {"ˤȤʤ", "˥ȥʥ", 18},
    {"ˤȤŤ", "˥ȥť", 19},
    {"Τ", "Υ", 20},
    {"ˤ", "˥", 21},
    {"ˤ", "˥", 22},
    {"ˤ󤹤", "˥󥹥", 23},
    {"ˤ", "˥", 24},
    {"ˤ", "˥", 25},
    {"ˤĤ", "˥ĥ", 26},
    {"ˤȤ", "˥ȥ", 27},
    {"ˤ廊", "˥泌", 28},
    {"ˤ", "˥", 29},
    {"ˤĤŤ", "˥ĥť", 30},
    {"ˤ碌", "˥糧", 31},
    {"ˤ٤", "˥٥", 32},
    {"ˤʤ", "˥ʥ", 33},
    {"Ȥ", "ȥ", 34},
    {"ˤ", "˥", 35},
    {"ˤ", "˥", 36},
    {"Ȥ", "ȥ", 37},	/* Ȥ? */
    {"", "", 38},	/* ˳, ̵ʤǻ֤ǤΤ֤ȤʤȤư */
    {"ޤ", "ޥ", 39},	/* ʤʤǤ뤬¦γʤȤɽ뤿
				   񤤤Ƥ */
    {"", "", 40},
    {"", "", 41},		/* ʥե졼Υγ */
    {"", "", 42},
    {"δط", "δط", 43},
    {"", "", 42},
    {"δط", "δط", 43},	/* for backward compatibility */
    {"", "", 1},		/* NTTǤϡ֥׹ʸ֥ϥ
				    NTTΡ֥ϡפ1(code)Ѵ뤬,
				      1ǡ֥פѴ */
    {"̤", "̤", -3},		/* ʥե졼ˤäưŪ˳Ƥʤꤹ */
    {"", "", -2},		/* ʸ､졢ȱϤγʤʤˤ */
    {NULL, NULL, -1}		/* ʽΤ() */
};

/*  ʤκѤ顢PP_NUMBER(const.h)Ѥ뤳 */

/*====================================================================
			 ʸݥбؿ
====================================================================*/
int pp_kstr_to_code(char *cp)
{
    int i;

    if (str_eq(cp, "NIL"))
	return END_M;

    for (i = 0; PP_str_to_code[i].kstr; i++)
	if (str_eq(PP_str_to_code[i].kstr, cp))
	    return PP_str_to_code[i].code;
    
    if (str_eq(cp, "˥ȥå"))		/* Ԥġ IPALΥХ ?? */
	return pp_kstr_to_code("˥å");
    else if (str_eq(cp, ""))		/* ǤǤʤʤ */
	return END_M;

    /* fprintf(stderr, "Invalid string (%s) in PP !\n", cp); */
    return END_M;
}

int pp_hstr_to_code(char *cp)
{
    int i;
    for (i = 0; PP_str_to_code[i].hstr; i++)
	if (str_eq(PP_str_to_code[i].hstr, cp))
	    return PP_str_to_code[i].code;
    return END_M;
}

char *pp_code_to_kstr(int num)
{
    return PP_str_to_code[num].kstr;
}

char *pp_code_to_hstr(int num)
{
    return PP_str_to_code[num].hstr;
}

char *pp_code_to_kstr_in_context(CF_PRED_MGR *cpm_ptr, int num)
{
    if ((cpm_ptr->cf.type_flag && MatchPP(num, "")) || cpm_ptr->cf.type == CF_NOUN) {
	return "";
    }   
    return pp_code_to_kstr(num);
}

/*==================================================================*/
		    int MatchPPn(int n, int *list)
/*==================================================================*/
{
    int i;

    if (n < 0) {
	return 0;
    }

    for (i = 0; list[i] != END_M; i++) {
	if (n == list[i]) {
	    return 1;
	}
    }
    return 0;
}

/*==================================================================*/
		     int MatchPP(int n, char *pp)
/*==================================================================*/
{
    if (n < 0) {
	return 0;
    }
    if (str_eq(pp_code_to_kstr(n), pp)) {
	return 1;
    }
    return 0;
}

/*==================================================================*/
		    int MatchPP2(int *n, char *pp)
/*==================================================================*/
{
    int i;

    /* ʤĴ٤ʤ뤫ɤ */

    if (n < 0) {
	return 0;
    }

    for (i = 0; *(n+i) != END_M; i++) {
	if (str_eq(pp_code_to_kstr(*(n+i)), pp)) {
	    return 1;
	}
    }
    return 0;
}

/*==================================================================*/
		int CF_MatchPP(int c, CASE_FRAME *cf)
/*==================================================================*/
{
    int i, j;

    for (i = 0; i < cf->element_num; i++) {
	for (j = 0; cf->pp[i][j] != END_M; j++) {
	    if (cf->pp[i][j] == c) {
		return 1;
	    }
	}
    }
    return 0;
}

/*==================================================================*/
		 int CheckCfAdjacent(CASE_FRAME *cf)
/*==================================================================*/
{
    int i;
    for (i = 0; i < cf->element_num; i++) {
	if (cf->adjacent[i] && 
	    MatchPP(cf->pp[i][0], "")) {
	    return FALSE;
	}
    }
    return TRUE;
}

/*==================================================================*/
	  int CheckCfClosest(CF_MATCH_MGR *cmm, int closest)
/*==================================================================*/
{
    return cmm->cf_ptr->adjacent[cmm->result_lists_d[0].flag[closest]];
}

/*==================================================================*/
	     int have_real_component(CASE_FRAME *cf_ptr)
/*==================================================================*/
{
    /* ¦̵ʰʳäƤ뤫ɤ */

    int i;

    for (i = 0; i < cf_ptr->element_num; i++) {
	if (MatchPP(cf_ptr->pp[i][0], "") || 
	    MatchPP(cf_ptr->pp[i][0], "")) {
	    ;
	}
	else {
	    return TRUE;
	}
    }
    return FALSE;
}

/*==================================================================*/
double find_best_cf(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr, int closest, int decide)
/*==================================================================*/
{
    int i, j, frame_num = 0, pat_num;
    CASE_FRAME *cf_ptr = &(cpm_ptr->cf);
    TAG_DATA *b_ptr = cpm_ptr->pred_b_ptr;
    CF_MATCH_MGR tempcmm;

    /* Ǥʤλμ¸ */
    if (cf_ptr->element_num == 0 || 
	have_real_component(cf_ptr) == FALSE) {
	/* ѸΤ٤Ƥγʥե졼 ORޤ
	   ʥե졼ब 1 ĤΤȤϤ줽Τ ˤͽ */
	if (b_ptr->cf_num > 1) {
	    for (i = 0; i < b_ptr->cf_num; i++) {
		if ((b_ptr->cf_ptr+i)->etcflag & CF_SUM) {
		    (Cf_match_mgr + frame_num++)->cf_ptr = b_ptr->cf_ptr + i;
		    break;
		}
	    }
	    /* ORʥե졼बʤȤ
	       ư,,פλ꤬ʤȤФʤ */
	    if (frame_num == 0) {
		(Cf_match_mgr + frame_num++)->cf_ptr = b_ptr->cf_ptr;
	    }
	}
	else {
	    (Cf_match_mgr + frame_num++)->cf_ptr = b_ptr->cf_ptr;
	}
	case_frame_match(cpm_ptr, Cf_match_mgr, OptCFMode, -1);
	cpm_ptr->score = Cf_match_mgr->score;
	cpm_ptr->cmm[0] = *Cf_match_mgr;
	cpm_ptr->result_num = 1;
    }
    else {
	int hiragana_prefer_flag = 0;

	/* ɽҤ餬ʤξ: 
	   ʥե졼ɽҤ餬ʤξ礬¿ФҤ餬ʤγʥե졼Τߤоݤˡ
	   Ҥ餬ʰʳ¿ФҤ餬ʰʳΤߤоݤˤ */
	if (!(OptCaseFlag & OPT_CASE_USE_REP_CF) && /* ɽɽǤϤʤΤ */
	    check_str_type(b_ptr->head_ptr->Goi) == TYPE_HIRAGANA) {
	    if (check_feature(b_ptr->f, "ɽҤ餬")) {
		hiragana_prefer_flag = 1;
	    }
	    else {
		hiragana_prefer_flag = -1;
	    }
	}

	/* ʥե졼 */
	for (i = 0; i < b_ptr->cf_num; i++) {
	    /* OR γʥե졼 */
	    if ((b_ptr->cf_ptr+i)->etcflag & CF_SUM) {
		continue;
	    }
	    else if ((hiragana_prefer_flag > 0 && check_str_type((b_ptr->cf_ptr + i)->entry) != TYPE_HIRAGANA) || 
		     (hiragana_prefer_flag < 0 && check_str_type((b_ptr->cf_ptr + i)->entry) == TYPE_HIRAGANA)) {
		continue;
	    }
	    (Cf_match_mgr + frame_num++)->cf_ptr = b_ptr->cf_ptr + i;
	}

	if (frame_num == 0) { /* νǤҤȤĤĤʤȤ */
	    for (i = 0; i < b_ptr->cf_num; i++) {
		(Cf_match_mgr + frame_num++)->cf_ptr = b_ptr->cf_ptr + i;
	    }
	}

	cpm_ptr->result_num = 0;
	for (i = 0; i < frame_num; i++) {

	    /* ǽ
	       EXAMPLE
	       SEMANTIC_MARKER */

	    /* closest СľǤΤߤΥˤʤ */
	    case_frame_match(cpm_ptr, Cf_match_mgr+i, OptCFMode, closest);

	    /* ̤Ǽ */
	    cpm_ptr->cmm[cpm_ptr->result_num] = *(Cf_match_mgr+i);

	    /* DEBUG:  print_good_crrspnds() ǻȤ Cf_match_mgr Υ */
	    if (OptDisplay == OPT_DEBUG && closest > -1 && !OptEllipsis) {
		pat_num = count_pat_element((Cf_match_mgr+i)->cf_ptr, &((Cf_match_mgr+i)->result_lists_p[0]));
		if (!((Cf_match_mgr+i)->score < 0 || pat_num == 0)) {
		    (Cf_match_mgr+i)->score = (OptCaseFlag & OPT_CASE_USE_PROBABILITY) ? (Cf_match_mgr+i)->pure_score[0] : ((Cf_match_mgr+i)->pure_score[0] / sqrt((double)pat_num));
		}
	    }

	    /* ˥ */
	    for (j = cpm_ptr->result_num - 1; j >= 0; j--) {
		if (cpm_ptr->cmm[j].score < cpm_ptr->cmm[j+1].score || 
		    ((((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
		       cpm_ptr->cmm[j].score != CASE_MATCH_FAILURE_PROB) || 
		      (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
		       cpm_ptr->cmm[j].score != CASE_MATCH_FAILURE_SCORE)) && 
		     cpm_ptr->cmm[j].score == cpm_ptr->cmm[j+1].score && 
		     ((closest > -1 && 
		       (CheckCfClosest(&(cpm_ptr->cmm[j+1]), closest) == TRUE && 
			CheckCfClosest(&(cpm_ptr->cmm[j]), closest) == FALSE)) || 
		      (closest < 0 && 
		       cpm_ptr->cmm[j].sufficiency < cpm_ptr->cmm[j+1].sufficiency)))) {
		    tempcmm = cpm_ptr->cmm[j];
		    cpm_ptr->cmm[j] = cpm_ptr->cmm[j+1];
		    cpm_ptr->cmm[j+1] = tempcmm;
		}
		else {
		    break;
		}
	    }
	    if (cpm_ptr->result_num < CMM_MAX - 1) {
		cpm_ptr->result_num++;
	    }
	}

	/* Ʊγʥե졼θĿ */
	if (cpm_ptr->result_num > 0 && 
	    (((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	      cpm_ptr->cmm[0].score != CASE_MATCH_FAILURE_PROB) || 
	     (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	      cpm_ptr->cmm[0].score != CASE_MATCH_FAILURE_SCORE))) {
	    double top;
	    int cflag = 0;
	    cpm_ptr->tie_num = 1;
	    top = cpm_ptr->cmm[0].score;
	    if (closest > -1 && 
		CheckCfClosest(&(cpm_ptr->cmm[0]), closest) == TRUE) {
		cflag = 1;
	    }
	    for (i = 1; i < cpm_ptr->result_num; i++) {
		/* score ǹǡ
		   ľǤʥե졼ľʤ˥ޥåƤΤ(0ܤå)
		   ľǤʥե졼ľʤ˥ޥåƤ뤳Ȥ
		   
		   score ǹǤ뤳Ȥˤ
		*/
		if (cpm_ptr->cmm[i].score == top) {
/*		if (cpm_ptr->cmm[i].score == top && 
		    (cflag == 0 || CheckCfClosest(&(cpm_ptr->cmm[i]), closest) == TRUE)) { */
		    cpm_ptr->tie_num++;
		}
		else {
		    break;
		}
	    }
	}

	/* Ȥꤢ
	   closest > -1: decided  */
	cpm_ptr->score = (int)cpm_ptr->cmm[0].score;
    }

    /* ʸ̮: ľǤΥͰʾʤʥե졼 */
    if (decide) {
	if (OptEllipsis) {
	    if (closest > -1 && cpm_ptr->score > CF_DECIDE_THRESHOLD) {
		if (cpm_ptr->tie_num > 1) {
		    cpm_ptr->decided = CF_CAND_DECIDED;
		}
		else {
		    cpm_ptr->decided = CF_DECIDED;
		    /* exact match ơǹγʥե졼बҤȤĤʤ顢ɽ */
		    if (cpm_ptr->score == EX_match_exact) {
			cpm_ptr->result_num = 1;
		    }
		}
	    }
	    else if (closest == -1 && cpm_ptr->cf.element_num > 0 && 
		     check_feature(cpm_ptr->pred_b_ptr->f, "Ѹ:")) {
		cpm_ptr->decided = CF_DECIDED;
	    }
	}
	else if (closest > -1) {
	    cpm_ptr->decided = CF_DECIDED;
	}
    }

    if (cf_ptr->element_num != 0) {
	/* ľʤȤľʤΥθƤʤΤǡ
	   ٤ƤγʤΥ­Τˤ */
	if (closest > -1) {
	    int slot_i, slot_j, pos_i, pos_j;

	    for (i = 0; i < cpm_ptr->result_num; i++) {
		/* ƼԤΤȤ(score==-1)ϡpure_score Ƥʤ */
		/* ¦ǤճʤʤƤʤȤ(score==0)ϡʬʬȤ0ˤʤ */
		pat_num = count_pat_element(cpm_ptr->cmm[i].cf_ptr, &(cpm_ptr->cmm[i].result_lists_p[0]));
		if (cpm_ptr->cmm[i].score < 0 || pat_num == 0) {
		    break;
		}
		cpm_ptr->cmm[i].score = (OptCaseFlag & OPT_CASE_USE_PROBABILITY) ? cpm_ptr->cmm[i].pure_score[0] : (cpm_ptr->cmm[i].pure_score[0] / sqrt((double)pat_num));
	    }
	    /* ľʥƱγʥե졼򡢤٤ƤΥsort */
	    for (i = cpm_ptr->tie_num - 1; i >= 1; i--) {
		for (j = i - 1; j >= 0; j--) {
		    slot_i = cpm_ptr->cmm[i].result_lists_d[0].flag[closest];
		    pos_i = (slot_i >= 0 && cpm_ptr->cmm[i].cf_ptr->ex_freq[slot_i]) ? 
			cpm_ptr->cmm[i].result_lists_p[0].pos[slot_i] : -1;
		    slot_j = cpm_ptr->cmm[j].result_lists_d[0].flag[closest];
		    pos_j = (slot_j >= 0 && cpm_ptr->cmm[j].cf_ptr->ex_freq[slot_j]) ? 
			    cpm_ptr->cmm[j].result_lists_p[0].pos[slot_j] : -1;
		    if (cpm_ptr->cmm[i].score > cpm_ptr->cmm[j].score || 
			(pos_i >= 0 && pos_j >= 0 && /* ޥå٤礭 */
			 cpm_ptr->cmm[i].cf_ptr->ex_freq[slot_i][pos_i] > cpm_ptr->cmm[j].cf_ptr->ex_freq[slot_j][pos_j])) {
			tempcmm = cpm_ptr->cmm[i];
			cpm_ptr->cmm[i] = cpm_ptr->cmm[j];
			cpm_ptr->cmm[j] = tempcmm;
		    }
		}
	    }
	}
	cpm_ptr->score = cpm_ptr->cmm[0].score;
    }

    if (OptDisplay == OPT_DEBUG && OptCKY == FALSE) {
	print_data_cframe(cpm_ptr, Cf_match_mgr);
	/* print_good_crrspnds(cpm_ptr, Cf_match_mgr, frame_num); */
	for (i = 0; i < cpm_ptr->result_num; i++) {
	    print_crrspnd(cpm_ptr, &cpm_ptr->cmm[i]);
	}
    }

    return cpm_ptr->score;
}

/*==================================================================*/
int get_closest_case_component(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    /* ѸˤǤ
       äȤѸ˶ᤤΤõ
       (ʸϽ: num == -1) 
       оݳ: , ˳ */

    int i, min = -1, elem_b_num;

    /* ľǤ */
    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	if (cpm_ptr->elem_b_ptr[i] == NULL) {
	    ;
	}
	/* ʣ̾ΰ: ľȤʤ */
	else if (cpm_ptr->elem_b_ptr[i]->inum > 0) {
	    return -1;
	}
	/* ֡ˡ */
	else if (cpm_ptr->pred_b_ptr->num == cpm_ptr->elem_b_ptr[i]->num) {
	    return i;
	}
	/* ѸˤäȤᤤǤõ 
	   <>:̵ ʳ */
	else if (cpm_ptr->elem_b_num[i] > -2 && /* άγǤʤ */
		 cpm_ptr->elem_b_ptr[i]->num <= cpm_ptr->pred_b_ptr->num && 
		 min < cpm_ptr->elem_b_ptr[i]->num && 
		 !(MatchPP(cpm_ptr->cf.pp[i][0], "") && 
		   check_feature(cpm_ptr->elem_b_ptr[i]->f, ""))) {
	    min = cpm_ptr->elem_b_ptr[i]->num;
	    elem_b_num = i;
	}
    }

    /* 1. , ˳ʤǤȤ
       2. <>˥ޥåʤ 1, 2 ʳγ (MatchPP(cpm_ptr->cf.pp[elem_b_num][0], ""))
       3. Ѹľ̤ (줬ϤޤäƤ褤)
       ƻ, Ƚ?
       check_feature Ƥ褤
       ѻ: cpm_ptr->cf.pp[elem_b_num][1] == END_M */
    if (min != -1) {
	/* ꤷʤ:
	   1. ǶǤؼξ ʤޥå?
	   2. ʤǰ̣ǤʤȤ */
	if (check_feature((sp->tag_data+min)->f, "ؼ") || 
	    (Thesaurus == USE_NTT && 
	     (sp->tag_data+min)->SM_code[0] == '\0' && 
	     MatchPP(cpm_ptr->cf.pp[elem_b_num][0], ""))) {
	    return -2;
	}
	else if ((cpm_ptr->cf.pp[elem_b_num][0] == -1 && /* ̤ */
		  (cpm_ptr->pred_b_ptr->num == min + 1 || 
		   (cpm_ptr->pred_b_ptr->num == min + 2 && /* 줬ϤޤäƤ */
		    (check_feature((sp->tag_data + min + 1)->f, "") || 
		     check_feature((sp->tag_data + min + 1)->f, ":Ϣ"))))) || 
		 MatchPP(cpm_ptr->cf.pp[elem_b_num][0], "") || 
		 MatchPP(cpm_ptr->cf.pp[elem_b_num][0], "") || 
		 (((cpm_ptr->cf.pp[elem_b_num][0] > 0 && 
		    cpm_ptr->cf.pp[elem_b_num][0] < 9) || /* ܳ */
		   MatchPP(cpm_ptr->cf.pp[elem_b_num][0], "ޥ")) && 
		   !cf_match_element(cpm_ptr->cf.sm[elem_b_num], "", FALSE))) {
	    cpm_ptr->cf.adjacent[elem_b_num] = TRUE;	/* ľʤΥޡ */
	    return elem_b_num;
	}
    }
    return -1;
}

/*==================================================================*/
       static int number_compare(const void *i, const void *j)
/*==================================================================*/
{
    /* sort function */
    return *(const int *)i-*(const int *)j;
}

/*==================================================================*/
	       char *inputcc2num(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int i, numbers[CF_ELEMENT_MAX];
    char str[70], token[3], *key;

    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	numbers[i] = cpm_ptr->elem_b_ptr[i]->num;
    }

    qsort(numbers, cpm_ptr->cf.element_num, sizeof(int), number_compare);

    str[0] = '\0';
    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	if (i) {
	    sprintf(token, " %d", numbers[i]);
	}
	else {
	    sprintf(token, "%d", numbers[i]);
	}
	strcat(str, token);
    }
    sprintf(token, " %d", cpm_ptr->pred_b_ptr->num);
    strcat(str, token);

    key = strdup(str);
    return key;
}

typedef struct cpm_cache {
    char *key;
    CF_PRED_MGR *cpm;
    struct cpm_cache *next;
} CPM_CACHE;

CPM_CACHE *CPMcache[TBLSIZE];

/*==================================================================*/
			 void InitCPMcache()
/*==================================================================*/
{
    memset(CPMcache, 0, sizeof(CPM_CACHE *)*TBLSIZE);
}

/*==================================================================*/
			 void ClearCPMcache()
/*==================================================================*/
{
    int i;
    CPM_CACHE *ccp, *next;

    for (i = 0; i < TBLSIZE; i++) {
	if (CPMcache[i]) {
	    ccp = CPMcache[i];
	    while (ccp) {
		free(ccp->key);
		clear_case_frame(&(ccp->cpm->cf));
		free(ccp->cpm);
		next = ccp->next;
		free(ccp);
		ccp = next;
	    }
	    CPMcache[i] = NULL;
	}
    }
}

/*==================================================================*/
		void RegisterCPM(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int num;
    char *key;
    CPM_CACHE **ccpp;

    key = inputcc2num(cpm_ptr);
    if (key == NULL) {
	return;
    }
    num = hash(key, strlen(key));

    ccpp = &(CPMcache[num]);
    while (*ccpp) {
	ccpp = &((*ccpp)->next);
    }

    *ccpp = (CPM_CACHE *)malloc_data(sizeof(CPM_CACHE), "RegisterCPM");
    (*ccpp)->key = key;
    (*ccpp)->cpm = (CF_PRED_MGR *)malloc_data(sizeof(CF_PRED_MGR), "RegisterCPM");
    init_case_frame(&((*ccpp)->cpm->cf));
    copy_cpm((*ccpp)->cpm, cpm_ptr, 0);
    (*ccpp)->next = NULL;
}

/*==================================================================*/
	     CF_PRED_MGR *CheckCPM(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int num;
    char *key;
    CPM_CACHE *ccp;

    key = inputcc2num(cpm_ptr);
    if (key == NULL) {
	return NULL;
    }
    num = hash(key, strlen(key));

    ccp = CPMcache[num];
    while (ccp) {
	if (str_eq(key, ccp->key)) {
	    return ccp->cpm;
	}
	ccp = ccp->next;
    }
    return NULL;
}

/*==================================================================*/
double case_analysis(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr, TAG_DATA *t_ptr)
/*==================================================================*/
{
    /*
                                              
      ϤγǤʤ                    -3
      ʥե졼बʤ                      -2
      ¦ɬܳʤĤ()      -1
                                     score (0ʾ)
    */

    int closest;
    CF_PRED_MGR *cache_ptr;

    /*  */
    cpm_ptr->pred_b_ptr = t_ptr;
    cpm_ptr->score = -1;
    cpm_ptr->result_num = 0;
    cpm_ptr->tie_num = 0;
    cpm_ptr->cmm[0].cf_ptr = NULL;
    cpm_ptr->decided = CF_UNDECIDED;

    /* ʸ¦γ */
    set_data_cf_type(cpm_ptr);
    closest = make_data_cframe(sp, cpm_ptr);

    /* ʥե졼ϥå
    if (cpm_ptr->cf.element_num == 0) {
	cpm_ptr->cmm[0].cf_ptr = NULL;
	return -3;
    }
    */

    /* cache */
    if (OptAnalysis == OPT_CASE && 
	!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	(cache_ptr = CheckCPM(cpm_ptr))) {
	copy_cpm(cpm_ptr, cache_ptr, 0);
	return cpm_ptr->score;
    }

    /* äȤ⥹Τ褤ʥե졼ꤹ
       ʸ̮: ľǤʤгʥե졼ꤷʤ */

    /* ľǤ (closest > -1) ΤȤϳʥե졼ꤹ */
    find_best_cf(sp, cpm_ptr, closest, 1);

    if (OptAnalysis == OPT_CASE && 
	!(OptCaseFlag & OPT_CASE_USE_PROBABILITY)) {
	RegisterCPM(cpm_ptr);
    }

    return cpm_ptr->score;
}

/*==================================================================*/
int all_case_analysis(SENTENCE_DATA *sp, TAG_DATA *t_ptr, TOTAL_MGR *t_mgr)
/*==================================================================*/
{
    CF_PRED_MGR *cpm_ptr;
    int i, renyou_modifying_num, adverb_modifying_num, current_pred_num;
    double one_case_point;

    /* ʥե졼̵ͭå: set_pred_caseframe()ξ˽ */
    if (t_ptr->para_top_p != TRUE && 
	t_ptr->cf_num > 0) { /* ʥե졼༭ˤʤƤǥեȳʥե졼बΤ1ʾˤʤ */

	if (t_mgr->pred_num >= CPM_MAX) {
	    fprintf(stderr, ";; too many predicates in a sentence. (> %d)\n", CPM_MAX);
	    exit(1);
	}

	cpm_ptr = &(t_mgr->cpm[t_mgr->pred_num]);

	one_case_point = case_analysis(sp, cpm_ptr, t_ptr);

	/* (¦ɬܳʤĤ)ˤΰ¸¤βϤ
	   
	if (one_case_point == -1) return FALSE;
	*/

	t_mgr->score += one_case_point;
	t_mgr->pred_num++;
    }

    /* ʸEOS (ɤι¤ΤǡΤȤθʤ) *
    if (check_feature(t_ptr->f, "ʸ") && 
	t_ptr->para_top_p != TRUE && 
	t_ptr->cf_num > 0 && 
	check_feature(t_ptr->f, "Ѹ")) {
	t_mgr->score += calc_vp_modifying_probability(NULL, NULL, t_ptr, cpm_ptr->cmm[0].cf_ptr);
    }
    */

    renyou_modifying_num = 0;
    adverb_modifying_num = 0;
    for (i = 0; t_ptr->child[i]; i++) {
	current_pred_num = t_mgr->pred_num;
	if (all_case_analysis(sp, t_ptr->child[i], t_mgr) == FALSE) {
	    return FALSE;
	}

	if ((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	    t_ptr->para_top_p != TRUE && 
	    t_ptr->cf_num > 0 && 
	    check_feature(t_ptr->f, "Ѹ")) {
	    if (check_feature(t_ptr->child[i]->f, ":Ϣ") && 
		check_feature(t_ptr->child[i]->f, "Ѹ") && 
		!check_feature(t_ptr->child[i]->f, "ʣ缭")) {
		t_mgr->score += calc_vp_modifying_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, 
							      t_ptr->child[i], 
							      t_mgr->cpm[current_pred_num].cmm[0].cf_ptr);
		renyou_modifying_num++;
	    }

	    /* Ѹ˷ޤϽ򥫥 */
	    if ((check_feature(t_ptr->child[i]->f, ":Ϣ") && 
		 !check_feature(t_ptr->child[i]->f, "Ѹ")) || 
		check_feature(t_ptr->child[i]->f, "")) {
		t_mgr->score += calc_adv_modifying_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, 
							       t_ptr->child[i]);
		adverb_modifying_num++;
	    }
	}
    }

    if ((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	t_ptr->para_top_p != TRUE && 
	t_ptr->cf_num > 0 && 
	check_feature(t_ptr->f, "Ѹ")) {
	t_mgr->score += calc_vp_modifying_num_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, 
							  renyou_modifying_num);
	t_mgr->score += calc_adv_modifying_num_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, 
							   adverb_modifying_num);
    }

    return TRUE;
}

/*==================================================================*/
      void copy_cf_with_alloc(CASE_FRAME *dst, CASE_FRAME *src)
/*==================================================================*/
{
    int i, j;

    dst->type = src->type;
    dst->element_num = src->element_num;
    for (i = 0; i < src->element_num; i++) {
	dst->oblig[i] = src->oblig[i];
	dst->adjacent[i] = src->adjacent[i];
	for (j = 0; j < PP_ELEMENT_MAX; j++) {
	    dst->pp[i][j] = src->pp[i][j];
	}
	if (src->pp_str[i]) {
	    dst->pp_str[i] = strdup(src->pp_str[i]);
	}
	else {
	    dst->pp_str[i] = NULL;
	}
	if (src->sm[i]) {
	    dst->sm[i] = strdup(src->sm[i]);
	}
	else {
	    dst->sm[i] = NULL;
	}
	if (src->ex[i]) {
	    dst->ex[i] = strdup(src->ex[i]);
	}
	else {
	    dst->ex[i] = NULL;
	}
	if (src->ex_list[i]) {
	    dst->ex_list[i] = (char **)malloc_data(sizeof(char *)*src->ex_size[i], 
						   "copy_cf_with_alloc");
	    dst->ex_freq[i] = (int *)malloc_data(sizeof(int)*src->ex_size[i], 
						 "copy_cf_with_alloc");
	    for (j = 0; j < src->ex_num[i]; j++) {
		dst->ex_list[i][j] = strdup(src->ex_list[i][j]);
		dst->ex_freq[i][j] = src->ex_freq[i][j];
	    }
	}
	else {
	    dst->ex_list[i] = NULL;
	    dst->ex_freq[i] = NULL;
	}
	dst->ex_size[i] = src->ex_size[i];
	dst->ex_num[i] = src->ex_num[i];
	if (src->semantics[i]) {
	    dst->semantics[i] = strdup(src->semantics[i]);
	}
	else {
	    dst->semantics[i] = NULL;
	}
    }
    dst->voice = src->voice;
    dst->cf_address = src->cf_address;
    dst->cf_size = src->cf_size;
    strcpy(dst->cf_id, src->cf_id);
    strcpy(dst->pred_type, src->pred_type);
    strcpy(dst->imi, src->imi);
    dst->etcflag = src->etcflag;
    if (src->feature) {
	dst->feature = strdup(src->feature);
    }
    else {
	dst->feature = NULL;
    }
    if (src->entry) {
	dst->entry = strdup(src->entry);
    }
    else {
	dst->entry = NULL;
    }
    for (i = 0; i < CF_ELEMENT_MAX; i++) {
	dst->samecase[i][0] = src->samecase[i][0];
	dst->samecase[i][1] = src->samecase[i][1];
    }
    dst->cf_similarity = src->cf_similarity;
    /* weight, pred_b_ptr ̤ */
}

/*==================================================================*/
	    void copy_cf(CASE_FRAME *dst, CASE_FRAME *src)
/*==================================================================*/
{
    int i, j;

    dst->type = src->type;
    dst->type_flag = src->type_flag;
    dst->element_num = src->element_num;
/*    for (i = 0; i < CF_ELEMENT_MAX; i++) { */
    for (i = 0; i < src->element_num; i++) {
	dst->oblig[i] = src->oblig[i];
	dst->adjacent[i] = src->adjacent[i];
	for (j = 0; j < PP_ELEMENT_MAX; j++) {
	    dst->pp[i][j] = src->pp[i][j];
	}
	dst->pp_str[i] = src->pp_str[i];	/* Ȥꤢ */
	/* for (j = 0; j < SM_ELEMENT_MAX*SM_CODE_SIZE; j++) {
	    dst->sm[i][j] = src->sm[i][j];
	} */
	if (src->sm[i]) strcpy(dst->sm[i], src->sm[i]);
	if (src->ex[i]) strcpy(dst->ex[i], src->ex[i]);
	strcpy(dst->ex_list[i][0], src->ex_list[i][0]);
	for (j = 0; j < src->ex_num[i]; j++) {
	    dst->ex_freq[i][j] = src->ex_freq[i][j];
	}
	dst->ex_size[i] = src->ex_size[i];
	dst->ex_num[i] = src->ex_num[i];
    }
    dst->voice = src->voice;
    dst->cf_address = src->cf_address;
    dst->cf_size = src->cf_size;
    strcpy(dst->cf_id, src->cf_id);
    strcpy(dst->pred_type, src->pred_type);
    strcpy(dst->imi, src->imi);
    dst->etcflag = src->etcflag;
    dst->feature = src->feature;
    dst->entry = src->entry;
    for (i = 0; i < CF_ELEMENT_MAX; i++) {
	dst->samecase[i][0] = src->samecase[i][0];
	dst->samecase[i][1] = src->samecase[i][1];
    }
    dst->pred_b_ptr = src->pred_b_ptr;
    dst->cf_similarity = src->cf_similarity;
}

/*==================================================================*/
     void copy_cpm(CF_PRED_MGR *dst, CF_PRED_MGR *src, int flag)
/*==================================================================*/
{
    int i;

    if (flag) {
	copy_cf_with_alloc(&dst->cf, &src->cf);
    }
    else {
	copy_cf(&dst->cf, &src->cf);
    }
    dst->pred_b_ptr = src->pred_b_ptr;
    for (i = 0; i < CF_ELEMENT_MAX; i++) {
	dst->elem_b_ptr[i] = src->elem_b_ptr[i];
	dst->elem_b_num[i] = src->elem_b_num[i];
	dst->elem_s_ptr[i] = src->elem_s_ptr[i];
    }
    dst->score = src->score;
    dst->result_num = src->result_num;
    dst->tie_num = src->tie_num;
    for (i = 0; i < CMM_MAX; i++) {
	dst->cmm[i] = src->cmm[i];
    }
    dst->decided = src->decided;
}

/*==================================================================*/
	    void copy_mgr(TOTAL_MGR *dst, TOTAL_MGR *src)
/*==================================================================*/
{
    int i;

    dst->dpnd = src->dpnd;
    dst->pssb = src->pssb;
    dst->dflt = src->dflt;
    dst->score = src->score;
    dst->pred_num = src->pred_num;
    for (i = 0; i < CPM_MAX; i++) {
	copy_cpm(&dst->cpm[i], &src->cpm[i], 0);
    }
    dst->ID = src->ID;
}

/*==================================================================*/
	 int call_case_analysis(SENTENCE_DATA *sp, DPND dpnd)
/*==================================================================*/
{
    int i, j, k;
    int one_topic_score, topic_score, topic_score_sum = 0, topic_slot[2], distance_cost = 0;
    char *cp;

    /* ʹ¤ϤΥᥤؿ */

    /* ¸¤ں */

    dpnd_info_to_bnst(sp, &dpnd);
    dpnd_info_to_tag(sp, &dpnd);
    if (make_dpnd_tree(sp) == FALSE) {
	return FALSE;
    }
    bnst_to_tag_tree(sp);
	
    if (OptDisplay == OPT_DEBUG)
	print_kakari(sp, OPT_TREE);

    /* ʲϺΰν */
	
    Work_mgr.pssb = Possibility;
    Work_mgr.dpnd = dpnd;
    Work_mgr.score = 0;
    Work_mgr.pred_num = 0;
    Work_mgr.dflt = 0;
    for (i = 0; i < sp->Bnst_num; i++)
	Work_mgr.dflt += dpnd.dflt[i];
    
    /* ʲϸƤӽФ */

    if (all_case_analysis(sp, sp->tag_data + sp->Tag_num - 1, &Work_mgr) == TRUE)
	Possibility++;
    else
	return FALSE;

    /*  default ȤεΥΤ,  */

    for (i = 0; i < sp->Bnst_num - 1; i++) {
	/*  -> ٥:A (롼Ǥηϡ
	   ǥȤͿ) */
	if (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	    check_feature((sp->bnst_data + i)->f, ":") && 
	    check_feature((sp->bnst_data + dpnd.head[i])->f, "٥:A")) {
	    distance_cost += LEVELA_COST;
	}

	if (dpnd.dflt[i] > 0) {
	    /*  */
	    if (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
		check_feature((sp->bnst_data + i)->f, "")) {
		distance_cost += dpnd.dflt[i];

		/* ˤĤƱ󤯤˷äƤޤäʸεΥ */
		for (j = 0; j < i - 1; j++) {
		    if (dpnd.head[i] == dpnd.head[j]) {
			for (k = j + 1; k < i; k++) {
			    if (Mask_matrix[j][k] && Quote_matrix[j][k] && Dpnd_matrix[j][k] && Dpnd_matrix[j][k] != 'd') {
				distance_cost += dpnd.dflt[i]*TEIDAI_STEP;
			    }
			}
		    }
		}
		continue;
	    }
	    /* ʳ */
	    /* ¦ϢѤǤʤȤ */
	    if (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
		!check_feature((sp->bnst_data + i)->f, ":Ϣ")) {
		/* ʬʤ٤ζѸ (Ϣΰʳ) ۤƤȤ */
		if (!check_feature((sp->bnst_data + i)->f, "")) {
		    if (dpnd.head[i] > i + 1 && 
			subordinate_level_check("B", (sp->bnst_data + i + 1)->f) && 
			(cp = (char *)check_feature((sp->bnst_data + i + 1)->f, ""))) {
			if (strcmp(cp+3, "Ϣ") && strcmp(cp+3, "Ϣ")) {
			    distance_cost += STRONG_V_COST;
			}
		    }
		}
		/* ʬ*/
		else {
		    /* ٤˷Ȥ */
		    if (dpnd.head[i] == i + 1) {
			distance_cost += ADJACENT_TOUTEN_COST;
		    }
		}
	    }

	    /* ΨŪ: ʤɤΥ (tentative) */
	    if (OptCaseFlag & OPT_CASE_USE_PROBABILITY) {
		if (check_feature((sp->bnst_data + i)->f, ":Ϣ") && 
		    !check_feature((sp->bnst_data + i)->f, "Ѹ")) {
		    distance_cost += dpnd.dflt[i]*DISTANCE_STEP;
		}
	    }
	    /* ǥեȤȤκ x 2 ΥΥȤȤ
	       ƻϢʤξ x 1 */
	    else {
		if (!check_feature((sp->bnst_data + i)->f, ":Ϣ") || 
		    check_feature((sp->bnst_data + i)->f, "Ѹ:")) {
		    distance_cost += dpnd.dflt[i]*DISTANCE_STEP;
		}
		else {
		    distance_cost += dpnd.dflt[i]*RENKAKU_STEP;
		}
	    }
	}		    
    }

    Work_mgr.score -= distance_cost;

    if (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY)) {
	for (i = sp->Bnst_num - 1; i > 0; i--) {
	    /* ʸѸȤ */
	    if ((cp = (char *)check_feature((sp->bnst_data + i)->f, ""))) {

		/* topic_slot[0]	ְʳΥϳʤΥå
		   topic_slot[1]	<<>>ϡפΥå
		   ξȤ 1 ʲĤʤ
		*/

		topic_slot[0] = 0;
		topic_slot[1] = 0;
		one_topic_score = 0;

		/* ¦õ */
		for (j = i - 1; j >= 0; j--) {
		    if (dpnd.head[j] != i) {
			continue;
		    }
		    if (check_feature((sp->bnst_data + j)->f, "")) {
			if (check_feature((sp->bnst_data + j)->f, "")) {
			    topic_slot[1]++;
			}
			else {
			    topic_slot[0]++;
			}
			sscanf(cp, "%*[^:]:%d", &topic_score);
			one_topic_score += topic_score;
		    }
		}

		if (topic_slot[0] > 0 || topic_slot[1] > 0) {
		    one_topic_score += 20;
		}
		Work_mgr.score += one_topic_score;
		if (OptDisplay == OPT_DEBUG) {
		    topic_score_sum += one_topic_score;
		}
	    }
	}
    }

    if (OptDisplay == OPT_DEBUG) {
	if (OptCaseFlag & OPT_CASE_USE_PROBABILITY) {
	    fprintf(stdout, " %.5f (Υ %d)\n", 
		    Work_mgr.score, distance_cost);
	}
	else {
	    fprintf(stdout, " %d (Υ %d (%d) ꥹ %d)\n", 
		    (int)Work_mgr.score, distance_cost, (int)Work_mgr.dflt*2, topic_score_sum);
	}
    }

    /* -nbestΤ */
    if (OptNbest == TRUE) {
	/* featureͿ */
	assign_general_feature(sp->bnst_data, sp->Bnst_num, AfterDpndBnstRuleType, FALSE, TRUE);
	assign_general_feature(sp->tag_data, sp->Tag_num, AfterDpndTagRuleType, FALSE, TRUE);

	/* ʲϤη̤featureȤƲͿ */
	for (i = 0; i < Work_mgr.pred_num; i++) {
	    record_case_analysis(sp, &(Work_mgr.cpm[i]), NULL, TRUE);
	}

	sp->score = Work_mgr.score;
	print_result(sp, 0);

	/* Ϳfeature */
	for (i = 0; i < sp->Bnst_num; i++) {
	    delete_temp_feature(&(sp->bnst_data[i].f));
	}
	for (i = 0; i < sp->Tag_num; i++) {
	    delete_temp_feature(&(sp->tag_data[i].f));
	}
    }
        
    /*  */

    if (Work_mgr.score > sp->Best_mgr->score ||
	(Work_mgr.score == sp->Best_mgr->score && 
	 compare_dpnd(sp, &Work_mgr, sp->Best_mgr) == TRUE))
	copy_mgr(sp->Best_mgr, &Work_mgr);

    return TRUE;
}

/*==================================================================*/
      int add_cf_slot(CF_PRED_MGR *cpm_ptr, char *cstr, int num)
/*==================================================================*/
{
    if (cpm_ptr->cmm[0].cf_ptr->element_num >= CF_ELEMENT_MAX) {
	return FALSE;
    }

    _make_ipal_cframe_pp(cpm_ptr->cmm[0].cf_ptr, cstr, cpm_ptr->cmm[0].cf_ptr->element_num, CF_PRED);
    cpm_ptr->cmm[0].result_lists_d[0].flag[num] = cpm_ptr->cmm[0].cf_ptr->element_num;
    cpm_ptr->cmm[0].result_lists_d[0].score[num] = 0;
    cpm_ptr->cmm[0].result_lists_p[0].flag[cpm_ptr->cmm[0].cf_ptr->element_num] = num;
    cpm_ptr->cmm[0].result_lists_p[0].score[cpm_ptr->cmm[0].cf_ptr->element_num] = 0;
    cpm_ptr->cmm[0].cf_ptr->element_num++;

    return TRUE;
}

/*==================================================================*/
    int assign_cf_slot(CF_PRED_MGR *cpm_ptr, int cnum, int num)
/*==================================================================*/
{
    /* ʥե졼ΤγʤˤǤбդ */
    if (cpm_ptr->cmm[0].result_lists_p[0].flag[cnum] != UNASSIGNED) {
	return FALSE;
    }

    cpm_ptr->cmm[0].result_lists_d[0].flag[num] = cnum;
    cpm_ptr->cmm[0].result_lists_d[0].score[num] = 0;
    cpm_ptr->cmm[0].result_lists_p[0].flag[cnum] = num;
    cpm_ptr->cmm[0].result_lists_p[0].score[cnum] = 0;

    return TRUE;
}

/*==================================================================*/
		int check_ga2_ok(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int i;
    for (i = 0; i < cpm_ptr->cmm[0].cf_ptr->element_num; i++) {
	/* Ƥʤ<>Υ, , ˳ʤ¸ߤʤСԲ */
	if (cpm_ptr->cmm[0].result_lists_p[0].flag[i] == UNASSIGNED && 
	    cf_match_element(cpm_ptr->cmm[0].cf_ptr->sm[i], "", FALSE) && 
	    (MatchPP(cpm_ptr->cmm[0].cf_ptr->pp[i][0], "") || 
	     MatchPP(cpm_ptr->cmm[0].cf_ptr->pp[i][0], "") || 
	     MatchPP(cpm_ptr->cmm[0].cf_ptr->pp[i][0], ""))) {
	    return 0;
	}
    }
    return 1;
}

/*==================================================================*/
      void decide_voice(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    TAG_DATA *check_b_ptr;

    if (cpm_ptr->cmm[0].cf_ptr->voice == FRAME_ACTIVE) {
	cpm_ptr->pred_b_ptr->voice = 0;
    }
    else {
	cpm_ptr->pred_b_ptr->voice = VOICE_UKEMI;
    }

    /* ʤʤʤ褦 */
    check_b_ptr = cpm_ptr->pred_b_ptr;
    while (check_b_ptr->parent && check_b_ptr->parent->para_top_p == TRUE) {
	check_b_ptr->parent->voice = cpm_ptr->pred_b_ptr->voice;
	check_b_ptr = check_b_ptr->parent;
    }
}

/*==================================================================*/
	   char *make_print_string(TAG_DATA *bp, int flag)
/*==================================================================*/
{
    int i, start = 0, end = 0, length = 0;
    char *ret;

    /*
       flag == 1: Ω
       flag == 0: ǸμΩ
    */

    if (flag) {
	/* Ƭߤ */
	for (i = 0; i < bp->mrph_num; i++) {
	    /* °ü */
	    if (strcmp(Class[(bp->mrph_ptr + i)->Hinshi][0].id, "ü") || 
		check_feature((bp->mrph_ptr + i)->f, "Ω")) {
		start = i;
		break;
	    }
	}

	/* ߤ */
	for (i = bp->mrph_num - 1; i >= start; i--) {
	    /* ü, , ư, Ƚ */
	    if ((strcmp(Class[(bp->mrph_ptr + i)->Hinshi][0].id, "ü") || 
		 check_feature((bp->mrph_ptr + i)->f, "Ω")) && 
		strcmp(Class[(bp->mrph_ptr + i)->Hinshi][0].id, "") && 
		strcmp(Class[(bp->mrph_ptr + i)->Hinshi][0].id, "ư") && 
		strcmp(Class[(bp->mrph_ptr + i)->Hinshi][0].id, "Ƚ")) {
		end = i;
		break;
	    }
	}

	if (start > end) {
	    start = bp->jiritu_ptr-bp->mrph_ptr;
	    end = bp->settou_num+bp->jiritu_num - 1;
	}

	for (i = start; i <= end; i++) {
	    length += strlen((bp->mrph_ptr + i)->Goi2);
	}
	if (length == 0) {
	    return NULL;
	}
	ret = (char *)malloc_data(length + 1, "make_print_string");
	*ret = '\0';
	for (i = start; i <= end; i++) {
	    strcat(ret, (bp->mrph_ptr + i)->Goi2);
	}
    }
    else {
	ret = strdup(bp->head_ptr->Goi2);
    }
    return ret;
}

/*==================================================================*/
    void record_match_ex(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int i, num, pos;
    char feature_buffer[DATA_LEN];

    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	num = cpm_ptr->cmm[0].result_lists_d[0].flag[i];
	if (num != NIL_ASSIGNED && /* Ƥ */
	    cpm_ptr->elem_b_ptr[i]) { /* && cpm_ptr->elem_b_num[i] < 0) { * ά, , Ϣν˸ꤹ */
	    pos = cpm_ptr->cmm[0].result_lists_p[0].pos[num];
	    if (pos == MATCH_NONE || pos == MATCH_SUBJECT) {
		sprintf(feature_buffer, "ޥå;%s:%s-%s", 
			pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[num][0]), 
			cpm_ptr->elem_b_ptr[i]->head_ptr->Goi, 
			pos == MATCH_NONE ? "NONE" : "SUBJECT");
	    }
	    else {
		sprintf(feature_buffer, "ޥå;%s:%s-%s:%.5f", 
			pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[num][0]), 
			cpm_ptr->elem_b_ptr[i]->head_ptr->Goi, 
			cpm_ptr->cmm[0].cf_ptr->ex_list[num][pos], 
			cpm_ptr->cmm[0].result_lists_p[0].score[num]);
	    }
	    assign_cfeature(&(cpm_ptr->pred_b_ptr->f), feature_buffer, FALSE);
	}
    }
}

/*==================================================================*/
void record_closest_cc_match(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    /* ѸˤĤơľǤΥޥåfeature */

    int num, pos, closest;
    char feature_buffer[DATA_LEN];

    if (!check_feature(cpm_ptr->pred_b_ptr->f, "Ѹ")) {
	return;
    }

    if ((closest = get_closest_case_component(sp, cpm_ptr)) >= 0 && 
	cpm_ptr->elem_b_ptr[closest]->num + 1 == cpm_ptr->pred_b_ptr->num) {
	num = cpm_ptr->cmm[0].result_lists_d[0].flag[closest];
	if (num != NIL_ASSIGNED) {
	    pos = cpm_ptr->cmm[0].result_lists_p[0].pos[num];
	    if (pos != MATCH_SUBJECT) {
		sprintf(feature_buffer, "ľʥޥå:%d", 
			(int)cpm_ptr->cmm[0].result_lists_p[0].score[num]);
		assign_cfeature(&(cpm_ptr->pred_b_ptr->f), feature_buffer, FALSE);
	    }
	}
    }
}

/*==================================================================*/
  void assign_nil_assigned_components(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int i, c;

    if (cpm_ptr->score < 0) {
	return;
    }

    /* ̤бγǤν */

    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	if (cpm_ptr->cmm[0].result_lists_d[0].flag[i] == NIL_ASSIGNED) {
	    /* ̤, Ϣ */
	    if (cpm_ptr->elem_b_num[i] == -1) {
		/* <> =>  */
		if (check_feature(cpm_ptr->elem_b_ptr[i]->f, "")) {
		    if (check_cf_case(cpm_ptr->cmm[0].cf_ptr, "") < 0) {
			add_cf_slot(cpm_ptr, "", i);
		    }
		}
		/* ż칽ʸγΥ */
		else if (cpm_ptr->elem_b_ptr[i]->num < cpm_ptr->pred_b_ptr->num && 
			 check_feature(cpm_ptr->elem_b_ptr[i]->f, ":̤") && 
			 cpm_ptr->pred_b_ptr->num != cpm_ptr->elem_b_ptr[i]->num+1 && /* ѸľǤϤʤ (¤ϡ⤦ҤȤĤΥʤˤ뤳Ȥˤ) */
			 check_ga2_ok(cpm_ptr)) {
		    if (check_cf_case(cpm_ptr->cmm[0].cf_ptr, "") < 0) {
			add_cf_slot(cpm_ptr, "", i);
		    }
		}
		/* ¾ => δط
		   ʣ̾¦: α
		   ѸľΥγ: α */
		else if (cpm_ptr->cf.type != CF_NOUN && 
			 !(cpm_ptr->elem_b_ptr[i]->inum > 0 && 
			   cpm_ptr->elem_b_ptr[i]->parent == cpm_ptr->pred_b_ptr) && 
			 cpm_ptr->cf.pp[i][0] != pp_kstr_to_code("̤") && 
			 MatchPP2(cpm_ptr->cf.pp[i], "δط")) { /* ֳδطפβǽ */
		    if ((c = check_cf_case(cpm_ptr->cmm[0].cf_ptr, "δط")) < 0) {
			add_cf_slot(cpm_ptr, "δط", i);
		    }
		    else {
			assign_cf_slot(cpm_ptr, c, i);
		    }
		}
	    }
	    /* ʤƤ뤬ʥե졼¦ˤγʤʤä */
	    /*  ȤꤦʤʣȤ: س */
	    else {
		if (check_cf_case(cpm_ptr->cmm[0].cf_ptr, pp_code_to_kstr(cpm_ptr->cf.pp[i][0])) < 0) {
		    add_cf_slot(cpm_ptr, pp_code_to_kstr(cpm_ptr->cf.pp[i][0]), i);
		}
	    }
	}
    }
}

/*==================================================================*/
char *make_cc_string(char *word, int tag_n, char *pp_str, int cc_type,
		     int dist, char *sid)
/*==================================================================*/
{
    char *buf;

    buf = (char *)malloc_data(strlen(pp_str) + strlen(word) + strlen(sid) + (dist ? log(dist) : 0) + 11, 
			      "make_cc_string");

    if (tag_n < 0) { /* ˤʻ礵줿ܶ */
	sprintf(buf, "%s/U/-/-/-/-", pp_str);
    }
    else {
	sprintf(buf, "%s/%c/%s/%d/%d/%s", 
		pp_str, 
		cc_type == -2 ? 'O' : 	/* ά */
		cc_type == -3 ? 'D' : 	/* ȱ */
		cc_type == -1 ? 'N' : 'C', 
		word, 
		tag_n, 
		dist, 
		sid);
    }

    return buf;
}

/*==================================================================*/
void append_cf_feature(FEATURE **fpp, CF_PRED_MGR *cpm_ptr, CASE_FRAME *cf_ptr, int n)
/*==================================================================*/
{
    char feature_buffer[DATA_LEN];

    /* ʥե졼Υʤ<ν>Ĥɤ */
    if ((cf_ptr->etcflag & CF_GA_SEMI_SUBJECT) && 
	MatchPP(cf_ptr->pp[n][0], "")) {
	sprintf(feature_buffer, "ʥե졼-%s-ν", pp_code_to_kstr_in_context(cpm_ptr, cf_ptr->pp[n][0]));
	assign_cfeature(fpp, feature_buffer, FALSE);
    }
    /* ʥե졼ब<>Ĥɤ */
    else if (cf_match_element(cf_ptr->sm[n], "", FALSE)) {
	sprintf(feature_buffer, "ʥե졼-%s-", pp_code_to_kstr_in_context(cpm_ptr, cf_ptr->pp[n][0]));
	assign_cfeature(fpp, feature_buffer, FALSE);
    }

    /* ʥե졼ब<ʸ>Ĥɤ *
    if (cf_match_element(cf_ptr->sm[n], "ʸ", TRUE)) {
	sprintf(feature_buffer, "ʥե졼-%s-ʸ", pp_code_to_kstr_in_context(cpm_ptr, cf_ptr->pp[n][0]));
	assign_cfeature(fpp, feature_buffer, FALSE);
    }
    */
}

/*==================================================================*/
void assign_case_component_feature(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr, 
				   int temp_assign_flag)
/*==================================================================*/
{
    int i, num;
    char feature_buffer[DATA_LEN], *word;

    /* ѸγƥåȤγƤѸfeature */
    for (i = 0; i < cpm_ptr->cmm[0].cf_ptr->element_num; i++) {
	num = cpm_ptr->cmm[0].result_lists_p[0].flag[i];

	/* Ƥʤ */
	if (num == UNASSIGNED) {
	    sprintf(feature_buffer, "-%s:NIL", 
		    pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[i][0]));
	}
	/* Ƥ (άʳξ) */
	else if (cpm_ptr->elem_b_num[num] > -2) {
	    word = make_print_string(cpm_ptr->elem_b_ptr[num], 0);
	    if (word) {
		sprintf(feature_buffer, "-%s:%s", 
			pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[i][0]), word);
		free(word);
	    }
	}

	assign_cfeature(&(cpm_ptr->pred_b_ptr->f), feature_buffer, temp_assign_flag);
    }
}

/*==================================================================*/
void cat_case_analysis_result_parallel_child(char *buffer, CF_PRED_MGR *cpm_ptr, int cf_i, 
					     int dist_n, char *sid)
/*==================================================================*/
{
    int j;
    char *word, *cp;
    int num = cpm_ptr->cmm[0].result_lists_p[0].flag[cf_i];

    /* λҶơbuffercat */

    /* άԻξ: elem_b_ptrοƤpara_top_p */
    if (!cpm_ptr->cf.type == CF_NOUN && 
	cpm_ptr->elem_b_ptr[num]->para_type == PARA_NORMAL && 
	cpm_ptr->elem_b_ptr[num]->parent && 
	cpm_ptr->elem_b_ptr[num]->parent->para_top_p) {
	for (j = 0; cpm_ptr->elem_b_ptr[num]->parent->child[j]; j++) {
	    if (cpm_ptr->elem_b_ptr[num] == cpm_ptr->elem_b_ptr[num]->parent->child[j] || /* target */
		cpm_ptr->elem_b_ptr[num]->parent->child[j]->para_type != PARA_NORMAL || /* ǤϤʤ */
		(cpm_ptr->pred_b_ptr->num < cpm_ptr->elem_b_ptr[num]->num && /* Ϣνξϡ */
		 (cpm_ptr->elem_b_ptr[num]->parent->child[j]->num < cpm_ptr->pred_b_ptr->num || /* ѸϤʤ */
		  cpm_ptr->elem_b_ptr[num]->num < cpm_ptr->elem_b_ptr[num]->parent->child[j]->num))) { /* λҤλҤϤʤ */
		continue;
	    }
	    word = make_print_string(cpm_ptr->elem_b_ptr[num]->parent->child[j], 0);
	    cp = make_cc_string(word ? word : "(null)", cpm_ptr->elem_b_ptr[num]->parent->child[j]->num, 
				pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[cf_i][0]), 
				cpm_ptr->elem_b_num[num], dist_n, sid ? sid : "?");
	    strcat(buffer, cp);
	    strcat(buffer, ";");
	    free(cp);
	    if (word) free(word);
	}
    }

    /* ľܤηξ: elem_b_ptrpara_top_p */
    if (cpm_ptr->elem_b_ptr[num]->para_top_p) {
	for (j = 1; cpm_ptr->elem_b_ptr[num]->child[j]; j++) { /* 0ϼʬƱǥåƤ */
	    if (cpm_ptr->elem_b_ptr[num]->child[j]->para_type == PARA_NORMAL) {
		word = make_print_string(cpm_ptr->elem_b_ptr[num]->child[j], 0);
		cp = make_cc_string(word ? word : "(null)", cpm_ptr->elem_b_ptr[num]->child[j]->num, 
				    pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[cf_i][0]), 
				    cpm_ptr->elem_b_num[num], dist_n, sid ? sid : "?");
		strcat(buffer, cp);
		strcat(buffer, ";");
		free(cp);
		if (word) free(word);	    
	    }
	}
    }
}

/*==================================================================*/
void assign_feature_samecase(CF_PRED_MGR *cpm_ptr, int temp_assign_flag)
/*==================================================================*/
{
    int i;
    char feature_buffer[DATA_LEN], *case_str1, *case_str2;

    for (i = 0; cpm_ptr->cmm[0].cf_ptr->samecase[i][0] != END_M; i++) {
	/* ʤ¸ߤֽפǤϤʤ */
	if ((case_str1 = pp_code_to_kstr(cpm_ptr->cmm[0].cf_ptr->samecase[i][0])) && strcmp(case_str1, "")) {
	    if ((case_str2 = pp_code_to_kstr(cpm_ptr->cmm[0].cf_ptr->samecase[i][1])) && strcmp(case_str2, "")) {
		sprintf(feature_buffer, ";%s%s", case_str1, case_str2);
		assign_cfeature(&(cpm_ptr->pred_b_ptr->f), feature_buffer, temp_assign_flag);
	    }
	}
    }
}

/*==================================================================*/
     int find_aligned_case(CF_ALIGNMENT *cf_align, int src_case)
/*==================================================================*/
{
    int i;

    for (i = 0; cf_align->aligned_case[i][0] != END_M; i++) {
	if (cf_align->aligned_case[i][0] == src_case) {
	    return cf_align->aligned_case[i][1];
	}
    }

    return src_case;
}

/*==================================================================*/
void record_case_analysis_result(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr, 
				 ELLIPSIS_MGR *em_ptr, int temp_assign_flag, 
				 char *feature_head, CF_ALIGNMENT *cf_align)
/*==================================================================*/
{
    int i, num, dist_n, sent_n, tag_n, first_arg_flag = 1, case_num;
    char feature_buffer[DATA_LEN], buffer[DATA_LEN], *word, *sid, *cp, *case_str;
    TAG_DATA *elem_b_ptr;

    /* ʥե졼¦ε
       => ֳ-פʤɤ򽸤褦˽ */

    /* ʥե졼ID */
    sprintf(feature_buffer, "%s%s:", feature_head, cf_align ? cf_align->cf_id : cpm_ptr->cmm[0].cf_ptr->cf_id);

    /* 줾γ */
    for (i = 0; i < cpm_ptr->cmm[0].cf_ptr->element_num; i++) {
	num = cpm_ptr->cmm[0].result_lists_p[0].flag[i];
	case_num = cf_align ? find_aligned_case(cf_align, cpm_ptr->cmm[0].cf_ptr->pp[i][0]) : cpm_ptr->cmm[0].cf_ptr->pp[i][0];
	if (case_num == END_M) { /* ˡбγʤʤ(NIL) */
	    continue;
	}
	case_str = pp_code_to_kstr_in_context(cpm_ptr, case_num);

	/* Ƥʤ */
	if (num == UNASSIGNED) {
	    if (!cf_align) { /* ϳƤʤɽʤ */
		if (first_arg_flag == 0) { /* 2ܰʹߤγǤʤڤ */
		    strcat(feature_buffer, ";");
		}
		first_arg_flag = 0;
		sprintf(buffer, "%s/U/-/-/-/-", case_str);
		strcat(feature_buffer, buffer);
	    }
	}
	/* Ƥ */
	else {
	    if (first_arg_flag == 0) { /* 2ܰʹߤγǤʤڤ */
		strcat(feature_buffer, ";");
	    }
	    first_arg_flag = 0;
	    /* 㳰 */
	    if (cpm_ptr->elem_b_num[num] <= -2 && cpm_ptr->elem_s_ptr[num] == NULL) {
		sprintf(buffer, "%s/E/%s/-/-/-", case_str, ETAG_name[2]); /* - */
		strcat(feature_buffer, buffer);
	    }
	    else {
		/* άξ (ü쥿ʳ) */
		if (cpm_ptr->elem_b_num[num] <= -2) {
		    sid = cpm_ptr->elem_s_ptr[num]->KNPSID ? 
			cpm_ptr->elem_s_ptr[num]->KNPSID + 5 : NULL;
		    dist_n = sp->Sen_num - cpm_ptr->elem_s_ptr[num]->Sen_num;
		    sent_n = cpm_ptr->elem_s_ptr[num]->Sen_num;
		}
		/* Ʊʸ */
		else {
		    sid = sp->KNPSID ? sp->KNPSID + 5 : NULL;
		    dist_n = 0;
		    sent_n = sp->Sen_num;
		}

		/* λҶ */
		cat_case_analysis_result_parallel_child(feature_buffer, cpm_ptr, i, dist_n, sid);

		if (cpm_ptr->elem_b_ptr[num]->num < 0) { /* ˤʻ礵줿ܶ */
		    elem_b_ptr = cpm_ptr->elem_b_ptr[num];
		    while (elem_b_ptr->num < 0) {
			elem_b_ptr--;
		    }
		    if (elem_b_ptr->num >= cpm_ptr->pred_b_ptr->num) { /* ʻ礵줿ϢνѸȤˤʤäƤޤΤɽ */
			tag_n = -1;
		    }
		    else {
			tag_n = elem_b_ptr->num;
		    }
		}
		else {
		    elem_b_ptr = cpm_ptr->elem_b_ptr[num];
		    tag_n = elem_b_ptr->num;
		}
		word = make_print_string(elem_b_ptr, 0);
		cp = make_cc_string(word ? word : "(null)", tag_n, case_str, 
				    cpm_ptr->elem_b_num[num], dist_n, sid ? sid : "?");
		strcat(feature_buffer, cp);
		free(cp);
		if (word) free(word);
	    }
	}
    }

    assign_cfeature(&(cpm_ptr->pred_b_ptr->f), feature_buffer, temp_assign_flag);
}

/*==================================================================*/
void record_case_analysis(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr, 
			  ELLIPSIS_MGR *em_ptr, int temp_assign_flag)
/*==================================================================*/
{
    /* temp_assign_flag: TRUEΤȤfeatureֲͿפ */

    int i, num;
    char feature_buffer[DATA_LEN], relation[DATA_LEN], *word, *sid, *cp;
    TAG_DATA *elem_b_ptr;

    /* voice  */
    if (cpm_ptr->pred_b_ptr->voice == VOICE_UNKNOWN) {
	decide_voice(sp, cpm_ptr);
    }

    /* ᤫɤå
    check_feature(cpm_ptr->pred_b_ptr->f, "")
    */

    /* ֳʥե졼Ѳץե饰ĤƤʥե졼Ѥ */
    if (cpm_ptr->cmm[0].cf_ptr->etcflag & CF_CHANGE) {
	assign_cfeature(&(cpm_ptr->pred_b_ptr->f), "ʥե졼Ѳ", temp_assign_flag);
    }

    /* ʤfeature */
    assign_feature_samecase(cpm_ptr, temp_assign_flag);

    /* ¦γƳǤε */
    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	/* άϤη̤Ͻ
	   ؼβϤ򤹤ϡؼ */
	if (cpm_ptr->elem_b_num[i] <= -2) {
	    continue;
	}
	/* ˤʻ礵줿Ϣν */
	if (cpm_ptr->elem_b_ptr[i]->num < 0) {
	    elem_b_ptr = cpm_ptr->elem_b_ptr[i];
	    while (elem_b_ptr->num < 0) {
		elem_b_ptr--;
	    }
	    if (elem_b_ptr->num >= cpm_ptr->pred_b_ptr->num) { /* Ϣν */
		continue;
	    }
	}
	else {
	    elem_b_ptr = cpm_ptr->elem_b_ptr[i];
	}

	num = cpm_ptr->cmm[0].result_lists_d[0].flag[i];

	/* Ƥʤ */
	if (num == NIL_ASSIGNED) {
	    continue;
	}
	/* ƤƤ */
	else if (num >= 0) {
	    strcpy(relation, pp_code_to_kstr_in_context(cpm_ptr, cpm_ptr->cmm[0].cf_ptr->pp[num][0]));
	}
	/* else: UNASSIGNED ϤʤϤ */

	/* featureʸͿ */
	if (elem_b_ptr->num < cpm_ptr->pred_b_ptr->num) {
	    sprintf(feature_buffer, "ϳ:%s", relation);
	}
	else {
	    sprintf(feature_buffer, "Ϣ:%s", relation);
	}
	assign_cfeature(&(elem_b_ptr->f), feature_buffer, temp_assign_flag);

	/* feature ѸʸͿ */
	word = make_print_string(elem_b_ptr, 0);
	if (word) {
	    if (elem_b_ptr->num >= 0) {
		sprintf(feature_buffer, "ʴط%d:%s:%s", 
			elem_b_ptr->num, 
			relation, word);
	    }
	    else {
		sprintf(feature_buffer, "ʴط%d:%s:%s", 
			elem_b_ptr->parent->num, 
			relation, word);
	    }
	    assign_cfeature(&(cpm_ptr->pred_b_ptr->f), feature_buffer, temp_assign_flag);
	    free(word);
	}
    }

    /* ʥե졼¦γʲϷ̤ε */
    record_case_analysis_result(sp, cpm_ptr, em_ptr, temp_assign_flag, "ʲϷ:", NULL);

    /* ʲϷ */
    for (i = 0; cpm_ptr->cmm[0].cf_ptr->cf_align[i].cf_id != NULL; i++) {
	sprintf(feature_buffer, "ʲϷ-%d:", i);
	record_case_analysis_result(sp, cpm_ptr, em_ptr, temp_assign_flag, feature_buffer, &(cpm_ptr->cmm[0].cf_ptr->cf_align[i]));
    }
}

/*==================================================================*/
void record_all_case_analisys(SENTENCE_DATA *sp, int temp_assign_flag)
/*==================================================================*/
{
    int i;

    for (i = 0; i < sp->Best_mgr->pred_num; i++) {
	if (sp->Best_mgr->cpm[i].pred_b_ptr == NULL) { /* ҸǤϤʤȽǤΤϥå */
	    continue;
	}
	if ((sp->Best_mgr->cpm[i].result_num != 0 && 
	     sp->Best_mgr->cpm[i].cmm[0].cf_ptr->cf_address != -1 && 
	     (((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	       sp->Best_mgr->cpm[i].cmm[0].score != CASE_MATCH_FAILURE_PROB) || 
	      (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	       sp->Best_mgr->cpm[i].cmm[0].score != CASE_MATCH_FAILURE_SCORE))) || 
	    ((sp->Best_mgr->cpm[i].result_num == 0 || /* ʥե졼ʤʲϷ̤ */
	      sp->Best_mgr->cpm[i].cmm[0].cf_ptr->cf_address == -1))) {
	    record_case_analysis(sp, &(sp->Best_mgr->cpm[i]), NULL, temp_assign_flag);
	}
    }
}

/*==================================================================*/
   void decide_alt_mrph(MRPH_DATA *m_ptr, int alt_num, char *f_str)
/*==================================================================*/
{
    if (alt_num == 0) {
	assign_cfeature(&(m_ptr->f), f_str, FALSE);
    }
    else {
	int alt_count = 1;
	FEATURE *fp = m_ptr->f;
	MRPH_DATA m;

	/* ALTå */
	while (fp) {
	    if (!strncmp(fp->cp, "ALT-", 4)) {
		if (alt_count == alt_num) { /* target */
		    sscanf(fp->cp + 4, "%[^-]-%[^-]-%[^-]-%d-%d-%d-%d-%[^\n]", 
			   m.Goi2, m.Yomi, m.Goi, 
			   &m.Hinshi, &m.Bunrui, 
			   &m.Katuyou_Kata, &m.Katuyou_Kei, m.Imi);
		    /* ߤηǤALT¸ */
		    assign_feature_alt_mrph(&(m_ptr->f), m_ptr);
		    /* ALTǽ̤ηǤˤ */
		    delete_existing_features(m_ptr); /* ߤηfeature */
		    copy_mrph(m_ptr, &m);
		    delete_cfeature(&(m_ptr->f), fp->cp);
		    assign_cfeature(&(m_ptr->f), f_str, FALSE);
		    break;
		}
		alt_count++;
	    }
	    fp = fp->next;
	}
    }
}

/*==================================================================*/
int _noun_lexical_disambiguation_by_case_analysis(CF_PRED_MGR *cpm_ptr, int i, int exact_flag)
/*==================================================================*/
{
    /* ʲϷ̤ۣ̾äԤ

    оݤη: cpm_ptr->elem_b_ptr[i]->head_ptr */

    int num, pos, expand, alt_num, alt_count, rep_length, rep_malloc_flag = 0;
    char *rep_strt, *exd;
    float score, tmp_score;
    FEATURE *fp;
    MRPH_DATA m;

    num = cpm_ptr->cmm[0].result_lists_d[0].flag[i];
    alt_num = -1;
    score = 0;
    alt_count = 0;

    if (!exact_flag) {
	if (check_feature(cpm_ptr->elem_b_ptr[i]->f, "ԸͭŸػ")) {
	    expand = SM_NO_EXPAND_NE;
	}
	else {
	    expand = SM_EXPAND_NE;
	}
    }

    /* ޤߤηǤå */
    if (OptCaseFlag & OPT_CASE_USE_REP_CF) { 
	rep_strt = get_mrph_rep(cpm_ptr->elem_b_ptr[i]->head_ptr); /* ɽɽ */
	rep_length = get_mrph_rep_length(rep_strt);
	if (rep_length == 0) { /* ʤк */
	    rep_strt = make_mrph_rn(cpm_ptr->elem_b_ptr[i]->head_ptr);
	    rep_length = strlen(rep_strt);
	    rep_malloc_flag = 1;
	}
    }
    else {
	rep_strt = cpm_ptr->elem_b_ptr[i]->head_ptr->Goi;
	rep_length = strlen(rep_strt);
    }
    if (rep_strt && rep_length) {
	if (exact_flag) { /* exact matchˤå */
	    if (cf_match_exactly(rep_strt, rep_length, 
				 cpm_ptr->cmm[0].cf_ptr->ex_list[num], 
				 cpm_ptr->cmm[0].cf_ptr->ex_num[num], &pos)) {
		score = cpm_ptr->cmm[0].cf_ptr->ex_freq[num][pos];
		alt_num = alt_count; /* 0 */
	    }
	}
	else { /* ̣Ǥˤå */
	    if (exd = get_str_code_with_len(rep_strt, rep_length, Thesaurus)) {
		score = _calc_similarity_sm_cf(exd, expand, 
					       cpm_ptr->elem_b_ptr[i]->head_ptr->Goi2, 
					       cpm_ptr->cmm[0].cf_ptr, num, &pos);
		if (score > 0) {
		    alt_num = alt_count; /* 0 */
		}
		free(exd);
	    }
	}
    }

    if (rep_malloc_flag) {
	free(rep_strt);
    }

    /* ALTå */
    alt_count++;
    fp = cpm_ptr->elem_b_ptr[i]->head_ptr->f;
    while (fp) {
	if (!strncmp(fp->cp, "ALT-", 4)) {
	    rep_malloc_flag = 0;
	    sscanf(fp->cp + 4, "%[^-]-%[^-]-%[^-]-%d-%d-%d-%d-%[^\n]", 
		   m.Goi2, m.Yomi, m.Goi, 
		   &m.Hinshi, &m.Bunrui, 
		   &m.Katuyou_Kata, &m.Katuyou_Kei, m.Imi);
	    if (OptCaseFlag & OPT_CASE_USE_REP_CF) {
		rep_strt = get_mrph_rep(&m); /* ɽɽ */
		rep_length = get_mrph_rep_length(rep_strt);
		if (rep_length == 0) { /* ʤк */
		    rep_strt = make_mrph_rn(&m);
		    rep_length = strlen(rep_strt);
		    rep_malloc_flag = 1;
		}
	    }
	    else {
		rep_strt = m.Goi;
		rep_length = strlen(rep_strt);
	    }
	    if (rep_strt && rep_length) {
		if (exact_flag) { /* exact matchˤå */
		    if (cf_match_exactly(rep_strt, rep_length, 
					 cpm_ptr->cmm[0].cf_ptr->ex_list[num], 
					 cpm_ptr->cmm[0].cf_ptr->ex_num[num], &pos)) {
			tmp_score = cpm_ptr->cmm[0].cf_ptr->ex_freq[num][pos];
			if (score < tmp_score) {
			    score = tmp_score;
			    alt_num = alt_count;
			}
		    }
		}
		else { /* ̣Ǥˤå */
		    if (exd = get_str_code_with_len(rep_strt, rep_length, Thesaurus)) {
			tmp_score = _calc_similarity_sm_cf(exd, expand, 
							   cpm_ptr->elem_b_ptr[i]->head_ptr->Goi2, 
							   cpm_ptr->cmm[0].cf_ptr, num, &pos);
			if (score < tmp_score) {
			    score = tmp_score;
			    alt_num = alt_count;
			}
			free(exd);
		    }
		}
	    }

	    if (rep_malloc_flag) {
		free(rep_strt);
	    }
	    alt_count++;
	}
	fp = fp->next;
    }

    /*  */
    if (alt_num > -1) {
	decide_alt_mrph(cpm_ptr->elem_b_ptr[i]->head_ptr, alt_num, "ۣ̾");
	return TRUE;
    }
    return FALSE;
}

/*==================================================================*/
void noun_lexical_disambiguation_by_case_analysis(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    int i;

    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	if (!cpm_ptr->elem_b_ptr[i] || 
	    !check_feature(cpm_ptr->elem_b_ptr[i]->head_ptr->f, "ۣ") || /* ۣʷ */
	    check_feature(cpm_ptr->elem_b_ptr[i]->head_ptr->f, "Ѹۣ")) {
	    continue;
	}
	/* άγǡʥե졼ȤޤޥåʤȤʤɤоݤȤʤ */
	else if (cpm_ptr->elem_b_num[i] < -1 || /* άǤϤʤ */
		 cpm_ptr->cmm[0].result_lists_d[0].flag[i] < 0 || /* Ƥ */
		 cpm_ptr->cmm[0].result_lists_p[0].pos[cpm_ptr->cmm[0].result_lists_d[0].flag[i]] == MATCH_SUBJECT || /* <>matchǤϤʤ */
		 ((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && cpm_ptr->cmm[0].result_lists_d[0].score[i] < FREQ0_ASSINED_SCORE) || /* ɬ */
		 (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && cpm_ptr->cmm[0].result_lists_d[0].score[i] <= CF_DECIDE_THRESHOLD) || /* ɬ */
		 check_feature(cpm_ptr->elem_b_ptr[i]->head_ptr->f, "")) { /*äϤƤʤ */
	    continue;
	}

	/* exactޥååۣ̾ */
	if (!_noun_lexical_disambiguation_by_case_analysis(cpm_ptr, i, 1)) {
	    /* ޥạ̊ǤȤۣ̾ */
	    _noun_lexical_disambiguation_by_case_analysis(cpm_ptr, i, 0);
	}
    }
}

/*==================================================================*/
void verb_lexical_disambiguation_by_case_analysis(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    /* ʲϷ̤ѸۣäԤ */

    char *rep_cp;
    FEATURE *fp;
    MRPH_DATA m;

    /* ľʤ1İʾƤƤ뤳ȤȤ */
    if (count_assigned_adjacent_element(cpm_ptr->cmm[0].cf_ptr, &(cpm_ptr->cmm[0].result_lists_p[0])) && 
	(check_feature(cpm_ptr->pred_b_ptr->head_ptr->f, "ۣ") || /* ۣѸ */
	 (check_str_type(cpm_ptr->pred_b_ptr->head_ptr->Goi) == TYPE_HIRAGANA && 
	  check_feature(cpm_ptr->pred_b_ptr->head_ptr->f, "ۣ"))) && /* ۣʤҤ餬 */
	!check_feature(cpm_ptr->pred_b_ptr->head_ptr->f, "")) { /*äϤƤʤ */
	/* ߤηǤǤ褤Ȥ */
	if ((rep_cp = get_mrph_rep(cpm_ptr->pred_b_ptr->head_ptr)) && 
	    !strncmp(rep_cp, cpm_ptr->cmm[0].cf_ptr->entry, 
		     strlen(cpm_ptr->cmm[0].cf_ptr->entry))) {
	    assign_cfeature(&(cpm_ptr->pred_b_ptr->head_ptr->f), "Ѹۣ", FALSE);
	    delete_cfeature(&(cpm_ptr->pred_b_ptr->head_ptr->f), "ۣ̾"); /* к */
	    return;
	}

	/* ߤηɽɽȳʥե졼ɽۤʤΤ߷Ǥѹ */

	fp = cpm_ptr->pred_b_ptr->head_ptr->f;
	while (fp) {
	    if (!strncmp(fp->cp, "ALT-", 4)) {
		sscanf(fp->cp + 4, "%[^-]-%[^-]-%[^-]-%d-%d-%d-%d-%[^\n]", 
		       m.Goi2, m.Yomi, m.Goi, 
		       &m.Hinshi, &m.Bunrui, 
		       &m.Katuyou_Kata, &m.Katuyou_Kei, m.Imi);
		rep_cp = get_mrph_rep(&m);
		/* 򤷤ʥե졼ɽȰפɽɽķǤ */
		if (rep_cp && 
		    !strncmp(rep_cp, cpm_ptr->cmm[0].cf_ptr->entry, 
			     strlen(cpm_ptr->cmm[0].cf_ptr->entry))) {
		    /* ߤηǤALT¸ */
		    assign_feature_alt_mrph(&(cpm_ptr->pred_b_ptr->head_ptr->f), 
					    cpm_ptr->pred_b_ptr->head_ptr);
		    /* ALTǽ̤ηǤˤ */
		    delete_existing_features(cpm_ptr->pred_b_ptr->head_ptr); /* ߤηfeature */
		    copy_mrph(cpm_ptr->pred_b_ptr->head_ptr, &m);
		    delete_cfeature(&(cpm_ptr->pred_b_ptr->head_ptr->f), fp->cp);
		    assign_cfeature(&(cpm_ptr->pred_b_ptr->head_ptr->f), "Ѹۣ", FALSE);
		    delete_cfeature(&(cpm_ptr->pred_b_ptr->head_ptr->f), "ۣ̾"); /* к */
		    break;
		}
	    }
	    fp = fp->next;
	}
    }
}

/*==================================================================*/
       int get_dist_from_work_mgr(BNST_DATA *bp, BNST_DATA *hp)
/*==================================================================*/
{
    int i, dist = 0;

    /* å */
    if (Work_mgr.dpnd.check[bp->num].num == -1) {
	return -1;
    }
    for (i = 0; i < Work_mgr.dpnd.check[bp->num].num; i++) {
	if (Work_mgr.dpnd.check[bp->num].pos[i] == hp->num) {
	    dist = ++i;
	    break;
	}
    }
    if (dist == 0) {
	return -1;
    }
    else if (dist > 1) {
	dist = 2;
    }
    return dist;
}

/*====================================================================
                               END
====================================================================*/
