#!/usr/bin/env perl

use Getopt::Long;
use encoding 'euc-jp';
binmode STDERR, ':encoding(euc-jp)';

######################################################################
#
#		 KNPηǡʸ롼translator
#
#					99/09/10 by kuro@i.kyoto-u.ac.jp
######################################################################
#
# ƹԤnotation
# ==============
#	[ʸ̮]ʬ[ʸ̮]\t+FEATURE
#		 FEATUREɬTABǶڤ
#		 ʸ̮ʬȤʸᤴȤ˶Ƕڤ
#						(ʸ롼ξ)
#		 FEATUREFEATUREȤ˶Ƕڤ
#
#		 ʸ롼ξʸ̮ȸʸ̮θ
#		   Ǥդʸ(?*ư)
#		 ǥ롼ξʸ̮ȸʸ̮θ
#		   Ǥդη(?*ư)
#
# ǡʸnotation
# ======================
#	^....		ʸƬޥå (ʸ롼ξ)
#	<<...>>		ʸfeature
#	<...>		ľηǤfeature (<...>Ȥfeatureλ)
#
#	(...)		0ʾνи (ǥ٥ʸ٥뤽줾)
#	{WORD1|WORD2|..}WORD1 or WORD2 or ...
#			  (Τʻ줬Ʊξ)
#
#	{\ʻ}		ʻ
#	{\ʻ:ʬ}	κʬ
#
#			Ǥդη ( ġĤϵǻȤäƤ)
#			Ǥդη (ǲϤΤ롼ǤϺ)
#
#	WORD_ѸG	ǤդγѸ (Ǥդγѷ)
#	WORD_ѸG	ǤդѸ
#
#	WORD_Ѹg	ʻ,ʬ:*ѷ:ʲΰ̲ѷ:Τޤޡ:*
#			  ư쥿 ) g
#                         --------------------
#				첻ư Ҳư ư ư ư
#				ưޤ ư뷿 ư뷿
#				̵ѷ
#			  ƻ쥿 ) g
#                         -------------------------- 
#			 	ƻ
#				ư̷ ư줯
#			  ʷƻ쥿 ) Ťg
#                         --------------------------
#				ʷƻ ʷƻü ʥηƻ Ƚ
#				ư̷ ư ư줽
#				(̤ΡפˤХüϢΤȤʤ)
#				( ֽư̷פϥƻȥʷƻξ)
#			  ƻ쥿 ) Ʋg
#                         ------------------------------
#				ƻ
#
#	WORD_Ѹg	̾졤̾̾̾Ҹ
#
#	WORD12345	ʻ졤ʬࡤѷѷˤĤƿʬΤ
#			  ) 1235 --> ѷǤ褤
#
#	㳰ࢨ	"#define WORD ̲ͽ"ȤWORDgȲ
#			̤gʤǤΰ̲Ԥ
#			̾졤졤Ͼ˺ʬ̲

# ѷбդ
# -----------------------------------------
# ̵ѷ		ư
# ư̷		ƻ ʷƻ
# ư줯		ƻ
# ưޤ	ư
# ư뷿	ư
# ư뷿	ư

$conj_type[0] = "첻ư Ҳư쥫 Ҳư쥫¥ط Ҳư쥬 Ҳư쥵 Ҳư쥿 Ҳưʹ Ҳưй Ҳư޹ Ҳư Ҳưԥ Ҳư Ҳưʸ첻ط ư ư ư ư ưޤ ư뷿 ư뷿 ̵ѷ";
$conj_type[1] = "ƻ쥢 ƻ쥤 ƻ쥤ü ư̷ ư줯";
$conj_type[2] = "ʷƻ ʷƻü ʥηƻ Ƚ ư̷ ư ư줽";
$conj_type[3] = "ƻ";

# Τ˽񤤤Ƥ褤ȤꤢȤΤ

$pos_repr{"\\̾:̾"} = "";
$pos_repr{"\\̾:Ū̾"} = "";
$pos_repr{"\\"} = "";
$pos_repr{"\\:̾̾"} = "";
$pos_repr{"\\:̾ü"} = "";
$pos_repr{"\\"} = "";
$pos_repr{"\\:ʽ"} = "";
$pos_repr{"\\:"} = "";
$pos_repr{"\\ؼ:ֻ̾ؼ"} = "";
$pos_repr{"\\ؼ:ֻؼ"} = "";
$pos_repr{"\\Ϣλ"} = "ۤ";
$pos_repr{"\\ؼ:Ϣλֻؼ"} = "";
$pos_repr{"\\³"} = "";
$pos_repr{"\\ư"} = "";
$pos_repr{"\\ü:"} = "";

my (%opt);
&GetOptions(\%opt, 'rid');
# --rid: RIDͿ

######################################################################
use KNP;
$knp = new KNP(-Option => "-bnst -tab");
######################################################################
$bnstrule_flag = 1;
$num = 0;

while ( <STDIN> ) {
    
    chomp;
    $num ++;
    next if (/^[\s\t]*\;/ || length($_) == 0);

    if (/^\#define/) {
	@tmp = split;
	if ($tmp[1] eq "ʸ롼") {
	    $bnstrule_flag = 1;
	} 
	elsif ($tmp[1] eq "ǥ롼") {
	    $bnstrule_flag = 0;
	} 
	elsif ($tmp[2] eq "̲ͽ") {
	    $g_define_word{$tmp[1]} = 1;
	} 
	else {
	    die "Invalid define line ($_)!!\n" 
	}
	next;
    }


    # ɽFEATUREȥȤʬΥ
    # 	FEATUREȤδ֤tabȤ ; θ

    if (/^([^\t]+)[\s\t]+([^\;\t]+)[\s\t]*(\;.+)$/) {
	$pattern = $1; $feature = $2; $comment = $3;
    } elsif (/^([^\t]+)[\s\t]+([^\;\t]+)[\s\t]*$/) {
	$pattern = $1; $feature = $2; $comment = "";
    } else {
	print STDERR  "line $num is invalid; $_\n";
	next;
    }
    $pattern =~ s/^\s+//;	# ǰΤ
    $pattern =~ s/\s+$//;	# ǰΤ


    # ʸ̮ȼʬȤʬΥʸ̮[...]

    $pattern =~ /^(\[[^\[\]]+\])?([^\[\]]+)(\[[^\[\]]+\])?$/;
    $tmp1 = $1; $tmp2 = $2; $tmp3 = $3;
    $tmp1 =~ s/^\[|\]$//g;
    @pres = split(/ /, $tmp1);
    $tmp2 =~ s/^\[|\]$//g;
    @self = split(/ /, $tmp2);
    $tmp3 =~ s/^\[|\]$//g;
    @poss = split(/ /, $tmp3);

    # print ">> pre  @pres\n self @self\n post @poss\n\n";

    # ʸ̮ˤ϶ʸ(ϻ?*)

    if ($bnstrule_flag) {
	unshift(@pres, "") if ($pres[0] ne "");
	push(@poss, "") if ($poss[$#poss] ne "");
    } else {
	unshift(@pres, "") if (!@pres);
	push(@poss, "") if (!@poss);
    }	

    @all = (@pres, @self, @poss);

    # ɽĤ

    undef @repr_str;
    foreach (@all) {
	push(@repr_str, bnst_cond($_, 0));
    }

    # MAIN

    print "; $pattern\n";
    print "(\n(";
    # ʸ̮
    for ($i = 0; $i < @pres; $i++) {
	if ($bnstrule_flag) {
	    if ($i == 0) {
		print " ?*";
	    } else {
		bnst_cond($all[$i], 1, $repr_str[$i-1], $repr_str[$i+1]);
	    }
	}
	else {
	    print " ?*";
	    bnst_cond($all[$i], 1, "", $repr_str[$i+1]);
	}
    }	
    print " )\n(";
    # ʬ
    for ($i = @pres; $i < @pres + @self; $i++) {
	bnst_cond($all[$i], 1, $repr_str[$i-1], $repr_str[$i+1]);
    } 
    print " )\n(";
    # ʸ̮
    for ($i = @pres + @self; $i < @all ; $i++) {
	if ($bnstrule_flag) {
	    if ($i == (@all - 1)) {
		print " ?*";
	    } else {
		bnst_cond($all[$i], 1, $repr_str[$i-1], $repr_str[$i+1]);
	    }
	}
	else {
	    bnst_cond($all[$i], 1, $repr_str[$i-1], "");
	    print " ?*";
	}
    }
    print " )\n\t$feature";
    print " RID:$num" if $opt{rid};
    print "\n)\n";
    print "$comment\n" if $comment;
    print "\n";
}

# $juman->close;
# $knp->close;

######################################################################
sub bnst_cond
{
    # ʸξ (flag=1:̾νflag=0:ɽɽ򤫤)

    my ($input, $flag, $l_context, $r_context) = @_;
    my ($ast_flag, $string, $feature);

    # (....) -> ....ast_flagʬΥ

    if ($bnstrule_flag && $input =~ /^\((.+)\)$/) {
	$input = $1;
	$ast_flag = 1;
    } else {
	$ast_flag = 0;
    }


    # ʸFEATUREʬΥ

    if ($input =~ /^\<\<([^\<\>]+)\>\>$/) {
	$string = ""; $feature = $1;
    } elsif ($input =~ /^(.+)\<\<([^\<\>]+)\>\>$/) {
	$string = $1; $feature = $2;
    } else {
	$string = $input; $feature = "";
    }


    # 

    if ($flag) {
	if ($bnstrule_flag) {
	    print " < (";
	    bnst_cond2($string, 1, $l_context, $r_context);
	    printf " )%s >", feature2str($feature);
	    print "*" if $ast_flag;
	} else {
	    bnst_cond2($string, 1, $l_context, $r_context);
	}
    } else {
	return bnst_cond2($string, 0);
    }
}

######################################################################
sub feature2str
{
    my ($input) = @_;

    return "" unless ($input);

    $data = " (";
    foreach (split(/\|\|/, $input)) {
	s/\&\&/ /g;
	$data .= "($_)";
    }
    $data .= ")";
    return $data;
}

######################################################################
sub bnst_cond2
{
    # ʸξ (flag=1:̾νflag=0:ɽɽ򤫤)

    # (|)(||)
    #
    # part: [0][0]:   [1][0]: [2][0]: [3][0]:
    #       [0][1]:           [2][1]:
    #                             [2][1]:
    # 
    # data[0][0]{phrase}: ˤ
    # data[0][1]{phrase}: ˤ
    # data[2][1]{phrase}: ˤ
    # data[2][2]{phrase}: ˤ
    # 
    #  data[0][0]{phrase}Ϥ٤Ƥpart0ܤθ򽸤᤿
    #    data[i][j]{phrase}iܤpartjܤθˤ

    my ($input, $flag, $l_context, $r_context) = @_;
    my (@data, @feature, @mrph);
    my ($i, $j, $k, $l, $error_flag, $any_prefix, $knp_input);

    # Ƭ ^ ǤƬξ

    if ($input =~ s/^\^// || $bnstrule_flag == 0) {
	$any_prefix = 0;
    } else {
	$any_prefix = 1;
    }

    # ǤȤʬ --> @part
    # (,Ť塤>,G,g,θ˶)

    $input =~ s/\(/ \(/g;
    $input =~ s/\)/\) /g;
    $input =~ s/\{/ \{/g;
    $input =~ s/\}/\} /g;
    $input =~ s//  /g;
    $input =~ s/\>/\> /g;
    $input =~ s/G/G /g;
    $input =~ s/g/g /g;

    $input =~ s/(\d+)/\1 /g;
    $input =~ s/(\d) (\))/\1\2/g;
    $input =~ s/(\d) (\<)/\1\2/g;

    $input =~ s/^ +| +$//g;
    @part_str = split(/ +/, $input);
    $part_num = @part_str;

    # @part_str@part(2)

    for ($i = 0; $i < $part_num; $i++) {
	if ($part_str[$i] =~ /^\((.+)\)$/) {
	    $part_str[$i] =  $1;
	    $feature[$i]{ast} = 1;
	}
	elsif ($part_str[$i] =~ /^\{(.+)\}$/) {
	    $part_str[$i] =  $1;
	}

	# ORξɽɽ
	if ($part_str[$i] !~ /^\<\</ && $part_str[$i] =~ /\|/) {
	    @{$part[$i]} = split(/\|/, $part_str[$i]);
	    $feature[$i]{or} = 1;
	}

	# ¾ϼΥ᥿ɽθ
	else {
	    @{$part[$i]} = ($part_str[$i]);

	    if ($part[$i][0] =~ /\<(.+)\>$/) {
		$feature[$i]{lastfeature} = feature2str($1);
		$part[$i][0] =~ s/\<.+\>$//;
	    }
	    if ($part[$i][0] eq "") {
		$feature[$i]{result} = " ?*";
		$part[$i][0] = "";
	    }
	    if ($part[$i][0] =~ /G$/) {
		$feature[$i]{lastGENERAL} = 1;
		$part[$i][0] =~ s/G$//;
	    }
	    if ($part[$i][0] =~ /g$/) {
		$feature[$i]{lastgeneral} = 1;
		$part[$i][0] =~ s/g$//;
	    }
	    if ($part[$i][0] =~ /([\d]+)$/) {
		$feature[$i]{lastnum} = $1;
		$part[$i][0] =~ s/[\d]+$//;
	    }
	    if ($part[$i][0] =~ /^\\/) {
		$feature[$i]{result} = " [$part[$i][0]]";
		$feature[$i]{result} =~ s/\\//;
		$feature[$i]{result} =~ s/\:/ /;
		$part[$i][0] = $pos_repr{$part[$i][0]};
	    }
	}
    }

    # $part[$i][0]ɸǡȤ$data[0][0]

    for ($i = 0; $i < $part_num; $i++) {
	$data[0][0]{phrase} .= $part[$i][0];
	$data[0][0]{length}[$i] = length($part[$i][0]);
    }

    # ɽɽ֤

    return $data[0][0]{phrase} if ($flag == 0);

    # iܤpartjܤθˤΤ$data[i][j]

    for ($i = 0; $i < $part_num; $i++) {
	next unless ($feature[$i]{or});
	for ($j = 1; $j < @{$part[$i]}; $j++) {
	    for ($k = 0; $k < $part_num; $k++) {
		if ($k != $i) {
		    $data[$i][$j]{phrase} .= $part[$k][0];
		    $data[$i][$j]{length}[$k] = length($part[$k][0]);
		} else {
		    $data[$i][$j]{phrase} .= $part[$k][$j];
		    $data[$i][$j]{length}[$k] = length($part[$k][$j]);
		}
	    }
	}
    }

    # 줾KNP(JUMAN)ǽ

    for ($i = 0; $i < $part_num; $i++) {
	for ($j = 0; $j < @{$part[$i]}; $j++) {
	    next unless ($data[$i][$j]);

	    # "|"ʤ""ʳʤ""Ϳ
	    #  ʲ褹뤿
	    #      1. Ϣηʸ᤬ǤJUMANʤ
	    #      2. ñ""Ϳ"Ʊ"촴ˤʤ
	    #      2. ""JUMAN̤
	    #      3. ""JUMAN̤

	    $knp_input = $l_context . $data[$i][$j]{phrase} . $r_context;

	    if($bnstrule_flag){
		if ($knp_input =~ /(|||)$/) {
		    $knp_input .= "";
		} else {
		    $knp_input .= "";
		}
	    }

	    $knp->parse($knp_input); 
	    @knp_result = split(/\n/, $knp->{ALL});

	    # print "\n\n>>>>>$knp_input\n>>>@knp_result\n";

	    $k = 0;
	    foreach $item (@knp_result) { 
		next if ($item =~ /^EOS/);
		# next if ($item =~ /^\@/);
		next if ($item =~ /^(\*|\#|\;)/);
		($mrph[$i][$j][$k]{word}, 
		 $mrph[$i][$j][$k]{yomi}, 
		 $mrph[$i][$j][$k]{base}, 
		 $mrph[$i][$j][$k]{pos}, 
		 $mrph[$i][$j][$k]{d1}, 
		 $mrph[$i][$j][$k]{pos2}, 
		 $mrph[$i][$j][$k]{d2}, 
		 $mrph[$i][$j][$k]{conj}, 
		 $mrph[$i][$j][$k]{d3}, 
		 $mrph[$i][$j][$k]{conj2}, 
		 $mrph[$i][$j][$k]{d4}) = split(/ /, $item);
		$mrph[$i][$j][$k]{length} = length($mrph[$i][$j][$k]{word});
		$mrph[$i][$j][$k]{result} = 
		    " [$mrph[$i][$j][$k]{pos} $mrph[$i][$j][$k]{pos2} $mrph[$i][$j][$k]{conj} $mrph[$i][$j][$k]{conj2} $mrph[$i][$j][$k]{base}]";
		$k++;
	    }

	    # l_contextr_contextǤȤڤƤ뤫å
	    $begin_check = 0;
	    $end_check = 0;
	    $length = 0;
	    for ($k = 0; $mrph[$i][$j][$k]{word}; $k++) {
		if ($length == length($l_context)) {
		    $begin_check = 1;
		    $mrph_start_num = $k;
		} 
		$length += $mrph[$i][$j][$k]{length};
		if ($length == (length($l_context) + 
				   length($data[$i][$j]{phrase}))) {
		    $end_check = 1;
		}
	    }
	    if (!$begin_check || !$end_check) {
		print STDERR "CONTEXT ERROR ($pattern)\n";
		return;
	    }

	    # part  mrph бĤ 
	    # (ˤäORʸ㤦Τǳ$data[$i][$j]ɬ)

	    $part_length = 0;
	    $mrph_length = 0;
	    $k = $mrph_start_num;
	    for ($l = 0; $l < $part_num; $l++) {
		$part_length += $data[$i][$j]{length}[$l];
		$data[$i][$j]{start}[$l] = $k;
		for (; $mrph_length < $part_length; $k++) {
		    $mrph_length += $mrph[$i][$j][$k]{length};
		}
		$data[$i][$j]{end}[$l] = $k - 1;
		# print "($data[$i][$j]{start}[$l] $data[$i][$j]{end}[$l])";
	    }
	}
    }

    # ORʬΥޡ

    $start_pos = 0;
    $error_flag = 0;
    for ($i = 0; $i < $part_num; $i++) {
	if ($feature[$i]{or}) {
	    for ($j = 1; $j < @{$part[$i]}; $j++) {

		# ORηǿΰס OR
		if ($data[0][0]{start}[$i] != $data[$i][$j]{start}[$i] ||
		    $data[0][0]{end}[$i] != $data[$i][$j]{end}[$i] ||
		    $data[0][0]{start}[$i] != $data[0][0]{end}[$i] ||
		    $data[$i][$j]{start}[$i] != $data[$i][$j]{end}[$i] ||
		    @{$mrph[0][0]} != @{$mrph[$i][$j]}) {
		    $error_flag = 1;
		}
		# ORηΰ
		for ($k = 0; $k < $data[0][0]{start}[$i]; $k++) {
		    if ($mrph[0][0][$k]{result} ne $mrph[$i][$j][$k]{result}) {
			$error_flag = 1;
			last;
		    }
		}
		# ORθηΰ
		for ($k = $data[0][0]{end}[$i]+1; $k < @{$mrph[0][0]}; $k++) {
		    if ($mrph[0][0][$k]{result} ne $mrph[$i][$j][$k]{result}) {
			$error_flag = 1;
			last;
		    }
		}

		# ORƱʻ줫
		if ($mrph[0][0][$data[0][0]{start}[$i]]{pos} ne $mrph[$i][$j][$data[$i][$j]{start}[$i]]{pos}) {
		    $error_flag = 1;
		    if ($mrph[0][0][$data[0][0]{start}[$i]]{conj} eq "*" && 
			$mrph[$i][$j][$data[$i][$j]{start}[$i]]{conj} ne "*") {

			# $data[0][0]ɸȤΤǡ$data[0][0]̵ѡ$data[i][j]Ѥξ
			# $data[i][j]wordbase˥ԡ

			$mrph[$i][$j][$data[$i][$j]{start}[$i]]{base} = $mrph[$i][$j][$data[$i][$j]{start}[$i]]{word}
		    }
		}

		$WORD = $mrph[0][0][$data[0][0]{start}[$i]]{base} if ($j == 1);
		$WORD .= " $mrph[$i][$j][$data[$i][$j]{start}[$i]]{base}";
	    }
	    # print "$WORD\n";
	    $mrph[0][0][$data[0][0]{start}[$i]]{base} = "($WORD)";
	}
	$start_pos += $data[0][0]{length}[$i];
    }

    # ORξʤХ顼
    if ($error_flag) {
	for ($i = 0; $i < $part_num; $i++) {
	    for ($j = 0; $j < @{$part[$i]}; $j++) {
		next unless ($data[$i][$j]);
		print STDERR "ERROR($i,$j) ";
		for ($k = 0; $k < @{$mrph[$i][$j]}; $k++) {
		    print STDERR "$mrph[$i][$j][$k]{result}";
		}
		print STDERR "\n";
	    }
	}
	print STDERR "\n";
    }

    # 

    print " ?*" if ($any_prefix && $part[0][0] ne "");

    for ($i = 0; $i < $part_num; $i++) {
	if ($feature[$i]{result}) {
	    print $feature[$i]{result};
	    print "*" if ($feature[$i]{ast});
	}
	else {
	    for ($k = $data[0][0]{start}[$i]; $k <= $data[0][0]{end}[$i]; $k++) {
		if ($k == $data[0][0]{end}[$i] &&
		    $feature[$i]{lastGENERAL}) {
		    if ($mrph[0][0][$k]{conj} ne "*") {
			$mrph[0][0][$k]{result} = " [* * * * * ((Ѹ))]";
		    } else {
			$mrph[0][0][$k]{result} = " [* * * * * ((^Ѹ))]";
		    }
		}
		elsif (($k == $data[0][0]{end}[$i] &&
			$feature[$i]{lastgeneral}) ||
		       $g_define_word{$mrph[0][0][$k]{base}}) {
		    if ($mrph[0][0][$k]{conj} ne "*") {
			$conj_flag = 0;
			for ($m = 0; $m < @conj_type; $m++) {
			    if ($conj_type[$m] =~ /$mrph[0][0][$k]{conj}/) {
				$mrph[0][0][$k]{result} = " [* * ($conj_type[$m]) $mrph[0][0][$k]{conj2} *]";
				$conj_flag = 1;
				last;
			    }
			}
			if (!$conj_flag) {
			    print STDERR "Invalid conjugation type ($mrph[0][0][$k]{conj})!!\n";
			}
		    } else {
			$mrph[0][0][$k]{result} = " [* * * * * ((̾))]";
		    }
		}
		elsif ($k == $data[0][0]{end}[$i] &&
		       $feature[$i]{lastnum}) {
		    if ($feature[$i]{lastnum} =~ /1/) {
			$mrph[0][0][$k]{result} = " [$mrph[0][0][$k]{pos}";
		    } else {
			$mrph[0][0][$k]{result} = " [*";
		    }
		    if ($feature[$i]{lastnum} =~ /2/) {
			$mrph[0][0][$k]{result} .= " $mrph[0][0][$k]{pos2}";
		    } else {
			$mrph[0][0][$k]{result} .= " *";
		    }
		    if ($feature[$i]{lastnum} =~ /3/) {
			$mrph[0][0][$k]{result} .= " $mrph[0][0][$k]{conj}";
		    } else {
			$mrph[0][0][$k]{result} .= " *";
		    }
		    if ($feature[$i]{lastnum} =~ /4/) {
			$mrph[0][0][$k]{result} .= " $mrph[0][0][$k]{conj2}";
		    } else {
			$mrph[0][0][$k]{result} .= " *";
		    }
		    if ($feature[$i]{lastnum} =~ /5/) {
			$mrph[0][0][$k]{result} .= " $mrph[0][0][$k]{base}]";
		    } else {
			$mrph[0][0][$k]{result} .= " *]";
		    }
		}
		elsif ($mrph[0][0][$k]{base} eq "") {
		    $mrph[0][0][$k]{result} = " [ü  * * *]";
		}
		elsif ($mrph[0][0][$k]{base} eq "") {
		    $mrph[0][0][$k]{result} = " [ü  * * *]";
		}
		elsif ($mrph[0][0][$k]{base} eq "") {
		    $mrph[0][0][$k]{result} = " [ü ̻ * * *]";
		}
		elsif ($mrph[0][0][$k]{base} eq "") {
		    $mrph[0][0][$k]{result} = " [ü ̽ * * *]";
		}
		elsif ($mrph[0][0][$k]{base} eq "") {
		    $mrph[0][0][$k]{result} = "";
		}
		else {
		    $mrph[0][0][$k]{pos2} = "*" if ($mrph[0][0][$k]{pos} eq "̾");
		    $mrph[0][0][$k]{pos2} = "*" if ($mrph[0][0][$k]{pos} eq "");
		    $mrph[0][0][$k]{pos2} = "*" if ($mrph[0][0][$k]{pos} eq "");
		    $mrph[0][0][$k]{result} =
			" [$mrph[0][0][$k]{pos} $mrph[0][0][$k]{pos2} $mrph[0][0][$k]{conj} $mrph[0][0][$k]{conj2} $mrph[0][0][$k]{base}]";
		}

		# ǤfeatureꤵƤ
 		if ($k == $data[0][0]{end}[$i] &&
		    $feature[$i]{lastfeature}) {
		    if ($mrph[0][0][$k]{result}) {
			$mrph[0][0][$k]{result} =~ s/\]$/$feature[$i]{lastfeature}\]/;
		    }
		    else {
			$mrph[0][0][$k]{result} = " [* * * * *$feature[$i]{lastfeature}]";
		    }
		}

		print $mrph[0][0][$k]{result};
		print "*" if ($feature[$i]{ast});
	    }

	    if ($feature[$i]{ast} &&
		$data[0][0]{end}[$i] - $data[0][0]{start}[$i] > 0) {
		print STDERR "$input: *ϳƷǤˤĤ\n";
	    }
	}
    }
}

######################################################################
