# -*- perl -*-

use strict;
use Test;

BEGIN { plan tests => 11 }

use KNP::Result;

my $result = <<'__result__';
# S-ID:123
* 1D <BGH:><SM::711006601***71100650****><ʸƬ><><><θ><:γ><:0-4><RID:992><>
ʸ ֤ ʸ ̾ 6 ̾ 1 * 0 * 0 NIL <ʸƬ><><ʴ><Ω><̾>
   ̾ 6 ̾ 2 * 0 * 0 NIL <><ʴ><><Ω><ʣ><̾>
    9 ³ 3 * 0 * 0 NIL <ʴ><Ҥ餬><°>
* 2D <BGH:><SM::31212*******312232******311006b0****><><><θ><:><:0-0><RID:1031><>
 Ĥ줤  ̾ 6 ̾ 1 * 0 * 0 NIL <><ʴ><Ω><̾>
    9 ʽ 1 * 0 * 0 NIL <ʴ><Ҥ餬><°>
* -1D <BGH:><ʸ><><Ѹ:ư><٥:C><:5-5><ID:ʸ><RID:110><:30>
 ᤹  ư 2 * 0 Ҳư쥵 5 ܷ 2 NIL <ɽʸ><ʴ><Ω><Ѹ>
   ü 1  1 * 0 * 0 NIL <ʸ><°>
EOS
__result__

my $x = KNP::Result->new( $result );
ok(defined $x);
ok(scalar($x->mrph) == 7);
ok(join('',map($_->midasi,$x->mrph)) eq 'ʸϤμ򼨤');
ok(scalar($x->bnst) == 3);

$x = undef;
$x = KNP::Result->new( [ map("$_\n",split(/\n/,$result)) ] );
ok(defined $x);
ok($x->bnst == 3);

$x = undef;
$x = new KNP::Result( result => $result );
ok(defined $x);
ok($x->bnst == 3);

ok($x->id == 123);
ok($x->set_id(234) == 234);
ok($x->id == 234);
