# $Id: TList.pm,v 1.2 2006/10/31 08:53:08 shibata Exp $
package KNP::TList;
require 5.004_04; # For base pragma.
use KNP::Tag;
use strict;
use base qw/ KNP::DrawTree KNP::KULM::TList Juman::KULM::MList /;

=head1 NAME

KNP::TList - 󥪥֥

=head1 SYNOPSIS

  $result = new KNP::TList();

=head1 DESCRIPTION

KNP ˤʲϤñ̤Ǥ륿ΥꥹȤݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new( @TAG )

ꤵ줿ΥꥹȤݻ륪֥Ȥ롥ά
ϡΥꥹȤݻ륪֥Ȥ롥

=cut
sub new {
    my $new = bless( {}, shift );
    if( @_ ){
	$new->push_tag( @_ );
    }
    $new;
}

=back

=head1 METHODS

=over 4

=item tag ( NUM )

 I<NUM> ܤΥ֤

=item tag

ƤΥΥꥹȤ֤

=begin comment

C<tag> ᥽åɤμΤϡC<KNP::KULM::TList> 饹Ƥ롥

=end comment

=item tag_list

ƤΥΥꥹȤ֤

=cut
sub tag_list {
    my( $this ) = @_;
    if( defined $this->{tag} ){
	@{$this->{tag}};
    } else {
	wantarray ? () : 0;
    }
}

=item push_tag( @TAG )

ꤵ줿򥿥ɲä롥

=cut
sub push_tag {
    my( $this, @tag ) = @_;
    if( grep( ! $_->isa('KNP::Tag'), @tag ) ){
	die "Illegal type of argument.";
    } elsif( $this->{TLIST_READONLY} ){
	die;
    } else {
	push( @{ $this->{tag} ||= [] }, @tag );
    }
}

=item mrph ( NUM )

 I<NUM> ܤηǤ֤

=item mrph

ƤηǤΥꥹȤ֤

=begin comment

C<mrph> ᥽åɤμΤ C<Juman::KULM::MList> Ƥ롥

=end comment

=item mrph_list

ƤηǤΥꥹȤ֤

=cut
sub mrph_list {
    map( $_->mrph_list, shift->tag_list );
}

=item push_mrph( @MRPH )

ꤵ줿ǤʸɲäΥηȤƤĹ֤
ɲоݤȤʤ륿¸ߤʤ(= 󤬶Ǥ)ϡɲäϹԤ
ʤ

=cut
sub push_mrph {
    my( $this, @mrph ) = @_;
    if( $this->tag_list ){
	( $this->tag_list )[-1]->push_mrph( @mrph );
    } else {
	0;
    }
}

=item set_readonly

Ф񤭹ߤԵĤꤹ롥

=cut
sub set_readonly {
    my( $this ) = @_;
    for my $tag ( $this->tag_list ){
	$tag->set_readonly();
    }
    $this->{TLIST_READONLY} = 1;
}

=item spec

ʸѴ롥

=cut
sub spec {
    my( $this ) = @_;
    join( '', map( $_->spec, $this->tag_list ) );
}

=item draw_tree

=item draw_tag_tree

ΰ¸طڹ¤ȤɽƽϤ롥

=cut
sub draw_tag_tree {
    shift->draw_tree( @_ );
}

# draw_tree ᥽åɤȤ̿ѤΥ᥽åɡ
sub draw_tree_leaves {
    shift->tag_list( @_ );
}

sub set_nodestroy {
    shift->{TLIST_NODESTROY} = 1;
}

=back

=head1 DESTRUCTOR

֥ȴ֤˴ľΥե󥹤ȡ̾ Garbage
Collection ˤäƤϥ꤬ʤʤ롥򤱤뤿ˡ
Ū˥ե󥹤˲ destructor Ƥ롥

=cut
sub DESTROY {
    my( $this ) = @_;
    unless( $this->{TLIST_NODESTROY} ){
	grep( ref $_ && $_->isa('KNP::Tag') && $_->DESTROY, $this->tag_list );
    }
}

=head1 SEE ALSO

=over 4

=item *

L<KNP::Tag>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
