# $Id: SynNodes.pm,v 1.2 2008/10/08 02:06:10 shibata Exp $
package KNP::SynNodes;

require 5.004_04; # For base pragma.
use strict;
use Encode;

=head1 NAME

KNP::SynNodes - SynNodes in KNP

=head1 DESCRIPTION

SynNodes(SynNodeν)γƼݻ륪֥ȡ

=cut
sub new {
    my( $class, $str ) = @_;

    my $this = {};

    my $midasi_pat = 'Ф';
    if( utf8::is_utf8( $str ) ){
	$midasi_pat = decode('euc-jp', $midasi_pat);
    }

    # !! 0 1D <Ф:ݲ><ʲϷ:>
    my ($tagid, $dpnd, $string) = (split(' ', $str))[1,2,3];
    my @tagids = split(',', $tagid);

    my ($parent, $dpndtype, @parentids);
    if ($dpnd =~ /^([\-\,\/\d]+)([DPIA])$/) {
	$parent = $1;
	$dpndtype = $2;

	# 褬ʣ礬
	for (split('/', $parent)) {
	    # бܶIDʣ礬
	    push @parentids, [split(',', $_)];
	}
    }
    else {
	die "KNP::SynGraph: Illegal dpnd = $dpnd\n";
    }

    my ($midasi, @features);
    while ($string =~ /(<.+?>)/g) {
	my $s = $1;
	# Ф
	if ($s =~ /<$midasi_pat:(.+?)>/) {
	    $midasi = $1;
	}
	# ¾feature
	else {
	    push @features, $s;
	}
    }

    $this->{tagid} = $tagid;
    $this->{tagids} = \@tagids;
    $this->{parent} = $parent;
    $this->{parentids} = \@parentids;
    $this->{dpndtype} = $dpndtype;
    $this->{midasi} = $midasi;
    $this->{feature} = join('', @features);

    bless $this, $class;
}

=head1 METHODS

ʲΥ᥽åɤѲǽǤ롣

=over 4

=item push_synnode

SynΡɤɲä

=cut
sub push_synnode {
    my ($this, $synnode) = @_;

    push @{$this->{synnode}}, $synnode;
}

=item synnode

ƤSynΡɤ֤

=cut
sub synnode {
    my ($this) = @_;

    if( defined $this->{synnode} ){
	@{$this->{synnode}};
    } else {
	wantarray ? () : 0;
    }
}

=item tagid

бܶID֤

=cut
sub tagid {
    my ($this) = @_;
    $this->{tagid};
}

=item tagids

бܶID()֤

=cut
sub tagids {
    my ($this) = @_;
    @{$this->{tagids}};
}

=item parent

δܶID֤

=cut
sub parent {
    my ($this) = @_;
    $this->{parent};
}

=item parentids

δܶID()֤

=cut
sub parentids {
    my ($this) = @_;
    @{$this->{parentids}};
}

=item dpndtype

¸طμ(D,P,I,A)֤

=cut
sub dpndtype {
    my ($this) = @_;
    $this->{dpndtype};
}

=item midasi

Ф֤

=cut
sub midasi {
    my ($this) = @_;
    $this->{midasi};
}

=item feature

ʸˡ֤

=cut
sub feature {
    my ($this) = @_;
    $this->{feature};
}

=back

=head1 AUTHOR

=over 4

=item
 ν <shibata@nlp.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
