# $Id: SynNode.pm,v 1.2 2008/10/08 02:06:10 shibata Exp $
package KNP::SynNode;
require 5.004_04; # For base pragma.
use strict;
use Encode;

=head1 NAME

KNP::SynNode - SynNode in KNP

=head1 DESCRIPTION

SynNodeγƼݻ륪֥ȡ

=cut
sub new {
    my( $class, $str ) = @_;
    my $this = {};

    my $score_pat = '';
    if( utf8::is_utf8( $str ) ){
	$score_pat = decode('euc-jp', $score_pat);
    }

    # ! 1 <SYNID:ᤤ/><:1>
    # ! 1 <SYNID:s199:Ƥ/><:0.99>
    # ! 1 <SYNID:s1201:/礶><:0.693>≮>≮:323>
    my ($tagid, $string) = (split(' ', $str))[1,2];
    my @tagids = split(',', $tagid);

    my ($synid, $score, @features);
    while ($string =~ /(<.+?>)/g) {
	my $s = $1;
	# SYNID
	if ($s =~ /<SYNID:(.+?)>/) {
	    $synid = $1;
	}
	elsif ($s =~ /<$score_pat:(.+?)>/) {
	    $score = $1;
	}
	# ¾feature
	else {
	    push @features, $s;
	}
    }

    $this->{synid} = $synid;
    $this->{tagid} = $tagid;
    $this->{tagids} = \@tagids;
    $this->{score} = $score;
    $this->{feature} = join('', @features);

    bless $this, $class;
}

=head1 METHODS

ʲΥ᥽åɤѲǽǤ롣

=over 4

=item tagid

бܶID֤

=cut
sub tagid {
    my ($this) = @_;
    $this->{tagid};
}

=item tagids

бܶID()֤

=cut
sub tagids {
    my ($this) = @_;
    @{$this->{tagids}};
}

=item synid

SynID֤

=cut
sub synid {
    my ($this) = @_;
    $this->{synid};
}

=item score

֤

=cut
sub score {
    my ($this) = @_;
    $this->{score};
}

=item feature

ʸˡ֤

=cut
sub feature {
    my ($this) = @_;
    $this->{feature};
}

=back

=head1 AUTHOR

=over 4

=item
 ν <shibata@nlp.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
