# $Id: Simple.pm,v 1.2 2006/10/31 08:46:56 shibata Exp $
package KNP::Simple;
require 5.004_04; # For base pragma.
use KNP;
use strict;
use base qw/ Exporter /;
use vars qw/ @EXPORT /;
@EXPORT = qw/ knp /;

=head1 NAME

KNP::Simple - ʸϤԤ⥸塼

=head1 DESCRIPTION

C<KNP::Simple> ϡKNP ѤƹʸϤԤؿ C<knp> 
塼Ǥ롥

Υ⥸塼ȤȡC<KNP> ⥸塼ñˡ¤줿
Ѥ뤳ȤǤ롥㤨СΥ⥸塼ϡǽ˺ 
C<KNP> ֥ȤѤΤǡץѹʤɤϤǤ
٤ǹʸϤԤɬפϡC<KNP> ⥸塼
ľܸƤӽФȡ

=head1 FUNCTION

=over 4

=item knp ($str)

ꤵ줿ʸоݤȤƹʸϤԤؿC<KNP::Result> ֥
Ȥ֤

  Example:

    use KNP::Simple;
    $result = &knp( "ʸʸϤƤ" );
    print $result->all();

ʸϤΥץѹϡC<use> λǻꤷƤ

  Example:

    use KNP::Simple -Option => "-tab -case2";
    $result = &knp( "ʸʸϤƤ" );
    print $result->all();

ץˤϡC<KNP::new> μդ륪ץƱΤǤ
롥

=cut
my @OPTION;
my $KNP;

sub import {
    my $class = shift;
    @OPTION = @_;
    $class->export_to_level( 1 );
}

sub knp {
    my( $str ) = @_;
    $KNP ||= KNP->new( @OPTION );
    $KNP->parse( $str );
}

1;

=back

=head1 SEE ALSO

=over 4

=item *

L<KNP>

=item *

L<KNP::Result>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
