# $Id: Morpheme.pm,v 1.6 2009/01/23 02:30:30 shibata Exp $
package KNP::Morpheme;
require 5.004_04; # For base pragma.
use strict;
use base qw/ KNP::Fstring KNP::KULM::Morpheme Juman::Morpheme KNP::Depend /;
use vars qw/ @ATTRS /;
use Juman::Hinsi qw/ get_hinsi get_bunrui get_type get_form /;
use Encode;

=head1 NAME

KNP::Morpheme - ǥ֥ in KNP

=head1 SYNOPSIS

  $m = new KNP::Morpheme( "   ̾ 6 ̾ 2 * 0 * 0 NIL <ʸƬ>", 1 );

=head1 DESCRIPTION

ǤγƼݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( SPEC, ID )

1 C<SPEC>  KNP νϤƸƤӽФȡιԤƤ
ǥ֥Ȥ롥

=cut

@ATTRS = ( 'fstring' );

sub _alt2spec {
    my( $str ) = @_;
    my( $midasi, $yomi, $genkei, $hinsi_id, $bunrui_id, $katuyou1_id, $katuyou2_id, $imis ) = split( '-', $str , 8);
    my $hinsi = &get_hinsi( $hinsi_id );
    my $bunrui = &get_bunrui( $hinsi_id, $bunrui_id );
    my $katuyou1 = &get_type( $katuyou1_id );
    my $katuyou2 = &get_form( $katuyou1_id, $katuyou2_id );
    if( utf8::is_utf8( $str ) ){
	$hinsi = decode('euc-jp', $hinsi);
	$bunrui = decode('euc-jp', $bunrui);
	$katuyou1 = decode('euc-jp', $katuyou1);
	$katuyou2 = decode('euc-jp', $katuyou2);
    }

    return join( ' ', $midasi, $yomi, $genkei, $hinsi, $hinsi_id, $bunrui, $bunrui_id, 
		 $katuyou1, $katuyou1_id, $katuyou2, $katuyou2_id, $imis );
}

sub new {
    my( $class, $spec, $id, $parent, $type ) = @_;
    my $this = { id => $id };

    # ALTɸJUMANѴ
    if ($spec =~ /^ALT-(.+)/){
	$spec = _alt2spec($1);
    }

    my @value;
    my( @keys ) = @Juman::Morpheme::ATTRS;
    push( @keys, @ATTRS );
    $spec =~ s/\s*$//;
    if( $spec =~ s/^\\ \\ \\ ü 1  6 // ){
	@value = ( '\ ', '\ ', '\ ', 'ü', '1', '', '6' );
	push( @value, split( / /, $spec, scalar(@keys) - 7 ) );
    } else {
#	@value = split( / /, $spec, scalar(@keys) );

	# ̣""ǤƤ
	
	# ʲΤ褦ʾб뤿ɽ

	# ä ä  ư 2 * 0 Ҳư 12  8 "ɽɽ:" <ɽɽ:><ۣ><ALT-ä-ä--2-0-12-8-"°ưʴܡ ɽɽ:礦"><ALT-ä-ä--2-0-10-8-"ʸ ɽɽ:ͭ"><ۣ><ۣ-ư><ۣ-¾><°ư><ʴ><Ҥ餬><Ѹ><Ω><Ω><ñ̻><ʸ>

	while ($spec =~ s/\"([^\"\s]+)(\s)([^\"]+)\"/\"$1\@\@$3\"/) {
	    ;
	}
	@value = split( / /, $spec);
	$value[11] =~ s/\@\@/ /g;
	$value[12] =~ s/\@\@/ /g;

#	@value = &quotewords(" ", 1, $spec);
    }
    while( @keys and @value ){
	my $key = shift @keys;
	$this->{$key} = shift @value;
    }

    &KNP::Fstring::fstring( $this, $this->{fstring} );
    bless $this, $class;

    # for mrphtab
     if (defined $parent && defined $type) {
 	$this->dpndtype( $type );
 	$this->parent_id( $parent );
     }
    $this;
}

=back

=head1 METHODS

L<Juman::Morpheme> γƥ᥽åɤ˲äơKNP ˤäƳƤ줿
ħʸ򻲾Ȥ뤿Υ᥽åɤѲǽǤ롥

=over 4

=item fstring

ħʸ֤

=item feature

ħΥꥹȤ֤

=item push_feature

ħɲä롥

=back

Υ᥽åɤξܺ٤ˤĤƤϡL<KNP::Fstring> 򻲾ȤΤȡˡ
ʲΥ᥽åɤѲǽǤ롥

=over 4

=item repname

Ǥɽɽ֤

=cut

sub repname {
    my ( $this ) = @_;

    my $result = $this->Juman::Morpheme::repname;
    return $result if ( defined $result );

    my $pat = '()ɽɽ';
    if( utf8::is_utf8( $this->midasi ) ){
	$pat = decode('euc-jp', $pat);
    }

    if ( defined $this->{fstring} ){
	if ($this->{fstring} =~ /<$pat:([^\>]+)>/){
	    return $2;
	}
    }
    return undef;
}

=back

=item spec

ǤƤνؼʸ롥KNP νϤ1Ԥ
롥

=cut

sub spec {
    my( $this ) = @_;
    sprintf( "%s\n", join( ' ', map( $this->{$_}, ( @Juman::Morpheme::ATTRS, @ATTRS ) ) ) );
}

=head1 SEE ALSO

=over 4

=item *

L<KNP::Fstring>

=item *

L<Juman::Morpheme>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
