# $Id: Depend.pm,v 1.2 2009/06/17 01:29:48 kawahara Exp $
package KNP::Depend;
require 5.000;
use strict;

=head1 NAME

KNP::Depend - ¸طݻȤ

=head1 SYNOPSIS

Υ饹ߥ󥰤ƻѤ롥

=head1 DESCRIPTION

C<KNP::Depend> 饹ϡñ(ʸᡤ)֤ΰ¸طݻ
뤿Υ᥽åɤ󶡤륯饹Ǥ롥

=head1 CONSTRUCTOR

Υ饹ϥߥ󥰤ƻѤ褦߷פƤ뤿ᡤ̤ʥ
ȥ饯Ƥʤ

=head1 METHODS

=over 4

=item parent

֤

=item parent [ UNIT ]

ꤹ롥

=cut
sub parent {
    my $this = shift;
    if( @_ ){
	$this->{parent} = shift;
    } elsif( defined $this->{parent} ){
	$this->{parent};
    } else {
	undef;
    }
}

=item child

긵ΥꥹȤ֤

=item child [ UNIT... ]

긵ꤹ롥

=cut
sub child {
    my $this = shift;
    if( @_ ){
	$this->{child} = [ @_ ];
	@{$this->{child}};
    } elsif( defined $this->{child} ){
	@{$this->{child}};
    } else {
	wantarray ? () : 0;
    }
}

=item dpndtype

¸طμ(D,P,I,A)֤

=item dpndtype [ STRING ]

¸طμꤹ롥

=cut
sub dpndtype {
    my $this = shift;
    if( @_ ){
	$this->{dpndtype} = shift;
    } elsif( defined $this->{dpndtype} ){
	$this->{dpndtype};
    } else {
	undef;
    }
}

=item id

ñ̤ ID ̵֤ξ -1 ֤

=item id [ STRING ]

ñ̤ ID ꤹ롥

=cut
sub id {
    my $this = shift;
    if( @_ ){
	$this->{id} = shift;
    } elsif( defined $this->{id} ){
	$this->{id};
    } else {
	-1;
    }
}

=item pstring

=item pstring [ STRING ]

ñ̤ I<pstring> °ͤ롥ꤵ줿ϡΰ
롥°ϡC<KNP::DrawTree::draw_tree> ᥽åɤ黲Ȥ
롥

=cut
sub pstring {
    my $this = shift;
    if( @_ ){
	$this->{_pstring} = shift;
    } elsif( defined $this->{_pstring} ){
	$this->{_pstring};
    } else {
	undef;
    }
}

=back

=head1 INTERNAL METHODS

ʲΥ᥽åɤϡñ̤ΥꥹȤݻ륪֥
(C<KNP::BList>, C<KNP::TList>)Υ󥹥ȥ饯ƤӽФ뤳Ȥ
ꤷƤ᥽åɤǤ롥̤ѤϿ侩ʤ

=over 4

=item parent_id

ñ̤ ID ֤

=item parent_id [ STRING ]

ñ̤ ID ꤹ롥

=cut
sub parent_id {
    my $this = shift;
    if( @_ ){
	my $value = shift;
	if( my $parent = $this->parent() ){
	    $parent->id( $value );
	} elsif( defined $value ){
	    $this->{_parent_id} = $value;
	} else {
	    # ̤ͤꤵ줿ϡϥå夫ͤ
	    delete $this->{_parent_id};
	    $value;
	}
    } elsif( my $parent = $this->parent() ){
	$parent->id();
    } elsif( defined $this->{_parent_id} ){
	$this->{_parent_id};
    } else {
	-1;
    }
}

=item make_reference( LISTREF )

ñ̤η褬ե󥹤ȤƻȤ褦ˡ֥
Ȥ롥ñ̤ޤޤꥹȤФե
ȤƸƤӽФ

=cut
sub make_reference {
    my( $this, $list ) = @_;
    my $parent_id = $this->parent_id();
    if( defined $parent_id ){
	$this->parent_id( undef );
	if( $parent_id >= 0 ){
	    my $parent = $list->[ $parent_id + $[ ];
	    $this->{parent} = $parent;
	    push( @{$parent->{child}}, $this );
	}
    }
}

=back

=head1 DESTRUCTOR

C<make_reference> ᥽åɤˤäƴľΥե󥹤ȡ
 Garbage Collection ˤäƤϡ꤬ʤʤ롥
򤱤뤿ˡŪ˥ե󥹤˲ destructor Ƥ
롥

=cut
sub DESTROY {
    my( $this ) = @_;
    delete $this->{parent};
    delete $this->{child};
}

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
