# generated by gen-config.py DO NOT edit

# isort: skip_file
import typing
from kittens.ssh.options.utils import copy, env, hostname
from kitty.conf.utils import merge_dicts, to_bool


class Parser:

    def askpass(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        val = val.lower()
        if val not in self.choices_for_askpass:
            raise ValueError(f"The value {val} is not a valid choice for askpass")
        ans["askpass"] = val

    choices_for_askpass = frozenset(('unless-set', 'ssh', 'native'))

    def color_scheme(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['color_scheme'] = str(val)

    def copy(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        for k, v in copy(val, ans["copy"]):
            ans["copy"][k] = v

    def cwd(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['cwd'] = str(val)

    def env(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        for k, v in env(val, ans["env"]):
            ans["env"][k] = v

    def hostname(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        hostname(val, ans)

    def interpreter(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['interpreter'] = str(val)

    def login_shell(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['login_shell'] = str(val)

    def remote_dir(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['remote_dir'] = str(val)

    def remote_kitty(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        val = val.lower()
        if val not in self.choices_for_remote_kitty:
            raise ValueError(f"The value {val} is not a valid choice for remote_kitty")
        ans["remote_kitty"] = val

    choices_for_remote_kitty = frozenset(('if-needed', 'no', 'yes'))

    def share_connections(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['share_connections'] = to_bool(val)

    def shell_integration(self, val: str, ans: typing.Dict[str, typing.Any]) -> None:
        ans['shell_integration'] = str(val)


def create_result_dict() -> typing.Dict[str, typing.Any]:
    return {
        'copy': {},
        'env': {},
    }


actions: typing.FrozenSet[str] = frozenset(())


def merge_result_dicts(defaults: typing.Dict[str, typing.Any], vals: typing.Dict[str, typing.Any]) -> typing.Dict[str, typing.Any]:
    ans = {}
    for k, v in defaults.items():
        if isinstance(v, dict):
            ans[k] = merge_dicts(v, vals.get(k, {}))
        elif k in actions:
            ans[k] = v + vals.get(k, [])
        else:
            ans[k] = vals.get(k, v)
    return ans


parser = Parser()


def parse_conf_item(key: str, val: str, ans: typing.Dict[str, typing.Any]) -> bool:
    func = getattr(parser, key, None)
    if func is not None:
        func(val, ans)
        return True
    return False
