-- This file is part of Kitlist, a program to maintain a simple list
-- of items and assign items to one or more categories.

-- Copyright (C) 2008,2009 Frank Dean

-- Kitlist is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- Kitlist is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with Kitlist.  If not, see <http://www.gnu.org/licenses/>.


--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

--
-- Name: category_sequence; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE category_sequence
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: category; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE category (
    id integer DEFAULT nextval('category_sequence'::regclass) NOT NULL,
    name character varying(40) NOT NULL
);


--
-- Name: category_item; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE category_item (
    category integer NOT NULL,
    item integer NOT NULL
);


--
-- Name: item_sequence; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE item_sequence
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: item; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE item (
    id integer DEFAULT nextval('item_sequence'::regclass) NOT NULL,
    description text NOT NULL,
    checked boolean DEFAULT false
);


--
-- Name: category_item_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY category_item
    ADD CONSTRAINT category_item_pkey PRIMARY KEY (category, item);


--
-- Name: category_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY category
    ADD CONSTRAINT category_pkey PRIMARY KEY (id);


--
-- Name: item_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY item
    ADD CONSTRAINT item_pkey PRIMARY KEY (id);


--
-- Name: category_item_category_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY category_item
    ADD CONSTRAINT category_item_category_fkey FOREIGN KEY (category) REFERENCES category(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: category_item_item_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY category_item
    ADD CONSTRAINT category_item_item_fkey FOREIGN KEY (item) REFERENCES item(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: public; Type: ACL; Schema: -; Owner: -
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

