/*

    This file is part of Kitlist, a program to maintain a simple list
    of items and assign items to one or more categories.

    Copyright (C) 2008,2009 Frank Dean

    Kitlist is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Kitlist is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Kitlist.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef PRINTING_H
#define PRINTING_H

#include "item.hpp"
#include <gtkmm/printcontext.h>
#include <gtkmm/printoperation.h>

typedef Glib::RefPtr<Pango::Layout> layout_refptr;

/**
 * \brief Prints the kitlist
 */
class KitPrintOperation : public Gtk::PrintOperation {
    ItemContainer* m_items;
    Glib::ustring m_page_title;
public:
    static Glib::RefPtr<KitPrintOperation> create();
    /// Sets the list of items to be printed
    void set_items(ItemContainer* items) {m_items = items;}
    void set_page_title(const Glib::ustring page_title) {m_page_title = page_title;}
    ~KitPrintOperation();
protected:
    layout_refptr new_header(const Glib::RefPtr<Gtk::PrintContext>& context);
    layout_refptr new_footer(const Glib::RefPtr<Gtk::PrintContext>& context);
    virtual void on_begin_print(const Glib::RefPtr<Gtk::PrintContext>& context);
    virtual void on_draw_page(const Glib::RefPtr<Gtk::PrintContext>& context, int page_number);
    /// A layout to hold the body of the entire kitlist to be printed
    layout_refptr m_ref_layout;
    /// A list of line numbers where a page break is required
    std::vector<int> m_page_breaks;
    /// A list of headers, one for each page
    std::vector<layout_refptr> m_ref_headers;
    /// A list of footers, one for each page
    std::vector<layout_refptr> m_ref_footers;
};

#endif //PRINTING_H
