//Auto-generated by kalyptus. DO NOT EDIT.
namespace DOM {
	using Kimono;
	using System;
	using Qyoto;
	/// <remarks>
	///  By far the vast majority of objects (apart from text) that authors
	///  encounter when traversing a document are <code>Element</code>
	///  nodes. Assume the following XML document: &lt;elementExample
	///  id=&quot;demo&quot;&gt; &lt;subelement1/&gt;
	///  &lt;subelement2&gt;&lt;subsubelement/&gt;&lt;/subelement2&gt;
	///  &lt;/elementExample&gt;
	///   When represented using DOM, the top node is an <code>Element</code>
	///  node for &quot;elementExample&quot;, which contains two
	///  child <code>Element</code> nodes, one for &quot;subelement1&quot;
	///  and one for &quot;subelement2&quot;. &quot;subelement1&quot;
	///  contains no child nodes.
	///   Elements may have attributes associated with them; since the
	///  <code>Element</code> interface inherits from <code>Node</code>
	///  , the generic <code>Node</code> interface method
	///  <code>getAttributes</code> may be used to retrieve the set of all
	///  attributes for an element. There are methods on the <code>Element</code>
	///  interface to retrieve either an <code>Attr</code> object
	///  by name or an attribute value by name. In XML, where an attribute
	///  value may contain entity references, an <code>Attr</code> object
	///  should be retrieved to examine the possibly fairly complex sub-tree
	///  representing the attribute value. On the other hand, in HTML, where
	///  all attributes have simple string values, methods to directly
	///  access an attribute value can safely be used as a convenience.
	///  </remarks>		<short>    By far the vast majority of objects (apart from text) that authors  encounter when traversing a document are <code>Element</code>  nodes.</short>
	[SmokeClass("DOM::Element")]
	public class Element : DOM.Node, IDisposable {
 		protected Element(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(Element), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static Element() {
			staticInterceptor = new SmokeInvocation(typeof(Element), null);
		}
		// DOM::Element* Element(DOM::ElementImpl* arg1); >>>> NOT CONVERTED
		public Element() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Element", "Element()", typeof(void));
		}
		public Element(DOM.Node other) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Element#", "Element(const DOM::Node&)", typeof(void), typeof(DOM.Node), other);
		}
		public Element(DOM.Element other) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Element#", "Element(const DOM::Element&)", typeof(void), typeof(DOM.Element), other);
		}
		/// <remarks>
		///  The name of the element. For example, in: &lt;elementExample
		///  id=&quot;demo&quot;&gt; ... &lt;/elementExample&gt; ,
		///  <code>tagName</code> has the value <code>&quot;elementExample&quot;</code>
		///  . Note that this is case-preserving in XML, as are all
		///  of the operations of the DOM. The HTML DOM returns the
		///  <code>tagName</code> of an HTML element in the canonical uppercase
		///  form, regardless of the case in the source HTML document.
		///      </remarks>		<short>    The name of the element.</short>
		public DOM.DOMString TagName() {
			return (DOM.DOMString) interceptor.Invoke("tagName", "tagName() const", typeof(DOM.DOMString));
		}
		/// <remarks>
		///  Retrieves an attribute value by name.
		/// <param> name="name" The name of the attribute to retrieve.
		/// </param>     </remarks>		<return> The <code>Attr</code> value as a string, or the empty
		///  string if that attribute does not have a specified or default
		///  value.
		/// </return>
		/// 		<short>    Retrieves an attribute value by name.</short>
		public DOM.DOMString GetAttribute(DOM.DOMString name) {
			return (DOM.DOMString) interceptor.Invoke("getAttribute#", "getAttribute(const DOM::DOMString&)", typeof(DOM.DOMString), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Adds a new attribute. If an attribute with that name is already
		///  present in the element, its value is changed to be that of the
		///  value parameter. This value is a simple string, it is not
		///  parsed as it is being set. So any markup (such as syntax to be
		///  recognized as an entity reference) is treated as literal text,
		///  and needs to be appropriately escaped by the implementation
		///  when it is written out. In order to assign an attribute value
		///  that contains entity references, the user must create an
		///  <code>Attr</code> node plus any <code>Text</code> and
		///  <code>EntityReference</code> nodes, build the appropriate subtree,
		///  and use <code>setAttributeNode</code> to assign it as the
		///  value of an attribute.
		/// <param> name="name" The name of the attribute to create or alter.
		/// </param><param> name="value" Value to set in string form.
		/// </param>  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
		///      </remarks>		<short>    Adds a new attribute.</short>
		public void SetAttribute(DOM.DOMString name, DOM.DOMString value) {
			interceptor.Invoke("setAttribute##", "setAttribute(const DOM::DOMString&, const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), name, typeof(DOM.DOMString), value);
		}
		/// <remarks>
		///  Removes an attribute by name. If the removed attribute has a
		///  default value it is immediately replaced.
		/// <param> name="name" The name of the attribute to remove.
		/// </param>     </remarks>		<short>    Removes an attribute by name.</short>
		public void RemoveAttribute(DOM.DOMString name) {
			interceptor.Invoke("removeAttribute#", "removeAttribute(const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Retrieves an <code>Attr</code> node by name.
		/// <param> name="name" The name of the attribute to retrieve.
		/// </param>     </remarks>		<return> The <code>Attr</code> node with the specified
		///  attribute name or <code>null</code> if there is no such
		///  attribute.
		/// </return>
		/// 		<short>    Retrieves an <code>Attr</code> node by name.</short>
		public DOM.Attr GetAttributeNode(DOM.DOMString name) {
			return (DOM.Attr) interceptor.Invoke("getAttributeNode#", "getAttributeNode(const DOM::DOMString&)", typeof(DOM.Attr), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Adds a new attribute. If an attribute with that name is already
		///  present in the element, it is replaced by the new one.
		/// <param> name="newAttr" The <code>Attr</code> node to add to the
		///  attribute list.
		/// </param>  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
		///   INUSE_ATTRIBUTE_ERR: Raised if <code>newAttr</code> is
		///  already an attribute of another <code>Element</code> object.
		///  The DOM user must explicitly clone <code>Attr</code> nodes to
		///  re-use them in other elements.
		///      </remarks>		<return> If the <code>newAttr</code> attribute replaces an
		///  existing attribute with the same name, the previously existing
		///  <code>Attr</code> node is returned, otherwise <code>null</code>
		///  is returned.
		/// </return>
		/// 		<short>    Adds a new attribute.</short>
		public DOM.Attr SetAttributeNode(DOM.Attr newAttr) {
			return (DOM.Attr) interceptor.Invoke("setAttributeNode#", "setAttributeNode(const DOM::Attr&)", typeof(DOM.Attr), typeof(DOM.Attr), newAttr);
		}
		/// <remarks>
		///  Removes the specified attribute.
		/// <param> name="oldAttr" The <code>Attr</code> node to remove from the
		///  attribute list. If the removed <code>Attr</code> has a
		///  default value it is immediately replaced.
		/// </param>  NOT_FOUND_ERR: Raised if <code>oldAttr</code> is not an
		///  attribute of the element.
		///      </remarks>		<return> The <code>Attr</code> node that was removed.
		/// </return>
		/// 		<short>    Removes the specified attribute.</short>
		public DOM.Attr RemoveAttributeNode(DOM.Attr oldAttr) {
			return (DOM.Attr) interceptor.Invoke("removeAttributeNode#", "removeAttributeNode(const DOM::Attr&)", typeof(DOM.Attr), typeof(DOM.Attr), oldAttr);
		}
		/// <remarks>
		///  Returns a <code>ArrayList</code> of all descendant elements
		///  with a given tag name, in the order in which they would be
		///  encountered in a preorder traversal of the <code>Element</code>
		///  tree.
		/// <param> name="name" The name of the tag to match on. The special value
		///  "*" matches all tags.
		/// </param>     </remarks>		<return> A list of matching <code>Element</code> nodes.
		/// </return>
		/// 		<short>    Returns a <code>NodeList</code> of all descendant elements  with a given tag name, in the order in which they would be  encountered in a preorder traversal of the <code>Element</code>  tree.</short>
		public DOM.NodeList GetElementsByTagName(DOM.DOMString name) {
			return (DOM.NodeList) interceptor.Invoke("getElementsByTagName#", "getElementsByTagName(const DOM::DOMString&)", typeof(DOM.NodeList), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Returns an ArrayList of all the descendant Elements with a given local
		///  name and namespace URI in the order in which they are encountered in a
		///  preorder traversal of this Element tree.
		/// <param> name="namespaceURI" The namespace URI of the elements to match on. The
		///  special value "*" matches all namespaces.
		/// </param><param> name="localName" The local name of the elements to match on. The special
		///  value "*" matches all local names.
		/// </param></remarks>		<return> A new NodeList object containing all the matched Elements.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2  Returns a NodeList of all the descendant Elements with a given local  name and namespace URI in the order in which they are encountered in a  preorder traversal of this Element tree.</short>
		public DOM.NodeList GetElementsByTagNameNS(DOM.DOMString namespaceURI, DOM.DOMString localName) {
			return (DOM.NodeList) interceptor.Invoke("getElementsByTagNameNS##", "getElementsByTagNameNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.NodeList), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), localName);
		}
		/// <remarks>
		///  Introduced in HTML 5.
		///  No Exceptions.
		///  Returns a <code>ArrayList</code> of all the <code>Element</code> 's
		///  with a given class name in the order in which they
		///  would be encountered in a preorder traversal of the
		///  <code>Document</code> tree.
		/// <param> name="tagname" An unordered set of unique space-separated
		///  tokens representing classes.
		/// </param></remarks>		<return> A new <code>NodeList</code> object containing all the
		///  matched <code>Element</code> s.
		/// </return>
		/// 		<short>    Introduced in HTML 5.</short>
		public DOM.NodeList GetElementsByClassName(DOM.DOMString className) {
			return (DOM.NodeList) interceptor.Invoke("getElementsByClassName#", "getElementsByClassName(const DOM::DOMString&)", typeof(DOM.NodeList), typeof(DOM.DOMString), className);
		}
		/// <remarks>
		///  Introduced in DOM Level 2.
		///  No Exceptions.
		///  Retrieves an attribute value by local name and namespace URI. HTML-only
		///  DOM implementations do not need to implement this method.
		/// <param> name="namespaceURI" The namespace URI of the attribute to retrieve.
		/// </param><param> name="localName" The local name of the attribute to retrieve.
		/// </param></remarks>		<return> The Attr value as a string, or the empty string if that
		///  attribute does not have a specified or default value.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2.</short>
		public DOM.DOMString GetAttributeNS(DOM.DOMString namespaceURI, DOM.DOMString localName) {
			return (DOM.DOMString) interceptor.Invoke("getAttributeNS##", "getAttributeNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.DOMString), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), localName);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Adds a new attribute. If an attribute with the same local name and
		///  namespace URI is already present on the element, its prefix is changed
		///  to be the prefix part of the qualifiedName, and its value is changed to
		///  be the value parameter. This value is a simple string; it is not parsed
		///  as it is being set. So any markup (such as syntax to be recognized as an
		///  entity reference) is treated as literal text, and needs to be
		///  appropriately escaped by the implementation when it is written out. In
		///  order to assign an attribute value that contains entity references, the
		///  user must create an Attr node plus any Text and EntityReference nodes,
		///  build the appropriate subtree, and use setAttributeNodeNS or
		///  setAttributeNode to assign it as the value of an attribute.
		///  HTML-only DOM implementations do not need to implement this method.
		/// <param> name="namespaceURI" The namespace URI of the attribute to create or
		///  alter.
		/// </param><param> name="qualifiedName" The qualified name of the attribute to create or
		///  alter.
		/// </param><param> name="value" The value to set in string form.
		/// </param> NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
		///  NAMESPACE_ERR: Raised if the qualifiedName is malformed, if the
		///  qualifiedName has a prefix and the namespaceURI is null, if the
		///  qualifiedName has a prefix that is "xml" and the namespaceURI is
		///  different from "http://www.w3.org/XML/1998/namespace", or if the
		///  qualifiedName is "xmlns" and the namespaceURI is different from
		///  "http://www.w3.org/2000/xmlns/".
		///      </remarks>		<short>    Introduced in DOM Level 2 </short>
		public void SetAttributeNS(DOM.DOMString namespaceURI, DOM.DOMString qualifiedName, DOM.DOMString value) {
			interceptor.Invoke("setAttributeNS###", "setAttributeNS(const DOM::DOMString&, const DOM::DOMString&, const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), qualifiedName, typeof(DOM.DOMString), value);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Removes an attribute by local name and namespace URI. If the removed
		///  attribute has a default value it is immediately replaced. The replacing
		///  attribute has the same namespace URI and local name, as well as the
		///  original prefix.
		///  HTML-only DOM implementations do not need to implement this method.
		/// <param> name="namespaceURI" The namespace URI of the attribute to remove.
		/// </param><param> name="localName" The local name of the attribute to remove.
		/// </param></remarks>		<short>    Introduced in DOM Level 2 </short>
		public void RemoveAttributeNS(DOM.DOMString namespaceURI, DOM.DOMString localName) {
			interceptor.Invoke("removeAttributeNS##", "removeAttributeNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), localName);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Retrieves an Attr node by local name and namespace URI. HTML-only DOM
		///  implementations do not need to implement this method.
		/// <param> name="namespaceURI" The namespace URI of the attribute to retrieve.
		/// </param><param> name="localName" The local name of the attribute to retrieve.
		/// </param></remarks>		<return> The Attr node with the specified attribute local name and
		///  namespace URI or null if there is no such attribute.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2 </short>
		public DOM.Attr GetAttributeNodeNS(DOM.DOMString namespaceURI, DOM.DOMString localName) {
			return (DOM.Attr) interceptor.Invoke("getAttributeNodeNS##", "getAttributeNodeNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.Attr), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), localName);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Adds a new attribute. If an attribute with that local name and that
		///  namespace URI is already present in the element, it is replaced by the
		///  new one.
		///  HTML-only DOM implementations do not need to implement this method.
		/// <param> name="newAttr" The Attr node to add to the attribute list.
		/// </param> NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
		///  INUSE_ATTRIBUTE_ERR: Raised if newAttr is already an attribute of
		///  another Element object. The DOM user must explicitly clone Attr nodes to
		///  re-use them in other elements.
		///      </remarks>		<return> If the newAttr attribute replaces an existing attribute with the
		///  same local name and namespace URI, the replaced Attr node is returned,
		///  otherwise null is returned.
		/// </return>
		/// 		<short>    Introduced in DOM Level 2 </short>
		public DOM.Attr SetAttributeNodeNS(DOM.Attr newAttr) {
			return (DOM.Attr) interceptor.Invoke("setAttributeNodeNS#", "setAttributeNodeNS(const DOM::Attr&)", typeof(DOM.Attr), typeof(DOM.Attr), newAttr);
		}
		/// <remarks>
		///  Returns true when an attribute with a given name is specified on this
		///  element or has a default value, false otherwise.
		///  Introduced in DOM Level 2.
		/// <param> name="name" The name of the attribute to look for.
		/// </param></remarks>		<return> true if an attribute with the given name is specified on this
		///  element or has a default value, false otherwise.
		///      </return>
		/// 		<short>    Returns true when an attribute with a given name is specified on this  element or has a default value, false otherwise.</short>
		public bool HasAttribute(DOM.DOMString name) {
			return (bool) interceptor.Invoke("hasAttribute#", "hasAttribute(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Returns true when an attribute with a given local name and namespace URI
		///  is specified on this element or has a default value, false otherwise.
		///  HTML-only DOM implementations do not need to implement this method.
		/// <param> name="namespaceURI" The namespace URI of the attribute to look for.
		/// </param><param> name="localName" The local name of the attribute to look for.
		/// </param></remarks>		<return> true if an attribute with the given local name and namespace URI
		///  is specified or has a default value on this element, false otherwise.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2 </short>
		public bool HasAttributeNS(DOM.DOMString namespaceURI, DOM.DOMString localName) {
			return (bool) interceptor.Invoke("hasAttributeNS##", "hasAttributeNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), localName);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the CSSStyleDeclaration interface
		///  The style attribute
		///      </remarks>		<short>    Introduced in DOM Level 2  This method is from the CSSStyleDeclaration interface </short>
		public DOM.CSSStyleDeclaration Style() {
			return (DOM.CSSStyleDeclaration) interceptor.Invoke("style", "style()", typeof(DOM.CSSStyleDeclaration));
		}
		/// <remarks>
		///  not part of the official DOM
		///  This method will always reflect the editability setting of this
		///  element as specified by a direct or indirect (that means, inherited)
		///  assignment to contentEditable or the respective CSS rule, even if
		///  design mode is active.
		/// </remarks>		<return> whether this element is editable.
		/// </return>
		/// 		<short>    not part of the official DOM </short>
		/// 		<see> setContentEditable</see>
		public bool ContentEditable() {
			return (bool) interceptor.Invoke("contentEditable", "contentEditable() const", typeof(bool));
		}
		/// <remarks>
		///  not part of the official DOM
		///  This element can be made editable by setting its contentEditable
		///  property to <code>true.</code> The setting will be inherited to its children
		///  as well.
		///  Setting or clearing contentEditable when design mode is active will
		///  take no effect. However, its status will still be propagated to all
		///  child elements.
		/// <param> name="enabled" <code>true</code> to make this element editable, <code>false</code>
		///  otherwise.
		/// </param></remarks>		<short>    not part of the official DOM </short>
		/// 		<see> DOM.Document.DesignMode</see>
		public void SetContentEditable(bool enabled) {
			interceptor.Invoke("setContentEditable$", "setContentEditable(bool)", typeof(void), typeof(bool), enabled);
		}
		/// <remarks>
		///  not part of the DOM
		///      </remarks>		<short>   </short>
		public bool IsHTMLElement() {
			return (bool) interceptor.Invoke("isHTMLElement", "isHTMLElement() const", typeof(bool));
		}
		/// <remarks>
		///  KHTML extension to DOM
		///  This method returns the associated form element.
		///  returns null if this element is not a form-like element
		///  or if this elment is not in the scope of a form element.
		///      </remarks>		<short>    KHTML extension to DOM  This method returns the associated form element.</short>
		public DOM.Element Form() {
			return (DOM.Element) interceptor.Invoke("form", "form() const", typeof(DOM.Element));
		}
		~Element() {
			interceptor.Invoke("~Element", "~Element()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~Element", "~Element()", typeof(void));
		}
		public static bool KhtmlValidAttrName(DOM.DOMString name) {
			return (bool) staticInterceptor.Invoke("khtmlValidAttrName#", "khtmlValidAttrName(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), name);
		}
		public static bool KhtmlValidPrefix(DOM.DOMString name) {
			return (bool) staticInterceptor.Invoke("khtmlValidPrefix#", "khtmlValidPrefix(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), name);
		}
		public static bool KhtmlValidQualifiedName(DOM.DOMString name) {
			return (bool) staticInterceptor.Invoke("khtmlValidQualifiedName#", "khtmlValidQualifiedName(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), name);
		}
		public static bool KhtmlMalformedQualifiedName(DOM.DOMString name) {
			return (bool) staticInterceptor.Invoke("khtmlMalformedQualifiedName#", "khtmlMalformedQualifiedName(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), name);
		}
		public static bool KhtmlMalformedPrefix(DOM.DOMString name) {
			return (bool) staticInterceptor.Invoke("khtmlMalformedPrefix#", "khtmlMalformedPrefix(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), name);
		}
	}
}
