//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  This class is used to fetch items from the Akonadi storage.
    ///  Which parts of the items (e.g. headers only, attachments or all)
    ///  can be specified by the ItemFetchScope.
    ///  Example:
    ///  @code
    ///  // Fetch all items with full payload from the root collection
    ///  Akonadi.ItemFetchJob job = new Akonadi.ItemFetchJob( Akonadi.Collection.Root() );
    ///  job.FetchScope().fetchFullPayload();
    ///  if ( job.Exec() ) {
    ///    Akonadi.Item.List items = job.Items();
    ///    foreach( const Akonadi.Item &item, items ) {
    ///      qDebug() "Item ID:" << item.id();
    ///    }
    ///  } else {
    ///    qDebug() << "Error occurred";
    ///  }
    ///  @endcode
    ///  See <see cref="IItemFetchJobSignals"></see> for signals emitted by ItemFetchJob
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Job that fetches items from the Akonadi storage. </short>
    [SmokeClass("Akonadi::ItemFetchJob")]
    public class ItemFetchJob : Akonadi.Job, IDisposable {
        protected ItemFetchJob(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ItemFetchJob), this);
        }
        /// <remarks>
        ///  Creates a new item fetch job.
        /// <param> name="collection" The parent collection to fetch all items from.
        /// </param><param> name="parent" The parent object.
        ///      </param></remarks>        <short>    Creates a new item fetch job.</short>
        public ItemFetchJob(Akonadi.Collection collection, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemFetchJob##", "ItemFetchJob(const Akonadi::Collection&, QObject*)", typeof(void), typeof(Akonadi.Collection), collection, typeof(QObject), parent);
        }
        public ItemFetchJob(Akonadi.Collection collection) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemFetchJob#", "ItemFetchJob(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
        }
        /// <remarks>
        ///  Creates a new item fetch job.
        /// <param> name="item" The item to fetch.
        /// </param><param> name="parent" The parent object.
        ///      </param></remarks>        <short>    Creates a new item fetch job.</short>
        public ItemFetchJob(Akonadi.Item item, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemFetchJob##", "ItemFetchJob(const Akonadi::Item&, QObject*)", typeof(void), typeof(Akonadi.Item), item, typeof(QObject), parent);
        }
        public ItemFetchJob(Akonadi.Item item) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemFetchJob#", "ItemFetchJob(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  Returns the fetched item.
        ///  @note The items are invalid before the result( KJob )
        ///        signal has been emitted or if an error occurred.
        ///      </remarks>        <short>    Returns the fetched item.</short>
        public List<Akonadi.Item> Items() {
            return (List<Akonadi.Item>) interceptor.Invoke("items", "items() const", typeof(List<Akonadi.Item>));
        }
        /// <remarks>
        ///  Sets the item fetch scope.
        ///  The ItemFetchScope controls how much of an item's data is fetched
        ///  from the server, e.g. whether to fetch the full item payload or
        ///  only meta data.
        /// <param> name="fetchScope" The new scope for item fetch operations.
        /// </param></remarks>        <short>    Sets the item fetch scope.</short>
        ///         <see> fetchScope</see>
        public void SetFetchScope(Akonadi.ItemFetchScope fetchScope) {
            interceptor.Invoke("setFetchScope#", "setFetchScope(Akonadi::ItemFetchScope&)", typeof(void), typeof(Akonadi.ItemFetchScope), fetchScope);
        }
        /// <remarks>
        ///  Returns the item fetch scope.
        ///  Since this returns a reference it can be used to conveniently modify the
        ///  current scope in-place, i.e. by calling a method on the returned reference
        ///  without storing it in a local variable. See the ItemFetchScope documentation
        ///  for an example.
        /// </remarks>        <return> a reference to the current item fetch scope
        /// </return>
        ///         <short>    Returns the item fetch scope.</short>
        ///         <see> setFetchScope</see>
        ///         <see> for</see>
        ///         <see> replacing</see>
        ///         <see> the</see>
        ///         <see> current</see>
        ///         <see> item</see>
        ///         <see> fetch</see>
        ///         <see> scope</see>
        public Akonadi.ItemFetchScope FetchScope() {
            return (Akonadi.ItemFetchScope) interceptor.Invoke("fetchScope", "fetchScope()", typeof(Akonadi.ItemFetchScope));
        }
        [SmokeMethod("doStart()")]
        protected override void DoStart() {
            interceptor.Invoke("doStart", "doStart()", typeof(void));
        }
        [SmokeMethod("doHandleResponse(const QByteArray&, const QByteArray&)")]
        protected override void DoHandleResponse(QByteArray tag, QByteArray data) {
            interceptor.Invoke("doHandleResponse##", "doHandleResponse(const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), tag, typeof(QByteArray), data);
        }
        ~ItemFetchJob() {
            interceptor.Invoke("~ItemFetchJob", "~ItemFetchJob()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~ItemFetchJob", "~ItemFetchJob()", typeof(void));
        }
        protected new IItemFetchJobSignals Emit {
            get { return (IItemFetchJobSignals) Q_EMIT; }
        }
    }

    public interface IItemFetchJobSignals : Akonadi.IJobSignals {
        /// <remarks>
        ///  This signal is emitted when the items are fetched completely.
        /// <param> name="items" The fetched items.
        ///      </param></remarks>        <short>    This signal is emitted when the items are fetched completely.</short>
        [Q_SIGNAL("void itemsReceived(Akonadi::Item::List)")]
        void ItemsReceived(List<Akonadi.Item> items);
    }
}
