## API Report File for "kibana"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import { Action } from 'history';
import type { ApiResponse } from '@elastic/elasticsearch/lib/Transport';
import Boom from '@hapi/boom';
import { ByteSizeValue } from '@kbn/config-schema';
import { ConfigDeprecationProvider } from '@kbn/config';
import { ConfigPath } from '@kbn/config';
import { DetailedPeerCertificate } from 'tls';
import { EnvironmentMode } from '@kbn/config';
import type { estypes } from '@elastic/elasticsearch';
import { EuiBreadcrumb } from '@elastic/eui';
import { EuiButtonEmptyProps } from '@elastic/eui';
import { EuiConfirmModalProps } from '@elastic/eui';
import { EuiFlyoutSize } from '@elastic/eui';
import { EuiGlobalToastListToast } from '@elastic/eui';
import { History as History_2 } from 'history';
import { Href } from 'history';
import { IconType } from '@elastic/eui';
import { IncomingHttpHeaders } from 'http';
import type { KibanaClient } from '@elastic/elasticsearch/api/kibana';
import { Location as Location_2 } from 'history';
import { LocationDescriptorObject } from 'history';
import { Logger } from '@kbn/logging';
import { LogMeta } from '@kbn/logging';
import { MaybePromise } from '@kbn/utility-types';
import { ObjectType } from '@kbn/config-schema';
import { Observable } from 'rxjs';
import { PackageInfo } from '@kbn/config';
import { Path } from 'history';
import { PeerCertificate } from 'tls';
import type { PublicMethodsOf } from '@kbn/utility-types';
import { PublicUiSettingsParams as PublicUiSettingsParams_2 } from 'src/core/server/types';
import { default as React_2 } from 'react';
import { RecursiveReadonly } from '@kbn/utility-types';
import { Request as Request_2 } from '@hapi/hapi';
import * as Rx from 'rxjs';
import { SchemaTypeError } from '@kbn/config-schema';
import type { TransportRequestOptions } from '@elastic/elasticsearch/lib/Transport';
import type { TransportRequestParams } from '@elastic/elasticsearch/lib/Transport';
import type { TransportRequestPromise } from '@elastic/elasticsearch/lib/Transport';
import { Type } from '@kbn/config-schema';
import { TypeOf } from '@kbn/config-schema';
import { UiCounterMetricType } from '@kbn/analytics';
import { UnregisterCallback } from 'history';
import { URL as URL_2 } from 'url';
import { UserProvidedValues as UserProvidedValues_2 } from 'src/core/server/types';

// @internal (undocumented)
export function __kbnBootstrap__(): Promise<void>;

// @public (undocumented)
export interface App<HistoryLocationState = unknown> extends AppNavOptions {
    appRoute?: string;
    capabilities?: Partial<Capabilities>;
    category?: AppCategory;
    chromeless?: boolean;
    deepLinks?: AppDeepLink[];
    defaultPath?: string;
    exactRoute?: boolean;
    id: string;
    keywords?: string[];
    mount: AppMount<HistoryLocationState>;
    navLinkStatus?: AppNavLinkStatus;
    searchable?: boolean;
    status?: AppStatus;
    title: string;
    updater$?: Observable<AppUpdater>;
}

// @public
export const APP_WRAPPER_CLASS = "kbnAppWrapper";

// @public
export interface AppCategory {
    ariaLabel?: string;
    euiIconType?: string;
    id: string;
    label: string;
    order?: number;
}

// @public
export type AppDeepLink = {
    id: string;
    title: string;
    keywords?: string[];
    navLinkStatus?: AppNavLinkStatus;
    searchable?: boolean;
} & AppNavOptions & ({
    path: string;
    deepLinks?: AppDeepLink[];
} | {
    path?: string;
    deepLinks: AppDeepLink[];
});

// @public
export type AppLeaveAction = AppLeaveDefaultAction | AppLeaveConfirmAction;

// @public
export enum AppLeaveActionType {
    // (undocumented)
    confirm = "confirm",
    // (undocumented)
    default = "default"
}

// Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "AppLeaveActionFactory"
//
// @public
export interface AppLeaveConfirmAction {
    // (undocumented)
    callback?: () => void;
    // (undocumented)
    text: string;
    // (undocumented)
    title?: string;
    // (undocumented)
    type: AppLeaveActionType.confirm;
}

// Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "AppLeaveActionFactory"
//
// @public
export interface AppLeaveDefaultAction {
    // (undocumented)
    type: AppLeaveActionType.default;
}

// Warning: (ae-forgotten-export) The symbol "AppLeaveActionFactory" needs to be exported by the entry point index.d.ts
//
// @public @deprecated
export type AppLeaveHandler = (factory: AppLeaveActionFactory, nextAppId?: string) => AppLeaveAction;

// @public (undocumented)
export interface ApplicationSetup {
    register<HistoryLocationState = unknown>(app: App<HistoryLocationState>): void;
    registerAppUpdater(appUpdater$: Observable<AppUpdater>): void;
}

// @public (undocumented)
export interface ApplicationStart {
    applications$: Observable<ReadonlyMap<string, PublicAppInfo>>;
    capabilities: RecursiveReadonly<Capabilities>;
    currentAppId$: Observable<string | undefined>;
    getUrlForApp(appId: string, options?: {
        path?: string;
        absolute?: boolean;
        deepLinkId?: string;
    }): string;
    navigateToApp(appId: string, options?: NavigateToAppOptions): Promise<void>;
    navigateToUrl(url: string): Promise<void>;
}

// @public
export type AppMount<HistoryLocationState = unknown> = (params: AppMountParameters<HistoryLocationState>) => AppUnmount | Promise<AppUnmount>;

// @public (undocumented)
export interface AppMountParameters<HistoryLocationState = unknown> {
    // @deprecated
    appBasePath: string;
    element: HTMLElement;
    history: ScopedHistory<HistoryLocationState>;
    // @deprecated
    onAppLeave: (handler: AppLeaveHandler) => void;
    setHeaderActionMenu: (menuMount: MountPoint | undefined) => void;
}

// @public
export enum AppNavLinkStatus {
    default = 0,
    disabled = 2,
    hidden = 3,
    visible = 1
}

// @public
export interface AppNavOptions {
    euiIconType?: string;
    icon?: string;
    order?: number;
    tooltip?: string;
}

// @public
export enum AppStatus {
    accessible = 0,
    inaccessible = 1
}

// @public
export type AppUnmount = () => void;

// @public
export type AppUpdatableFields = Pick<App, 'status' | 'navLinkStatus' | 'searchable' | 'tooltip' | 'defaultPath' | 'deepLinks'>;

// @public
export type AppUpdater = (app: App) => Partial<AppUpdatableFields> | undefined;

// @public @deprecated
export interface AsyncPlugin<TSetup = void, TStart = void, TPluginsSetup extends object = object, TPluginsStart extends object = object> {
    // (undocumented)
    setup(core: CoreSetup<TPluginsStart, TStart>, plugins: TPluginsSetup): TSetup | Promise<TSetup>;
    // (undocumented)
    start(core: CoreStart, plugins: TPluginsStart): TStart | Promise<TStart>;
    // (undocumented)
    stop?(): void;
}

// @public
export interface Capabilities {
    [key: string]: Record<string, boolean | Record<string, boolean>>;
    catalogue: Record<string, boolean>;
    management: {
        [sectionId: string]: Record<string, boolean>;
    };
    navLinks: Record<string, boolean>;
}

// @public (undocumented)
export interface ChromeBadge {
    // (undocumented)
    iconType?: IconType;
    // (undocumented)
    text: string;
    // (undocumented)
    tooltip: string;
}

// @public (undocumented)
export type ChromeBreadcrumb = EuiBreadcrumb;

// @public
export interface ChromeDocTitle {
    change(newTitle: string | string[]): void;
    reset(): void;
}

// @public (undocumented)
export interface ChromeHelpExtension {
    appName: string;
    content?: (element: HTMLDivElement) => () => void;
    links?: ChromeHelpExtensionMenuLink[];
}

// @public (undocumented)
export type ChromeHelpExtensionLinkBase = Pick<EuiButtonEmptyProps, 'iconType' | 'target' | 'rel' | 'data-test-subj'>;

// @public (undocumented)
export interface ChromeHelpExtensionMenuCustomLink extends ChromeHelpExtensionLinkBase {
    content: React_2.ReactNode;
    href: string;
    linkType: 'custom';
}

// @public (undocumented)
export interface ChromeHelpExtensionMenuDiscussLink extends ChromeHelpExtensionLinkBase {
    href: string;
    linkType: 'discuss';
}

// @public (undocumented)
export interface ChromeHelpExtensionMenuDocumentationLink extends ChromeHelpExtensionLinkBase {
    href: string;
    linkType: 'documentation';
}

// @public (undocumented)
export interface ChromeHelpExtensionMenuGitHubLink extends ChromeHelpExtensionLinkBase {
    labels: string[];
    linkType: 'github';
    title?: string;
}

// @public (undocumented)
export type ChromeHelpExtensionMenuLink = ChromeHelpExtensionMenuGitHubLink | ChromeHelpExtensionMenuDiscussLink | ChromeHelpExtensionMenuDocumentationLink | ChromeHelpExtensionMenuCustomLink;

// @public (undocumented)
export interface ChromeNavControl {
    // (undocumented)
    mount: MountPoint;
    // (undocumented)
    order?: number;
}

// @public
export interface ChromeNavControls {
    // @internal (undocumented)
    getCenter$(): Observable<ChromeNavControl[]>;
    // @internal (undocumented)
    getLeft$(): Observable<ChromeNavControl[]>;
    // @internal (undocumented)
    getRight$(): Observable<ChromeNavControl[]>;
    registerCenter(navControl: ChromeNavControl): void;
    registerLeft(navControl: ChromeNavControl): void;
    registerRight(navControl: ChromeNavControl): void;
}

// @public (undocumented)
export interface ChromeNavLink {
    readonly baseUrl: string;
    readonly category?: AppCategory;
    readonly disabled?: boolean;
    readonly euiIconType?: string;
    readonly hidden?: boolean;
    readonly href: string;
    readonly icon?: string;
    readonly id: string;
    readonly order?: number;
    readonly title: string;
    readonly tooltip?: string;
    readonly url: string;
}

// @public
export interface ChromeNavLinks {
    enableForcedAppSwitcherNavigation(): void;
    get(id: string): ChromeNavLink | undefined;
    getAll(): Array<Readonly<ChromeNavLink>>;
    getForceAppSwitcherNavigation$(): Observable<boolean>;
    getNavLinks$(): Observable<Array<Readonly<ChromeNavLink>>>;
    has(id: string): boolean;
    showOnly(id: string): void;
}

// @public
export interface ChromeRecentlyAccessed {
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: No member was found with name "basePath"
    add(link: string, label: string, id: string): void;
    get$(): Observable<ChromeRecentlyAccessedHistoryItem[]>;
    get(): ChromeRecentlyAccessedHistoryItem[];
}

// @public (undocumented)
export interface ChromeRecentlyAccessedHistoryItem {
    // (undocumented)
    id: string;
    // (undocumented)
    label: string;
    // (undocumented)
    link: string;
}

// @public
export interface ChromeStart {
    docTitle: ChromeDocTitle;
    getBadge$(): Observable<ChromeBadge | undefined>;
    getBreadcrumbs$(): Observable<ChromeBreadcrumb[]>;
    // Warning: (ae-forgotten-export) The symbol "ChromeBreadcrumbsAppendExtension" needs to be exported by the entry point index.d.ts
    getBreadcrumbsAppendExtension$(): Observable<ChromeBreadcrumbsAppendExtension | undefined>;
    getCustomNavLink$(): Observable<Partial<ChromeNavLink> | undefined>;
    getHelpExtension$(): Observable<ChromeHelpExtension | undefined>;
    getIsNavDrawerLocked$(): Observable<boolean>;
    getIsVisible$(): Observable<boolean>;
    hasHeaderBanner$(): Observable<boolean>;
    navControls: ChromeNavControls;
    navLinks: ChromeNavLinks;
    recentlyAccessed: ChromeRecentlyAccessed;
    setBadge(badge?: ChromeBadge): void;
    setBreadcrumbs(newBreadcrumbs: ChromeBreadcrumb[]): void;
    setBreadcrumbsAppendExtension(breadcrumbsAppendExtension?: ChromeBreadcrumbsAppendExtension): void;
    setCustomNavLink(newCustomNavLink?: Partial<ChromeNavLink>): void;
    setHeaderBanner(headerBanner?: ChromeUserBanner): void;
    setHelpExtension(helpExtension?: ChromeHelpExtension): void;
    setHelpSupportUrl(url: string): void;
    setIsVisible(isVisible: boolean): void;
}

// @public (undocumented)
export interface ChromeUserBanner {
    // (undocumented)
    content: MountPoint<HTMLDivElement>;
}

// @internal (undocumented)
export interface CoreContext {
    // Warning: (ae-forgotten-export) The symbol "CoreId" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    coreId: CoreId;
    // (undocumented)
    env: {
        mode: Readonly<EnvironmentMode>;
        packageInfo: Readonly<PackageInfo>;
    };
}

// @public
export interface CoreSetup<TPluginsStart extends object = object, TStart = unknown> {
    // (undocumented)
    application: ApplicationSetup;
    // (undocumented)
    fatalErrors: FatalErrorsSetup;
    // (undocumented)
    getStartServices: StartServicesAccessor<TPluginsStart, TStart>;
    // (undocumented)
    http: HttpSetup;
    // @deprecated
    injectedMetadata: {
        getInjectedVar: (name: string, defaultValue?: any) => unknown;
    };
    // (undocumented)
    notifications: NotificationsSetup;
    // (undocumented)
    uiSettings: IUiSettingsClient;
}

// @public
export interface CoreStart {
    // (undocumented)
    application: ApplicationStart;
    // (undocumented)
    chrome: ChromeStart;
    // (undocumented)
    deprecations: DeprecationsServiceStart;
    // (undocumented)
    docLinks: DocLinksStart;
    // (undocumented)
    fatalErrors: FatalErrorsStart;
    // (undocumented)
    http: HttpStart;
    // (undocumented)
    i18n: I18nStart;
    // @deprecated
    injectedMetadata: {
        getInjectedVar: (name: string, defaultValue?: any) => unknown;
    };
    // (undocumented)
    notifications: NotificationsStart;
    // (undocumented)
    overlays: OverlayStart;
    // (undocumented)
    savedObjects: SavedObjectsStart;
    // (undocumented)
    uiSettings: IUiSettingsClient;
}

// @internal
export class CoreSystem {
    // Warning: (ae-forgotten-export) The symbol "Params" needs to be exported by the entry point index.d.ts
    constructor(params: Params);
    // (undocumented)
    setup(): Promise<{
        fatalErrors: FatalErrorsSetup;
    } | undefined>;
    // (undocumented)
    start(): Promise<{
        application: InternalApplicationStart;
    } | undefined>;
    // (undocumented)
    stop(): void;
}

// @internal (undocumented)
export const DEFAULT_APP_CATEGORIES: Record<string, AppCategory>;

// @public
export interface DeprecationsServiceStart {
    // Warning: (ae-incompatible-release-tags) The symbol "getAllDeprecations" is marked as @public, but its signature references "DomainDeprecationDetails" which is marked as @internal
    getAllDeprecations: () => Promise<DomainDeprecationDetails[]>;
    // Warning: (ae-incompatible-release-tags) The symbol "getDeprecations" is marked as @public, but its signature references "DomainDeprecationDetails" which is marked as @internal
    getDeprecations: (domainId: string) => Promise<DomainDeprecationDetails[]>;
    // Warning: (ae-incompatible-release-tags) The symbol "isDeprecationResolvable" is marked as @public, but its signature references "DomainDeprecationDetails" which is marked as @internal
    isDeprecationResolvable: (details: DomainDeprecationDetails) => boolean;
    // Warning: (ae-incompatible-release-tags) The symbol "resolveDeprecation" is marked as @public, but its signature references "DomainDeprecationDetails" which is marked as @internal
    resolveDeprecation: (details: DomainDeprecationDetails) => Promise<ResolveDeprecationResponse>;
}

// @public (undocumented)
export interface DocLinksStart {
    // (undocumented)
    readonly DOC_LINK_VERSION: string;
    // (undocumented)
    readonly ELASTIC_WEBSITE_URL: string;
    // (undocumented)
    readonly links: {
        readonly settings: string;
        readonly elasticStackGetStarted: string;
        readonly upgrade: {
            readonly upgradingElasticStack: string;
        };
        readonly apm: {
            readonly kibanaSettings: string;
            readonly supportedServiceMaps: string;
            readonly customLinks: string;
            readonly droppedTransactionSpans: string;
            readonly upgrading: string;
            readonly metaData: string;
        };
        readonly canvas: {
            readonly guide: string;
        };
        readonly dashboard: {
            readonly guide: string;
            readonly drilldowns: string;
            readonly drilldownsTriggerPicker: string;
            readonly urlDrilldownTemplateSyntax: string;
            readonly urlDrilldownVariables: string;
        };
        readonly discover: Record<string, string>;
        readonly filebeat: {
            readonly base: string;
            readonly installation: string;
            readonly configuration: string;
            readonly elasticsearchOutput: string;
            readonly elasticsearchModule: string;
            readonly startup: string;
            readonly exportedFields: string;
            readonly suricataModule: string;
            readonly zeekModule: string;
        };
        readonly auditbeat: {
            readonly base: string;
            readonly auditdModule: string;
            readonly systemModule: string;
        };
        readonly metricbeat: {
            readonly base: string;
            readonly configure: string;
            readonly httpEndpoint: string;
            readonly install: string;
            readonly start: string;
        };
        readonly enterpriseSearch: {
            readonly base: string;
            readonly appSearchBase: string;
            readonly workplaceSearchBase: string;
        };
        readonly heartbeat: {
            readonly base: string;
        };
        readonly libbeat: {
            readonly getStarted: string;
        };
        readonly logstash: {
            readonly base: string;
        };
        readonly functionbeat: {
            readonly base: string;
        };
        readonly winlogbeat: {
            readonly base: string;
        };
        readonly aggs: {
            readonly composite: string;
            readonly composite_missing_bucket: string;
            readonly date_histogram: string;
            readonly date_range: string;
            readonly date_format_pattern: string;
            readonly filter: string;
            readonly filters: string;
            readonly geohash_grid: string;
            readonly histogram: string;
            readonly ip_range: string;
            readonly range: string;
            readonly significant_terms: string;
            readonly terms: string;
            readonly avg: string;
            readonly avg_bucket: string;
            readonly max_bucket: string;
            readonly min_bucket: string;
            readonly sum_bucket: string;
            readonly cardinality: string;
            readonly count: string;
            readonly cumulative_sum: string;
            readonly derivative: string;
            readonly geo_bounds: string;
            readonly geo_centroid: string;
            readonly max: string;
            readonly median: string;
            readonly min: string;
            readonly moving_avg: string;
            readonly percentile_ranks: string;
            readonly serial_diff: string;
            readonly std_dev: string;
            readonly sum: string;
            readonly top_hits: string;
        };
        readonly runtimeFields: {
            readonly overview: string;
            readonly mapping: string;
        };
        readonly scriptedFields: {
            readonly scriptFields: string;
            readonly scriptAggs: string;
            readonly painless: string;
            readonly painlessApi: string;
            readonly painlessLangSpec: string;
            readonly painlessSyntax: string;
            readonly painlessWalkthrough: string;
            readonly luceneExpressions: string;
        };
        readonly search: {
            readonly sessions: string;
            readonly sessionLimits: string;
        };
        readonly indexPatterns: {
            readonly introduction: string;
            readonly fieldFormattersNumber: string;
            readonly fieldFormattersString: string;
            readonly runtimeFields: string;
        };
        readonly addData: string;
        readonly kibana: string;
        readonly upgradeAssistant: {
            readonly overview: string;
            readonly batchReindex: string;
            readonly remoteReindex: string;
        };
        readonly rollupJobs: string;
        readonly elasticsearch: Record<string, string>;
        readonly siem: {
            readonly privileges: string;
            readonly guide: string;
            readonly gettingStarted: string;
            readonly ml: string;
            readonly ruleChangeLog: string;
            readonly detectionsReq: string;
            readonly networkMap: string;
            readonly troubleshootGaps: string;
        };
        readonly securitySolution: {
            readonly trustedApps: string;
        };
        readonly query: {
            readonly eql: string;
            readonly kueryQuerySyntax: string;
            readonly luceneQuerySyntax: string;
            readonly percolate: string;
            readonly queryDsl: string;
            readonly autocompleteChanges: string;
        };
        readonly date: {
            readonly dateMath: string;
            readonly dateMathIndexNames: string;
        };
        readonly management: Record<string, string>;
        readonly ml: Record<string, string>;
        readonly transforms: Record<string, string>;
        readonly visualize: Record<string, string>;
        readonly apis: Readonly<{
            bulkIndexAlias: string;
            byteSizeUnits: string;
            createAutoFollowPattern: string;
            createFollower: string;
            createIndex: string;
            createSnapshotLifecyclePolicy: string;
            createRoleMapping: string;
            createRoleMappingTemplates: string;
            createRollupJobsRequest: string;
            createApiKey: string;
            createPipeline: string;
            createTransformRequest: string;
            cronExpressions: string;
            executeWatchActionModes: string;
            indexExists: string;
            openIndex: string;
            putComponentTemplate: string;
            painlessExecute: string;
            painlessExecuteAPIContexts: string;
            putComponentTemplateMetadata: string;
            putSnapshotLifecyclePolicy: string;
            putIndexTemplateV1: string;
            putWatch: string;
            simulatePipeline: string;
            timeUnits: string;
            updateTransform: string;
        }>;
        readonly observability: Readonly<{
            guide: string;
            infrastructureThreshold: string;
            logsThreshold: string;
            metricsThreshold: string;
            monitorStatus: string;
            monitorUptime: string;
            tlsCertificate: string;
            uptimeDurationAnomaly: string;
        }>;
        readonly alerting: Record<string, string>;
        readonly maps: Record<string, string>;
        readonly monitoring: Record<string, string>;
        readonly security: Readonly<{
            apiKeyServiceSettings: string;
            clusterPrivileges: string;
            elasticsearchSettings: string;
            elasticsearchEnableSecurity: string;
            elasticsearchEnableApiKeys: string;
            indicesPrivileges: string;
            kibanaTLS: string;
            kibanaPrivileges: string;
            mappingRoles: string;
            mappingRolesFieldRules: string;
            runAsPrivilege: string;
        }>;
        readonly spaces: Readonly<{
            kibanaLegacyUrlAliases: string;
            kibanaDisableLegacyUrlAliasesApi: string;
        }>;
        readonly watcher: Record<string, string>;
        readonly ccs: Record<string, string>;
        readonly plugins: Record<string, string>;
        readonly snapshotRestore: Record<string, string>;
        readonly ingest: Record<string, string>;
        readonly fleet: Readonly<{
            beatsAgentComparison: string;
            guide: string;
            fleetServer: string;
            fleetServerAddFleetServer: string;
            settings: string;
            settingsFleetServerHostSettings: string;
            settingsFleetServerProxySettings: string;
            troubleshooting: string;
            elasticAgent: string;
            datastreams: string;
            datastreamsNamingScheme: string;
            installElasticAgent: string;
            upgradeElasticAgent: string;
            upgradeElasticAgent712lower: string;
            learnMoreBlog: string;
            apiKeysLearnMore: string;
            onPremRegistry: string;
        }>;
        readonly ecs: {
            readonly guide: string;
        };
        readonly clients: {
            readonly guide: string;
            readonly goOverview: string;
            readonly javaIndex: string;
            readonly jsIntro: string;
            readonly netGuide: string;
            readonly perlGuide: string;
            readonly phpGuide: string;
            readonly pythonGuide: string;
            readonly rubyOverview: string;
            readonly rustGuide: string;
        };
        readonly endpoints: {
            readonly troubleshooting: string;
        };
    };
}

// Warning: (ae-forgotten-export) The symbol "DeprecationsDetails" needs to be exported by the entry point index.d.ts
//
// @internal (undocumented)
export type DomainDeprecationDetails = DeprecationsDetails & {
    domainId: string;
};

export { EnvironmentMode }

// @public
export interface ErrorToastOptions extends ToastOptions {
    title: string;
    toastMessage?: string;
}

// @public
export interface FatalErrorInfo {
    // (undocumented)
    message: string;
    // (undocumented)
    stack: string | undefined;
}

// @public
export interface FatalErrorsSetup {
    add: (error: string | Error, source?: string) => never;
    get$: () => Rx.Observable<FatalErrorInfo>;
}

// @public
export type FatalErrorsStart = FatalErrorsSetup;

// @internal (undocumented)
export class HttpFetchError extends Error implements IHttpFetchError {
    constructor(message: string, name: string, request: Request, response?: Response | undefined, body?: any);
    // (undocumented)
    readonly body?: any;
    // (undocumented)
    readonly name: string;
    // (undocumented)
    readonly req: Request;
    // (undocumented)
    readonly request: Request;
    // (undocumented)
    readonly res?: Response;
    // (undocumented)
    readonly response?: Response | undefined;
}

// @public
export interface HttpFetchOptions extends HttpRequestInit {
    asResponse?: boolean;
    asSystemRequest?: boolean;
    // (undocumented)
    context?: KibanaExecutionContext;
    headers?: HttpHeadersInit;
    prependBasePath?: boolean;
    query?: HttpFetchQuery;
}

// @public
export interface HttpFetchOptionsWithPath extends HttpFetchOptions {
    // (undocumented)
    path: string;
}

// @public (undocumented)
export interface HttpFetchQuery {
    [key: string]: string | number | boolean | string[] | number[] | boolean[] | undefined | null;
}

// @public
export interface HttpHandler {
    // (undocumented)
    <TResponseBody = any>(path: string, options: HttpFetchOptions & {
        asResponse: true;
    }): Promise<HttpResponse<TResponseBody>>;
    // (undocumented)
    <TResponseBody = any>(options: HttpFetchOptionsWithPath & {
        asResponse: true;
    }): Promise<HttpResponse<TResponseBody>>;
    // (undocumented)
    <TResponseBody = any>(path: string, options?: HttpFetchOptions): Promise<TResponseBody>;
    // (undocumented)
    <TResponseBody = any>(options: HttpFetchOptionsWithPath): Promise<TResponseBody>;
}

// @public
export interface HttpHeadersInit {
    // (undocumented)
    [name: string]: any;
}

// @public
export interface HttpInterceptor {
    request?(fetchOptions: Readonly<HttpFetchOptionsWithPath>, controller: IHttpInterceptController): MaybePromise<Partial<HttpFetchOptionsWithPath>> | void;
    requestError?(httpErrorRequest: HttpInterceptorRequestError, controller: IHttpInterceptController): MaybePromise<Partial<HttpFetchOptionsWithPath>> | void;
    response?(httpResponse: HttpResponse, controller: IHttpInterceptController): MaybePromise<IHttpResponseInterceptorOverrides> | void;
    responseError?(httpErrorResponse: HttpInterceptorResponseError, controller: IHttpInterceptController): MaybePromise<IHttpResponseInterceptorOverrides> | void;
}

// @public (undocumented)
export interface HttpInterceptorRequestError {
    // (undocumented)
    error: Error;
    // (undocumented)
    fetchOptions: Readonly<HttpFetchOptionsWithPath>;
}

// @public (undocumented)
export interface HttpInterceptorResponseError extends HttpResponse {
    // (undocumented)
    error: Error | IHttpFetchError;
    // (undocumented)
    request: Readonly<Request>;
}

// @public
export interface HttpRequestInit {
    body?: BodyInit | null;
    cache?: RequestCache;
    credentials?: RequestCredentials;
    // (undocumented)
    headers?: HttpHeadersInit;
    integrity?: string;
    keepalive?: boolean;
    method?: string;
    mode?: RequestMode;
    redirect?: RequestRedirect;
    referrer?: string;
    referrerPolicy?: ReferrerPolicy;
    signal?: AbortSignal | null;
    window?: null;
}

// @public (undocumented)
export interface HttpResponse<TResponseBody = any> {
    readonly body?: TResponseBody;
    readonly fetchOptions: Readonly<HttpFetchOptionsWithPath>;
    readonly request: Readonly<Request>;
    readonly response?: Readonly<Response>;
}

// @public (undocumented)
export interface HttpSetup {
    addLoadingCountSource(countSource$: Observable<number>): void;
    anonymousPaths: IAnonymousPaths;
    basePath: IBasePath;
    delete: HttpHandler;
    // (undocumented)
    externalUrl: IExternalUrl;
    fetch: HttpHandler;
    get: HttpHandler;
    getLoadingCount$(): Observable<number>;
    head: HttpHandler;
    intercept(interceptor: HttpInterceptor): () => void;
    options: HttpHandler;
    patch: HttpHandler;
    post: HttpHandler;
    put: HttpHandler;
}

// @public
export type HttpStart = HttpSetup;

// @public
export interface I18nStart {
    Context: ({ children }: {
        children: React_2.ReactNode;
    }) => JSX.Element;
}

// Warning: (ae-missing-release-tag) "IAnonymousPaths" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public
export interface IAnonymousPaths {
    isAnonymous(path: string): boolean;
    register(path: string): void;
}

// @public
export interface IBasePath {
    get: () => string;
    prepend: (url: string) => string;
    readonly publicBaseUrl?: string;
    remove: (url: string) => string;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "BasePath"
    readonly serverBasePath: string;
}

// @public
export interface IExternalUrl {
    validateUrl(relativeOrAbsoluteUrl: string): URL | null;
}

// @public
export interface IExternalUrlPolicy {
    allow: boolean;
    host?: string;
    protocol?: string;
}

// @public (undocumented)
export interface IHttpFetchError extends Error {
    // (undocumented)
    readonly body?: any;
    // (undocumented)
    readonly name: string;
    // @deprecated (undocumented)
    readonly req: Request;
    // (undocumented)
    readonly request: Request;
    // @deprecated (undocumented)
    readonly res?: Response;
    // (undocumented)
    readonly response?: Response;
}

// @public
export interface IHttpInterceptController {
    halt(): void;
    halted: boolean;
}

// @public
export interface IHttpResponseInterceptorOverrides<TResponseBody = any> {
    readonly body?: TResponseBody;
    readonly response?: Readonly<Response>;
}

// @public
export type IToasts = Pick<ToastsApi, 'get$' | 'add' | 'remove' | 'addSuccess' | 'addWarning' | 'addDanger' | 'addError' | 'addInfo'>;

// @public
export interface IUiSettingsClient {
    get$: <T = any>(key: string, defaultOverride?: T) => Observable<T>;
    get: <T = any>(key: string, defaultOverride?: T) => T;
    getAll: () => Readonly<Record<string, PublicUiSettingsParams_2 & UserProvidedValues_2>>;
    getUpdate$: <T = any>() => Observable<{
        key: string;
        newValue: T;
        oldValue: T;
    }>;
    getUpdateErrors$: () => Observable<Error>;
    isCustom: (key: string) => boolean;
    isDeclared: (key: string) => boolean;
    isDefault: (key: string) => boolean;
    isOverridden: (key: string) => boolean;
    remove: (key: string) => Promise<boolean>;
    set: (key: string, value: any) => Promise<boolean>;
}

// @public
export type KibanaExecutionContext = {
    readonly type: string;
    readonly name: string;
    readonly id: string;
    readonly description: string;
    readonly url?: string;
    parent?: KibanaExecutionContext;
};

// @public
export type MountPoint<T extends HTMLElement = HTMLElement> = (element: T) => UnmountCallback;

// @public
export interface NavigateToAppOptions {
    deepLinkId?: string;
    openInNewTab?: boolean;
    path?: string;
    replace?: boolean;
    state?: unknown;
}

// Warning: (ae-missing-release-tag) "NavType" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export type NavType = 'modern' | 'legacy';

// @public (undocumented)
export interface NotificationsSetup {
    // (undocumented)
    toasts: ToastsSetup;
}

// @public (undocumented)
export interface NotificationsStart {
    // (undocumented)
    toasts: ToastsStart;
}

// @public (undocumented)
export interface OverlayBannersStart {
    add(mount: MountPoint, priority?: number): string;
    // Warning: (ae-forgotten-export) The symbol "OverlayBanner" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    get$(): Observable<OverlayBanner[]>;
    // (undocumented)
    getComponent(): JSX.Element;
    remove(id: string): boolean;
    replace(id: string | undefined, mount: MountPoint, priority?: number): string;
}

// @public (undocumented)
export interface OverlayFlyoutOpenOptions {
    // (undocumented)
    'aria-label'?: string;
    // (undocumented)
    'data-test-subj'?: string;
    // (undocumented)
    className?: string;
    // (undocumented)
    closeButtonAriaLabel?: string;
    // (undocumented)
    hideCloseButton?: boolean;
    // (undocumented)
    maxWidth?: boolean | number | string;
    onClose?: (flyout: OverlayRef) => void;
    // (undocumented)
    ownFocus?: boolean;
    // (undocumented)
    size?: EuiFlyoutSize;
}

// @public
export interface OverlayFlyoutStart {
    open(mount: MountPoint, options?: OverlayFlyoutOpenOptions): OverlayRef;
}

// @public (undocumented)
export interface OverlayModalConfirmOptions {
    // (undocumented)
    'data-test-subj'?: string;
    // (undocumented)
    buttonColor?: EuiConfirmModalProps['buttonColor'];
    // (undocumented)
    cancelButtonText?: string;
    // (undocumented)
    className?: string;
    // (undocumented)
    closeButtonAriaLabel?: string;
    // (undocumented)
    confirmButtonText?: string;
    // (undocumented)
    defaultFocusedButton?: EuiConfirmModalProps['defaultFocusedButton'];
    maxWidth?: boolean | number | string;
    // (undocumented)
    title?: string;
}

// @public (undocumented)
export interface OverlayModalOpenOptions {
    // (undocumented)
    'data-test-subj'?: string;
    // (undocumented)
    className?: string;
    // (undocumented)
    closeButtonAriaLabel?: string;
    // (undocumented)
    maxWidth?: boolean | number | string;
}

// @public
export interface OverlayModalStart {
    open(mount: MountPoint, options?: OverlayModalOpenOptions): OverlayRef;
    openConfirm(message: MountPoint | string, options?: OverlayModalConfirmOptions): Promise<boolean>;
}

// @public
export interface OverlayRef {
    close(): Promise<void>;
    onClose: Promise<void>;
}

// @public (undocumented)
export interface OverlayStart {
    // (undocumented)
    banners: OverlayBannersStart;
    // (undocumented)
    openConfirm: OverlayModalStart['openConfirm'];
    // (undocumented)
    openFlyout: OverlayFlyoutStart['open'];
    // (undocumented)
    openModal: OverlayModalStart['open'];
}

export { PackageInfo }

// @public
interface Plugin_2<TSetup = void, TStart = void, TPluginsSetup extends object = object, TPluginsStart extends object = object> {
    // (undocumented)
    setup(core: CoreSetup<TPluginsStart, TStart>, plugins: TPluginsSetup): TSetup;
    // (undocumented)
    start(core: CoreStart, plugins: TPluginsStart): TStart;
    // (undocumented)
    stop?(): void;
}
export { Plugin_2 as Plugin }

// @public
export type PluginInitializer<TSetup, TStart, TPluginsSetup extends object = object, TPluginsStart extends object = object> = (core: PluginInitializerContext) => Plugin_2<TSetup, TStart, TPluginsSetup, TPluginsStart> | AsyncPlugin<TSetup, TStart, TPluginsSetup, TPluginsStart>;

// @public
export interface PluginInitializerContext<ConfigSchema extends object = object> {
    // (undocumented)
    readonly config: {
        get: <T extends object = ConfigSchema>() => T;
    };
    // (undocumented)
    readonly env: {
        mode: Readonly<EnvironmentMode>;
        packageInfo: Readonly<PackageInfo>;
    };
    readonly opaqueId: PluginOpaqueId;
}

// @public (undocumented)
export type PluginOpaqueId = symbol;

// @public
export type PublicAppDeepLinkInfo = Omit<AppDeepLink, 'deepLinks' | 'keywords' | 'navLinkStatus' | 'searchable'> & {
    deepLinks: PublicAppDeepLinkInfo[];
    keywords: string[];
    navLinkStatus: AppNavLinkStatus;
    searchable: boolean;
};

// @public
export type PublicAppInfo = Omit<App, 'mount' | 'updater$' | 'keywords' | 'deepLinks' | 'searchable'> & {
    status: AppStatus;
    navLinkStatus: AppNavLinkStatus;
    appRoute: string;
    keywords: string[];
    deepLinks: PublicAppDeepLinkInfo[];
    searchable: boolean;
};

// @public
export type PublicUiSettingsParams = Omit<UiSettingsParams, 'schema'>;

// Warning: (ae-missing-release-tag) "ResolveDeprecationResponse" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export type ResolveDeprecationResponse = {
    status: 'ok';
} | {
    status: 'fail';
    reason: string;
};

// @public
export interface ResolvedSimpleSavedObject<T = unknown> {
    alias_target_id?: SavedObjectsResolveResponse['alias_target_id'];
    outcome: SavedObjectsResolveResponse['outcome'];
    saved_object: SimpleSavedObject<T>;
}

// Warning: (ae-missing-release-tag) "SavedObject" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export interface SavedObject<T = unknown> {
    attributes: T;
    coreMigrationVersion?: string;
    // (undocumented)
    error?: SavedObjectError;
    id: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    namespaces?: string[];
    originId?: string;
    references: SavedObjectReference[];
    type: string;
    updated_at?: string;
    version?: string;
}

// @public
export type SavedObjectAttribute = SavedObjectAttributeSingle | SavedObjectAttributeSingle[];

// @public
export interface SavedObjectAttributes {
    // (undocumented)
    [key: string]: SavedObjectAttribute;
}

// @public
export type SavedObjectAttributeSingle = string | number | boolean | null | undefined | SavedObjectAttributes;

// Warning: (ae-missing-release-tag) "SavedObjectError" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export interface SavedObjectError {
    // (undocumented)
    error: string;
    // (undocumented)
    message: string;
    // (undocumented)
    metadata?: Record<string, unknown>;
    // (undocumented)
    statusCode: number;
}

// @public
export interface SavedObjectReference {
    // (undocumented)
    id: string;
    // (undocumented)
    name: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectReferenceWithContext {
    id: string;
    inboundReferences: Array<{
        type: string;
        id: string;
        name: string;
    }>;
    isMissing?: boolean;
    spaces: string[];
    spacesWithMatchingAliases?: string[];
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBaseOptions {
    namespace?: string;
}

// @public (undocumented)
export interface SavedObjectsBatchResponse<T = unknown> {
    // (undocumented)
    savedObjects: Array<SimpleSavedObject<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateObject<T = unknown> extends SavedObjectsCreateOptions {
    // (undocumented)
    attributes: T;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateOptions {
    overwrite?: boolean;
}

// @public (undocumented)
export interface SavedObjectsBulkResolveObject {
    // (undocumented)
    id: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkResolveResponse<T = unknown> {
    // (undocumented)
    resolved_objects: Array<SavedObjectsResolveResponse<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateObject<T = unknown> {
    // (undocumented)
    attributes: T;
    // (undocumented)
    id: string;
    // (undocumented)
    references?: SavedObjectReference[];
    // (undocumented)
    type: string;
    // (undocumented)
    version?: string;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateOptions {
    // (undocumented)
    namespace?: string;
}

// @public
export class SavedObjectsClient {
    // @internal
    constructor(http: HttpSetup);
    bulkCreate: (objects?: SavedObjectsBulkCreateObject[], options?: SavedObjectsBulkCreateOptions) => Promise<SavedObjectsBatchResponse<unknown>>;
    bulkGet: (objects?: Array<{
        id: string;
        type: string;
    }>) => Promise<SavedObjectsBatchResponse<unknown>>;
    bulkResolve: <T = unknown>(objects?: Array<{
        id: string;
        type: string;
    }>) => Promise<{
        resolved_objects: ResolvedSimpleSavedObject<T>[];
    }>;
    bulkUpdate<T = unknown>(objects?: SavedObjectsBulkUpdateObject[]): Promise<SavedObjectsBatchResponse<unknown>>;
    create: <T = unknown>(type: string, attributes: T, options?: SavedObjectsCreateOptions) => Promise<SimpleSavedObject<T>>;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsDeleteOptions" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsClientContract" needs to be exported by the entry point index.d.ts
    delete: (type: string, id: string, options?: SavedObjectsDeleteOptions | undefined) => ReturnType<SavedObjectsClientContract_2['delete']>;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsFindOptions" needs to be exported by the entry point index.d.ts
    find: <T = unknown, A = unknown>(options: SavedObjectsFindOptions_2) => Promise<SavedObjectsFindResponsePublic<T, unknown>>;
    get: <T = unknown>(type: string, id: string) => Promise<SimpleSavedObject<T>>;
    resolve: <T = unknown>(type: string, id: string) => Promise<ResolvedSimpleSavedObject<T>>;
    update<T = unknown>(type: string, id: string, attributes: T, { version, references, upsert }?: SavedObjectsUpdateOptions): Promise<SimpleSavedObject<T>>;
}

// @public
export type SavedObjectsClientContract = PublicMethodsOf<SavedObjectsClient>;

// @public
export interface SavedObjectsCollectMultiNamespaceReferencesResponse {
    // (undocumented)
    objects: SavedObjectReferenceWithContext[];
}

// @public (undocumented)
export interface SavedObjectsCreateOptions {
    coreMigrationVersion?: string;
    id?: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    overwrite?: boolean;
    // (undocumented)
    references?: SavedObjectReference[];
}

// @public (undocumented)
export interface SavedObjectsFindOptions {
    // @alpha
    aggs?: Record<string, estypes.AggregationsAggregationContainer>;
    defaultSearchOperator?: 'AND' | 'OR';
    fields?: string[];
    // Warning: (ae-forgotten-export) The symbol "KueryNode" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    filter?: string | KueryNode;
    hasReference?: SavedObjectsFindOptionsReference | SavedObjectsFindOptionsReference[];
    hasReferenceOperator?: 'AND' | 'OR';
    // (undocumented)
    namespaces?: string[];
    // (undocumented)
    page?: number;
    // (undocumented)
    perPage?: number;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsPitParams" needs to be exported by the entry point index.d.ts
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: No member was found with name "openPointInTimeForType"
    pit?: SavedObjectsPitParams;
    preference?: string;
    rootSearchFields?: string[];
    search?: string;
    searchAfter?: estypes.Id[];
    searchFields?: string[];
    // (undocumented)
    sortField?: string;
    // (undocumented)
    sortOrder?: estypes.SearchSortOrder;
    // (undocumented)
    type: string | string[];
    typeToNamespacesMap?: Map<string, string[] | undefined>;
}

// @public (undocumented)
export interface SavedObjectsFindOptionsReference {
    // (undocumented)
    id: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsFindResponsePublic<T = unknown, A = unknown> extends SavedObjectsBatchResponse<T> {
    // (undocumented)
    aggregations?: A;
    // (undocumented)
    page: number;
    // (undocumented)
    perPage: number;
    // (undocumented)
    total: number;
}

// @public
export interface SavedObjectsImportActionRequiredWarning {
    actionPath: string;
    buttonLabel?: string;
    message: string;
    // (undocumented)
    type: 'action_required';
}

// @public
export interface SavedObjectsImportAmbiguousConflictError {
    // (undocumented)
    destinations: Array<{
        id: string;
        title?: string;
        updatedAt?: string;
    }>;
    // (undocumented)
    type: 'ambiguous_conflict';
}

// @public
export interface SavedObjectsImportConflictError {
    // (undocumented)
    destinationId?: string;
    // (undocumented)
    type: 'conflict';
}

// @public
export interface SavedObjectsImportFailure {
    // (undocumented)
    error: SavedObjectsImportConflictError | SavedObjectsImportAmbiguousConflictError | SavedObjectsImportUnsupportedTypeError | SavedObjectsImportMissingReferencesError | SavedObjectsImportUnknownError;
    // (undocumented)
    id: string;
    // (undocumented)
    meta: {
        title?: string;
        icon?: string;
    };
    overwrite?: boolean;
    // @deprecated (undocumented)
    title?: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportMissingReferencesError {
    // (undocumented)
    references: Array<{
        type: string;
        id: string;
    }>;
    // (undocumented)
    type: 'missing_references';
}

// @public
export interface SavedObjectsImportResponse {
    // (undocumented)
    errors?: SavedObjectsImportFailure[];
    // (undocumented)
    success: boolean;
    // (undocumented)
    successCount: number;
    // (undocumented)
    successResults?: SavedObjectsImportSuccess[];
    // (undocumented)
    warnings: SavedObjectsImportWarning[];
}

// @public
export interface SavedObjectsImportRetry {
    createNewCopy?: boolean;
    destinationId?: string;
    // (undocumented)
    id: string;
    ignoreMissingReferences?: boolean;
    // (undocumented)
    overwrite: boolean;
    // (undocumented)
    replaceReferences: Array<{
        type: string;
        from: string;
        to: string;
    }>;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportSimpleWarning {
    message: string;
    // (undocumented)
    type: 'simple';
}

// @public
export interface SavedObjectsImportSuccess {
    // @deprecated (undocumented)
    createNewCopy?: boolean;
    destinationId?: string;
    // (undocumented)
    id: string;
    // (undocumented)
    meta: {
        title?: string;
        icon?: string;
    };
    overwrite?: boolean;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportUnknownError {
    // (undocumented)
    message: string;
    // (undocumented)
    statusCode: number;
    // (undocumented)
    type: 'unknown';
}

// @public
export interface SavedObjectsImportUnsupportedTypeError {
    // (undocumented)
    type: 'unsupported_type';
}

// @public
export type SavedObjectsImportWarning = SavedObjectsImportSimpleWarning | SavedObjectsImportActionRequiredWarning;

// @public
export interface SavedObjectsMigrationVersion {
    // (undocumented)
    [pluginName: string]: string;
}

// @public
export type SavedObjectsNamespaceType = 'single' | 'multiple' | 'multiple-isolated' | 'agnostic';

// @public (undocumented)
export interface SavedObjectsResolveResponse<T = unknown> {
    alias_target_id?: string;
    outcome: 'exactMatch' | 'aliasMatch' | 'conflict';
    saved_object: SavedObject<T>;
}

// @public (undocumented)
export interface SavedObjectsStart {
    // (undocumented)
    client: SavedObjectsClientContract;
}

// @public (undocumented)
export interface SavedObjectsUpdateOptions<Attributes = unknown> {
    // (undocumented)
    references?: SavedObjectReference[];
    // (undocumented)
    upsert?: Attributes;
    // (undocumented)
    version?: string;
}

// @public
export class ScopedHistory<HistoryLocationState = unknown> implements History_2<HistoryLocationState> {
    constructor(parentHistory: History_2, basePath: string);
    get action(): Action;
    block: (prompt?: string | boolean | History_2.TransitionPromptHook<HistoryLocationState> | undefined) => UnregisterCallback;
    createHref: (location: LocationDescriptorObject<HistoryLocationState>, { prependBasePath }?: {
        prependBasePath?: boolean | undefined;
    }) => Href;
    createSubHistory: <SubHistoryLocationState = unknown>(basePath: string) => ScopedHistory<SubHistoryLocationState>;
    go: (n: number) => void;
    goBack: () => void;
    goForward: () => void;
    get length(): number;
    listen: (listener: (location: Location_2<HistoryLocationState>, action: Action) => void) => UnregisterCallback;
    get location(): Location_2<HistoryLocationState>;
    push: (pathOrLocation: Path | LocationDescriptorObject<HistoryLocationState>, state?: HistoryLocationState | undefined) => void;
    replace: (pathOrLocation: Path | LocationDescriptorObject<HistoryLocationState>, state?: HistoryLocationState | undefined) => void;
}

// @public
export class SimpleSavedObject<T = unknown> {
    constructor(client: SavedObjectsClientContract, { id, type, version, attributes, error, references, migrationVersion, coreMigrationVersion, namespaces, }: SavedObject<T>);
    // (undocumented)
    attributes: T;
    // (undocumented)
    coreMigrationVersion: SavedObject<T>['coreMigrationVersion'];
    // (undocumented)
    delete(): Promise<{}>;
    // (undocumented)
    error: SavedObject<T>['error'];
    // (undocumented)
    get(key: string): any;
    // (undocumented)
    has(key: string): boolean;
    // (undocumented)
    id: SavedObject<T>['id'];
    // (undocumented)
    migrationVersion: SavedObject<T>['migrationVersion'];
    namespaces: SavedObject<T>['namespaces'];
    // (undocumented)
    references: SavedObject<T>['references'];
    // (undocumented)
    save(): Promise<SimpleSavedObject<T>>;
    // (undocumented)
    set(key: string, value: any): T;
    // (undocumented)
    type: SavedObject<T>['type'];
    // (undocumented)
    _version?: SavedObject<T>['version'];
}

// @public
export type StartServicesAccessor<TPluginsStart extends object = object, TStart = unknown> = () => Promise<[CoreStart, TPluginsStart, TStart]>;

// Warning: (ae-missing-release-tag) "Toast" is exported by the package, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export type Toast = ToastInputFields & {
    id: string;
};

// @public
export type ToastInput = string | ToastInputFields;

// @public
export type ToastInputFields = Pick<EuiGlobalToastListToast, Exclude<keyof EuiGlobalToastListToast, 'id' | 'text' | 'title'>> & {
    title?: string | MountPoint;
    text?: string | MountPoint;
};

// @public
export interface ToastOptions {
    toastLifeTimeMs?: number;
}

// @public
export class ToastsApi implements IToasts {
    constructor(deps: {
        uiSettings: IUiSettingsClient;
    });
    add(toastOrTitle: ToastInput): Toast;
    addDanger(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    addError(error: Error, options: ErrorToastOptions): Toast;
    addInfo(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    addSuccess(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    addWarning(toastOrTitle: ToastInput, options?: ToastOptions): Toast;
    get$(): Rx.Observable<Toast[]>;
    remove(toastOrId: Toast | string): void;
    // @internal (undocumented)
    start({ overlays, i18n }: {
        overlays: OverlayStart;
        i18n: I18nStart;
    }): void;
}

// @public (undocumented)
export type ToastsSetup = IToasts;

// @public (undocumented)
export type ToastsStart = IToasts;

// @public
export interface UiSettingsParams<T = unknown> {
    category?: string[];
    // Warning: (ae-forgotten-export) The symbol "DeprecationSettings" needs to be exported by the entry point index.d.ts
    deprecation?: DeprecationSettings;
    description?: string;
    // @deprecated
    metric?: {
        type: UiCounterMetricType;
        name: string;
    };
    name?: string;
    optionLabels?: Record<string, string>;
    options?: string[];
    order?: number;
    readonly?: boolean;
    requiresPageReload?: boolean;
    // (undocumented)
    schema: Type<T>;
    sensitive?: boolean;
    type?: UiSettingsType;
    value?: T;
}

// @public (undocumented)
export interface UiSettingsState {
    // (undocumented)
    [key: string]: PublicUiSettingsParams_2 & UserProvidedValues_2;
}

// @public
export type UiSettingsType = 'undefined' | 'json' | 'markdown' | 'number' | 'select' | 'boolean' | 'string' | 'array' | 'image' | 'color';

// @public
export type UnmountCallback = () => void;

// @public
export const URL_MAX_LENGTH: number;

// @public
export interface UserProvidedValues<T = any> {
    // (undocumented)
    isOverridden?: boolean;
    // (undocumented)
    userValue?: T;
}

// Warnings were encountered during analysis:
//
// src/core/public/core_system.ts:168:21 - (ae-forgotten-export) The symbol "InternalApplicationStart" needs to be exported by the entry point index.d.ts

```
