"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.version = exports.tag = exports.euiThemeVars = exports.euiLightVars = exports.euiDarkVars = exports.darkMode = void 0;

var _eui_theme_light = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_light.json"));

var _eui_theme_dark = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_dark.json"));

var _eui_theme_amsterdam_light = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_amsterdam_light.json"));

var _eui_theme_amsterdam_dark = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_amsterdam_dark.json"));

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable-next-line @kbn/eslint/module_migration */

/* eslint-disable-next-line @kbn/eslint/module_migration */

/* eslint-disable-next-line @kbn/eslint/module_migration */

/* eslint-disable-next-line @kbn/eslint/module_migration */
const globals = typeof window === 'undefined' ? {} : window;
// in the Kibana app we can rely on this global being defined, but in
// some cases (like jest) the global is undefined
const tag = globals.__kbnThemeTag__ || 'v7light';
exports.tag = tag;
const version = tag.startsWith('v7') ? 7 : 8;
exports.version = version;
const darkMode = tag.endsWith('dark');
exports.darkMode = darkMode;
let euiLightVars;
exports.euiLightVars = euiLightVars;
let euiDarkVars;
exports.euiDarkVars = euiDarkVars;

if (version === 7) {
  exports.euiLightVars = euiLightVars = _eui_theme_light.default;
  exports.euiDarkVars = euiDarkVars = _eui_theme_dark.default;
} else {
  exports.euiLightVars = euiLightVars = _eui_theme_amsterdam_light.default;
  exports.euiDarkVars = euiDarkVars = _eui_theme_amsterdam_dark.default;
}
/**
 * EUI Theme vars that automatically adjust to light/dark theme
 */


let euiThemeVars;
exports.euiThemeVars = euiThemeVars;

if (darkMode) {
  exports.euiThemeVars = euiThemeVars = euiDarkVars;
} else {
  exports.euiThemeVars = euiThemeVars = euiLightVars;
}