import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { useLocation } from 'react-router-dom';
import { useRouter } from './use_router';
export function useParams() {
  var router = useRouter();
  var location = useLocation();
  var optional = false;

  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  var last = args[args.length - 1];

  if (typeof last === 'boolean') {
    optional = last;
    args.pop();
  }

  var paths = args;
  var getParamsArgs = [].concat(paths, [location, optional]);
  return router.getParams.apply(router, _toConsumableArray(getParamsArgs));
}