/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { createContext, useContext } from 'react';
import { jsx as ___EmotionJSX } from "@emotion/react";
var OutletContext = /*#__PURE__*/createContext(undefined);
export function OutletContextProvider(_ref) {
  var element = _ref.element,
      children = _ref.children;
  return ___EmotionJSX(OutletContext.Provider, {
    value: {
      element: element
    }
  }, children);
}
export function Outlet() {
  var outletContext = useContext(OutletContext);

  if (!outletContext) {
    throw new Error('Outlet context not available');
  }

  return outletContext.element || null;
}