/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { fold, mapLeft } from 'fp-ts/lib/Either';
import { pipe } from 'fp-ts/lib/pipeable';
import { fromEither } from 'fp-ts/lib/TaskEither';
import * as t from 'io-ts';
import { exactCheck } from '../exact_check';
import { formatErrors } from '../format_errors';
export var validate = function validate(obj, schema) {
  var decoded = schema.decode(obj);
  var checked = exactCheck(obj, decoded);

  var left = function left(errors) {
    return [null, formatErrors(errors).join(',')];
  };

  var right = function right(output) {
    return [output, null];
  };

  return pipe(checked, fold(left, right));
};
export var validateNonExact = function validateNonExact(obj, schema) {
  var decoded = schema.decode(obj);

  var left = function left(errors) {
    return [null, formatErrors(errors).join(',')];
  };

  var right = function right(output) {
    return [output, null];
  };

  return pipe(decoded, fold(left, right));
};
export var validateEither = function validateEither(schema, obj) {
  return pipe(obj, function (a) {
    return schema.validate(a, t.getDefaultContext(schema.asDecoder()));
  }, mapLeft(function (errors) {
    return new Error(formatErrors(errors).join(','));
  }));
};
export var validateTaskEither = function validateTaskEither(schema, obj) {
  return fromEither(validateEither(schema, obj));
};