"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.TIMESTAMP = exports.TAGS = exports.SPACE_IDS = exports.KIBANA_NAMESPACE = exports.EVENT_KIND = exports.EVENT_ACTION = exports.ECS_VERSION = exports.CONSUMERS = exports.ALERT_WORKFLOW_USER = exports.ALERT_WORKFLOW_STATUS = exports.ALERT_WORKFLOW_REASON = exports.ALERT_UUID = exports.ALERT_SYSTEM_STATUS = exports.ALERT_STATUS = exports.ALERT_START = exports.ALERT_SEVERITY = exports.ALERT_RULE_VERSION = exports.ALERT_RULE_UUID = exports.ALERT_RULE_UPDATED_BY = exports.ALERT_RULE_UPDATED_AT = exports.ALERT_RULE_TYPE_ID = exports.ALERT_RULE_TYPE = exports.ALERT_RULE_TO = exports.ALERT_RULE_TAGS = exports.ALERT_RULE_SEVERITY_MAPPING = exports.ALERT_RULE_SEVERITY = exports.ALERT_RULE_RULE_NAME_OVERRIDE = exports.ALERT_RULE_RULE_ID = exports.ALERT_RULE_RISK_SCORE_MAPPING = exports.ALERT_RULE_RISK_SCORE = exports.ALERT_RULE_REFERENCES = exports.ALERT_RULE_PRODUCER = exports.ALERT_RULE_PARAMS = exports.ALERT_RULE_NOTE = exports.ALERT_RULE_NAMESPACE = exports.ALERT_RULE_NAME = exports.ALERT_RULE_LICENSE = exports.ALERT_RULE_INTERVAL = exports.ALERT_RULE_FROM = exports.ALERT_RULE_ENABLED = exports.ALERT_RULE_DESCRIPTION = exports.ALERT_RULE_CREATED_BY = exports.ALERT_RULE_CREATED_AT = exports.ALERT_RULE_CONSUMER = exports.ALERT_RULE_CATEGORY = exports.ALERT_RULE_AUTHOR = exports.ALERT_RISK_SCORE = exports.ALERT_REASON = exports.ALERT_NAMESPACE = exports.ALERT_INSTANCE_ID = exports.ALERT_EVALUATION_VALUE = exports.ALERT_EVALUATION_THRESHOLD = exports.ALERT_END = exports.ALERT_DURATION = exports.ALERT_ACTION_GROUP = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const KIBANA_NAMESPACE = 'kibana';
exports.KIBANA_NAMESPACE = KIBANA_NAMESPACE;
const ALERT_NAMESPACE = `${KIBANA_NAMESPACE}.alert`;
exports.ALERT_NAMESPACE = ALERT_NAMESPACE;
const ALERT_RULE_NAMESPACE = `${ALERT_NAMESPACE}.rule`;
exports.ALERT_RULE_NAMESPACE = ALERT_RULE_NAMESPACE;
const CONSUMERS = `${KIBANA_NAMESPACE}.consumers`;
exports.CONSUMERS = CONSUMERS;
const ECS_VERSION = 'ecs.version';
exports.ECS_VERSION = ECS_VERSION;
const EVENT_ACTION = 'event.action';
exports.EVENT_ACTION = EVENT_ACTION;
const EVENT_KIND = 'event.kind';
exports.EVENT_KIND = EVENT_KIND;
const SPACE_IDS = `${KIBANA_NAMESPACE}.space_ids`;
exports.SPACE_IDS = SPACE_IDS;
const TAGS = 'tags';
exports.TAGS = TAGS;
const TIMESTAMP = '@timestamp';
exports.TIMESTAMP = TIMESTAMP;
const VERSION = `${KIBANA_NAMESPACE}.version`; // Fields pertaining to the alert

exports.VERSION = VERSION;
const ALERT_ACTION_GROUP = `${ALERT_NAMESPACE}.action_group`;
exports.ALERT_ACTION_GROUP = ALERT_ACTION_GROUP;
const ALERT_DURATION = `${ALERT_NAMESPACE}.duration.us`;
exports.ALERT_DURATION = ALERT_DURATION;
const ALERT_END = `${ALERT_NAMESPACE}.end`;
exports.ALERT_END = ALERT_END;
const ALERT_EVALUATION_THRESHOLD = `${ALERT_NAMESPACE}.evaluation.threshold`;
exports.ALERT_EVALUATION_THRESHOLD = ALERT_EVALUATION_THRESHOLD;
const ALERT_EVALUATION_VALUE = `${ALERT_NAMESPACE}.evaluation.value`;
exports.ALERT_EVALUATION_VALUE = ALERT_EVALUATION_VALUE;
const ALERT_INSTANCE_ID = `${ALERT_NAMESPACE}.instance.id`;
exports.ALERT_INSTANCE_ID = ALERT_INSTANCE_ID;
const ALERT_REASON = `${ALERT_NAMESPACE}.reason`;
exports.ALERT_REASON = ALERT_REASON;
const ALERT_RISK_SCORE = `${ALERT_NAMESPACE}.risk_score`;
exports.ALERT_RISK_SCORE = ALERT_RISK_SCORE;
const ALERT_SEVERITY = `${ALERT_NAMESPACE}.severity`;
exports.ALERT_SEVERITY = ALERT_SEVERITY;
const ALERT_START = `${ALERT_NAMESPACE}.start`;
exports.ALERT_START = ALERT_START;
const ALERT_STATUS = `${ALERT_NAMESPACE}.status`;
exports.ALERT_STATUS = ALERT_STATUS;
const ALERT_SYSTEM_STATUS = `${ALERT_NAMESPACE}.system_status`;
exports.ALERT_SYSTEM_STATUS = ALERT_SYSTEM_STATUS;
const ALERT_UUID = `${ALERT_NAMESPACE}.uuid`;
exports.ALERT_UUID = ALERT_UUID;
const ALERT_WORKFLOW_REASON = `${ALERT_NAMESPACE}.workflow_reason`;
exports.ALERT_WORKFLOW_REASON = ALERT_WORKFLOW_REASON;
const ALERT_WORKFLOW_STATUS = `${ALERT_NAMESPACE}.workflow_status`;
exports.ALERT_WORKFLOW_STATUS = ALERT_WORKFLOW_STATUS;
const ALERT_WORKFLOW_USER = `${ALERT_NAMESPACE}.workflow_user`; // Fields pertaining to the rule associated with the alert

exports.ALERT_WORKFLOW_USER = ALERT_WORKFLOW_USER;
const ALERT_RULE_AUTHOR = `${ALERT_RULE_NAMESPACE}.author`;
exports.ALERT_RULE_AUTHOR = ALERT_RULE_AUTHOR;
const ALERT_RULE_CREATED_AT = `${ALERT_RULE_NAMESPACE}.created_at`;
exports.ALERT_RULE_CREATED_AT = ALERT_RULE_CREATED_AT;
const ALERT_RULE_CREATED_BY = `${ALERT_RULE_NAMESPACE}.created_by`;
exports.ALERT_RULE_CREATED_BY = ALERT_RULE_CREATED_BY;
const ALERT_RULE_DESCRIPTION = `${ALERT_RULE_NAMESPACE}.description`;
exports.ALERT_RULE_DESCRIPTION = ALERT_RULE_DESCRIPTION;
const ALERT_RULE_ENABLED = `${ALERT_RULE_NAMESPACE}.enabled`;
exports.ALERT_RULE_ENABLED = ALERT_RULE_ENABLED;
const ALERT_RULE_FROM = `${ALERT_RULE_NAMESPACE}.from`;
exports.ALERT_RULE_FROM = ALERT_RULE_FROM;
const ALERT_RULE_INTERVAL = `${ALERT_RULE_NAMESPACE}.interval`;
exports.ALERT_RULE_INTERVAL = ALERT_RULE_INTERVAL;
const ALERT_RULE_LICENSE = `${ALERT_RULE_NAMESPACE}.license`;
exports.ALERT_RULE_LICENSE = ALERT_RULE_LICENSE;
const ALERT_RULE_CATEGORY = `${ALERT_RULE_NAMESPACE}.category`;
exports.ALERT_RULE_CATEGORY = ALERT_RULE_CATEGORY;
const ALERT_RULE_NAME = `${ALERT_RULE_NAMESPACE}.name`;
exports.ALERT_RULE_NAME = ALERT_RULE_NAME;
const ALERT_RULE_NOTE = `${ALERT_RULE_NAMESPACE}.note`;
exports.ALERT_RULE_NOTE = ALERT_RULE_NOTE;
const ALERT_RULE_PARAMS = `${ALERT_RULE_NAMESPACE}.params`;
exports.ALERT_RULE_PARAMS = ALERT_RULE_PARAMS;
const ALERT_RULE_REFERENCES = `${ALERT_RULE_NAMESPACE}.references`;
exports.ALERT_RULE_REFERENCES = ALERT_RULE_REFERENCES;
const ALERT_RULE_RISK_SCORE = `${ALERT_RULE_NAMESPACE}.risk_score`;
exports.ALERT_RULE_RISK_SCORE = ALERT_RULE_RISK_SCORE;
const ALERT_RULE_RISK_SCORE_MAPPING = `${ALERT_RULE_NAMESPACE}.risk_score_mapping`;
exports.ALERT_RULE_RISK_SCORE_MAPPING = ALERT_RULE_RISK_SCORE_MAPPING;
const ALERT_RULE_RULE_ID = `${ALERT_RULE_NAMESPACE}.rule_id`;
exports.ALERT_RULE_RULE_ID = ALERT_RULE_RULE_ID;
const ALERT_RULE_RULE_NAME_OVERRIDE = `${ALERT_RULE_NAMESPACE}.rule_name_override`;
exports.ALERT_RULE_RULE_NAME_OVERRIDE = ALERT_RULE_RULE_NAME_OVERRIDE;
const ALERT_RULE_SEVERITY = `${ALERT_RULE_NAMESPACE}.severity`;
exports.ALERT_RULE_SEVERITY = ALERT_RULE_SEVERITY;
const ALERT_RULE_SEVERITY_MAPPING = `${ALERT_RULE_NAMESPACE}.severity_mapping`;
exports.ALERT_RULE_SEVERITY_MAPPING = ALERT_RULE_SEVERITY_MAPPING;
const ALERT_RULE_TAGS = `${ALERT_RULE_NAMESPACE}.tags`;
exports.ALERT_RULE_TAGS = ALERT_RULE_TAGS;
const ALERT_RULE_TO = `${ALERT_RULE_NAMESPACE}.to`;
exports.ALERT_RULE_TO = ALERT_RULE_TO;
const ALERT_RULE_TYPE = `${ALERT_RULE_NAMESPACE}.type`;
exports.ALERT_RULE_TYPE = ALERT_RULE_TYPE;
const ALERT_RULE_TYPE_ID = `${ALERT_RULE_NAMESPACE}.rule_type_id`;
exports.ALERT_RULE_TYPE_ID = ALERT_RULE_TYPE_ID;
const ALERT_RULE_UPDATED_AT = `${ALERT_RULE_NAMESPACE}.updated_at`;
exports.ALERT_RULE_UPDATED_AT = ALERT_RULE_UPDATED_AT;
const ALERT_RULE_UPDATED_BY = `${ALERT_RULE_NAMESPACE}.updated_by`;
exports.ALERT_RULE_UPDATED_BY = ALERT_RULE_UPDATED_BY;
const ALERT_RULE_VERSION = `${ALERT_RULE_NAMESPACE}.version`; // the feature instantiating a rule type.
// Rule created in stack --> alerts
// Rule created in siem --> siem

exports.ALERT_RULE_VERSION = ALERT_RULE_VERSION;
const ALERT_RULE_CONSUMER = `${ALERT_RULE_NAMESPACE}.consumer`; // the plugin that registered the rule type.
// Rule type apm.error_rate --> apm
// Rule type siem.signals --> siem

exports.ALERT_RULE_CONSUMER = ALERT_RULE_CONSUMER;
const ALERT_RULE_PRODUCER = `${ALERT_RULE_NAMESPACE}.producer`;
exports.ALERT_RULE_PRODUCER = ALERT_RULE_PRODUCER;
const ALERT_RULE_UUID = `${ALERT_RULE_NAMESPACE}.uuid`;
exports.ALERT_RULE_UUID = ALERT_RULE_UUID;
const namespaces = {
  KIBANA_NAMESPACE,
  ALERT_NAMESPACE,
  ALERT_RULE_NAMESPACE
};
const fields = {
  CONSUMERS,
  ECS_VERSION,
  EVENT_KIND,
  EVENT_ACTION,
  TAGS,
  TIMESTAMP,
  ALERT_ACTION_GROUP,
  ALERT_DURATION,
  ALERT_END,
  ALERT_EVALUATION_THRESHOLD,
  ALERT_EVALUATION_VALUE,
  ALERT_INSTANCE_ID,
  ALERT_RULE_CONSUMER,
  ALERT_RULE_PRODUCER,
  ALERT_REASON,
  ALERT_RISK_SCORE,
  ALERT_RULE_AUTHOR,
  ALERT_RULE_CREATED_AT,
  ALERT_RULE_CREATED_BY,
  ALERT_RULE_DESCRIPTION,
  ALERT_RULE_ENABLED,
  ALERT_RULE_FROM,
  ALERT_RULE_INTERVAL,
  ALERT_RULE_LICENSE,
  ALERT_RULE_NAME,
  ALERT_RULE_NOTE,
  ALERT_RULE_PARAMS,
  ALERT_RULE_REFERENCES,
  ALERT_RULE_RISK_SCORE,
  ALERT_RULE_RISK_SCORE_MAPPING,
  ALERT_RULE_RULE_ID,
  ALERT_RULE_RULE_NAME_OVERRIDE,
  ALERT_RULE_SEVERITY,
  ALERT_RULE_SEVERITY_MAPPING,
  ALERT_RULE_TAGS,
  ALERT_RULE_TO,
  ALERT_RULE_TYPE,
  ALERT_RULE_TYPE_ID,
  ALERT_RULE_UPDATED_AT,
  ALERT_RULE_UPDATED_BY,
  ALERT_RULE_VERSION,
  ALERT_START,
  ALERT_SEVERITY,
  ALERT_STATUS,
  ALERT_SYSTEM_STATUS,
  ALERT_UUID,
  ALERT_WORKFLOW_REASON,
  ALERT_WORKFLOW_STATUS,
  ALERT_WORKFLOW_USER,
  ALERT_RULE_UUID,
  ALERT_RULE_CATEGORY,
  SPACE_IDS,
  VERSION
};