import _defineProperty from "@babel/runtime/helpers/defineProperty";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as ast from '../ast';
export function buildNodeParams(children) {
  return {
    arguments: children
  };
}
export function toElasticsearchQuery(node, indexPattern) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var filtersInMustClause = config.filtersInMustClause;
  var children = node.arguments || [];
  var key = filtersInMustClause ? 'must' : 'filter';
  return {
    bool: _defineProperty({}, key, children.map(function (child) {
      return ast.toElasticsearchQuery(child, indexPattern, config, context);
    }))
  };
}