"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "KQLSyntaxError", {
  enumerable: true,
  get: function () {
    return _kuery_syntax_error.KQLSyntaxError;
  }
});
Object.defineProperty(exports, "fromKueryExpression", {
  enumerable: true,
  get: function () {
    return _ast.fromKueryExpression;
  }
});
Object.defineProperty(exports, "nodeBuilder", {
  enumerable: true,
  get: function () {
    return _node_types.nodeBuilder;
  }
});
Object.defineProperty(exports, "nodeTypes", {
  enumerable: true,
  get: function () {
    return _node_types.nodeTypes;
  }
});
exports.toElasticsearchQuery = void 0;

var _ast = require("./ast");

var _kuery_syntax_error = require("./kuery_syntax_error");

var _node_types = require("./node_types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @params {String} indexPattern
 * @params {Object} config - contains the dateFormatTZ
 *
 * IndexPattern isn't required, but if you pass one in, we can be more intelligent
 * about how we craft the queries (e.g. scripted fields)
 */
const toElasticsearchQuery = (...params) => {
  return (0, _ast.toElasticsearchQuery)(...params);
};

exports.toElasticsearchQuery = toElasticsearchQuery;