// @flow
export { getExpressionsFromTemplateLiteral } from './minify'
export { getLabelFromPath } from './label'
export { getSourceMap } from './source-maps'
export { getTargetClassName } from './get-target-class-name'
export { simplifyObject } from './object-to-string'

export const appendStringToExpressions = (
  expressions: Array<*>,
  string: string,
  t: *
) => {
  if (!string) {
    return expressions
  }
  if (t.isStringLiteral(expressions[expressions.length - 1])) {
    expressions[expressions.length - 1].value += string
  } else {
    expressions.push(t.stringLiteral(string))
  }
  return expressions
}

export const joinStringLiterals = (expressions: Array<*>, t: *) => {
  return expressions.reduce((finalExpressions, currentExpression, i) => {
    if (!t.isStringLiteral(currentExpression)) {
      finalExpressions.push(currentExpression)
    } else if (
      t.isStringLiteral(finalExpressions[finalExpressions.length - 1])
    ) {
      finalExpressions[finalExpressions.length - 1].value +=
        currentExpression.value
    } else {
      finalExpressions.push(currentExpression)
    }
    return finalExpressions
  }, [])
}
