"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function isTypeNumber(value) {
  return value !== undefined && value !== null && typeof value === "number";
}

function isTypeBoolean(value) {
  return value && typeof value === "boolean";
}

function toBoolean(value) {
  if (value === "true") return true;
  if (value === "false") return false;
  throw "Invalid type parsed as Boolean value";
}
/* Encoder for qs library which preserve number types on the URL. Numbers
are padded with "n_{number}_n", and booleans with "b_{boolean}_b"*/


var _default = {
  encode: function encode(value, _encode) {
    if (isTypeNumber(value)) {
      return "n_".concat(value, "_n");
    }

    if (isTypeBoolean(value)) {
      return "b_".concat(value, "_b");
    }

    return _encode(value);
  },
  decode: function decode(value, _decode) {
    //eslint-disable-next-line
    if (/n_-?[\d\.]*_n/.test(value)) {
      var numericValueString = value.substring(2, value.length - 2);
      return Number(numericValueString);
    }

    if (/^b_(true|false)*_b$/.test(value)) {
      var booleanValueString = value.substring(2, value.length - 2);
      return toBoolean(booleanValueString);
    }

    return _decode(value);
  }
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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