"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = trackClickThrough;

/**
 * Report a click through event. A click through event is when a user
 * clicks on a result link.
 *
 * @param documentId String The document ID associated with result that was
 * clicked
 * @param tag Array[String] Optional Tags which can be used to categorize
 * this click event
 */
function trackClickThrough(documentId) {
  var _console;

  var tags = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "trackClickThrough"].concat(Array.prototype.slice.call(arguments)));
  var _this$state = this.state,
      requestId = _this$state.requestId,
      searchTerm = _this$state.searchTerm;
  this.events.resultClick({
    query: searchTerm,
    documentId: documentId,
    requestId: requestId,
    tags: tags
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL3RyYWNrQ2xpY2tUaHJvdWdoLmpzIl0sIm5hbWVzIjpbInRyYWNrQ2xpY2tUaHJvdWdoIiwiZG9jdW1lbnRJZCIsInRhZ3MiLCJkZWJ1ZyIsImNvbnNvbGUiLCJsb2ciLCJhcmd1bWVudHMiLCJzdGF0ZSIsInJlcXVlc3RJZCIsInNlYXJjaFRlcm0iLCJldmVudHMiLCJyZXN1bHRDbGljayIsInF1ZXJ5Il0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ2UsU0FBU0EsaUJBQVQsQ0FBMkJDLFVBQTNCLEVBQWtEO0FBQUE7O0FBQUEsTUFBWEMsSUFBVyx1RUFBSixFQUFJO0FBQy9ELE1BQUksS0FBS0MsS0FBVCxFQUNFO0FBQ0EsZ0JBQUFDLE9BQU8sRUFBQ0MsR0FBUixrQkFBWSxtQkFBWixFQUFpQyxtQkFBakMsb0NBQXlEQyxTQUF6RDtBQUg2RCxvQkFLN0IsS0FBS0MsS0FMd0I7QUFBQSxNQUt2REMsU0FMdUQsZUFLdkRBLFNBTHVEO0FBQUEsTUFLNUNDLFVBTDRDLGVBSzVDQSxVQUw0QztBQU8vRCxPQUFLQyxNQUFMLENBQVlDLFdBQVosQ0FBd0I7QUFDdEJDLElBQUFBLEtBQUssRUFBRUgsVUFEZTtBQUV0QlIsSUFBQUEsVUFBVSxFQUFWQSxVQUZzQjtBQUd0Qk8sSUFBQUEsU0FBUyxFQUFUQSxTQUhzQjtBQUl0Qk4sSUFBQUEsSUFBSSxFQUFKQTtBQUpzQixHQUF4QjtBQU1EIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBSZXBvcnQgYSBjbGljayB0aHJvdWdoIGV2ZW50LiBBIGNsaWNrIHRocm91Z2ggZXZlbnQgaXMgd2hlbiBhIHVzZXJcbiAqIGNsaWNrcyBvbiBhIHJlc3VsdCBsaW5rLlxuICpcbiAqIEBwYXJhbSBkb2N1bWVudElkIFN0cmluZyBUaGUgZG9jdW1lbnQgSUQgYXNzb2NpYXRlZCB3aXRoIHJlc3VsdCB0aGF0IHdhc1xuICogY2xpY2tlZFxuICogQHBhcmFtIHRhZyBBcnJheVtTdHJpbmddIE9wdGlvbmFsIFRhZ3Mgd2hpY2ggY2FuIGJlIHVzZWQgdG8gY2F0ZWdvcml6ZVxuICogdGhpcyBjbGljayBldmVudFxuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiB0cmFja0NsaWNrVGhyb3VnaChkb2N1bWVudElkLCB0YWdzID0gW10pIHtcbiAgaWYgKHRoaXMuZGVidWcpXG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWNvbnNvbGVcbiAgICBjb25zb2xlLmxvZyhcIlNlYXJjaCBVSTogQWN0aW9uXCIsIFwidHJhY2tDbGlja1Rocm91Z2hcIiwgLi4uYXJndW1lbnRzKTtcblxuICBjb25zdCB7IHJlcXVlc3RJZCwgc2VhcmNoVGVybSB9ID0gdGhpcy5zdGF0ZTtcblxuICB0aGlzLmV2ZW50cy5yZXN1bHRDbGljayh7XG4gICAgcXVlcnk6IHNlYXJjaFRlcm0sXG4gICAgZG9jdW1lbnRJZCxcbiAgICByZXF1ZXN0SWQsXG4gICAgdGFnc1xuICB9KTtcbn1cbiJdfQ==