"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = a11yNotify;

var _A11yNotifications = require("../A11yNotifications");

/**
 * Announces a specific message in `a11yNotificationMessages`
 * to Search UI's screen reader live region.
 *
 * @param {string} messageFunc - key of a message function in `a11yNotificationMessages`
 * @param {object} [messageArgs] - arguments to pass to the message function, if any
 */
function a11yNotify(messageFunc, messageArgs) {
  if (!this.hasA11yNotifications) return;
  var getMessage = this.a11yNotificationMessages[messageFunc];

  if (!getMessage) {
    var errorMessage = "Could not find corresponding message function in a11yNotificationMessages: \"".concat(messageFunc, "\"");
    console.warn("Action", "a11yNotify", errorMessage);
    return;
  }

  var message = getMessage(messageArgs);
  (0, _A11yNotifications.announceToScreenReader)(message);

  if (this.debug) {
    // eslint-disable-next-line no-console
    console.log("Search UI: Action", "a11yNotify", {
      messageFunc: messageFunc,
      messageArgs: messageArgs,
      message: message
    });
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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