function isTypeNumber(value) {
  return value !== undefined && value !== null && typeof value === "number";
}

function isTypeBoolean(value) {
  return value && typeof value === "boolean";
}

function toBoolean(value) {
  if (value === "true") return true;
  if (value === "false") return false;
  throw "Invalid type parsed as Boolean value";
}
/* Encoder for qs library which preserve number types on the URL. Numbers
are padded with "n_{number}_n", and booleans with "b_{boolean}_b"*/


export default {
  encode: function encode(value, _encode) {
    if (isTypeNumber(value)) {
      return "n_".concat(value, "_n");
    }

    if (isTypeBoolean(value)) {
      return "b_".concat(value, "_b");
    }

    return _encode(value);
  },
  decode: function decode(value, _decode) {
    //eslint-disable-next-line
    if (/n_-?[\d\.]*_n/.test(value)) {
      var numericValueString = value.substring(2, value.length - 2);
      return Number(numericValueString);
    }

    if (/^b_(true|false)*_b$/.test(value)) {
      var booleanValueString = value.substring(2, value.length - 2);
      return toBoolean(booleanValueString);
    }

    return _decode(value);
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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