/*
Since Filter Values come in many different varieties, this helper
encapsulates the logic for determining how to show the label of that
filter in the UI.
*/
export default function getFilterValueDisplay(filterValue) {
  if (filterValue === undefined || filterValue === null) return "";
  if (filterValue.hasOwnProperty("name")) return filterValue.name;
  return String(filterValue);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy92aWV3LWhlbHBlcnMvZ2V0RmlsdGVyVmFsdWVEaXNwbGF5LmpzIl0sIm5hbWVzIjpbImdldEZpbHRlclZhbHVlRGlzcGxheSIsImZpbHRlclZhbHVlIiwidW5kZWZpbmVkIiwiaGFzT3duUHJvcGVydHkiLCJuYW1lIiwiU3RyaW5nIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSxTQUFTQSxxQkFBVCxDQUErQkMsV0FBL0IsRUFBNEM7QUFDekQsTUFBSUEsV0FBVyxLQUFLQyxTQUFoQixJQUE2QkQsV0FBVyxLQUFLLElBQWpELEVBQXVELE9BQU8sRUFBUDtBQUN2RCxNQUFJQSxXQUFXLENBQUNFLGNBQVosQ0FBMkIsTUFBM0IsQ0FBSixFQUF3QyxPQUFPRixXQUFXLENBQUNHLElBQW5CO0FBQ3hDLFNBQU9DLE1BQU0sQ0FBQ0osV0FBRCxDQUFiO0FBQ0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuU2luY2UgRmlsdGVyIFZhbHVlcyBjb21lIGluIG1hbnkgZGlmZmVyZW50IHZhcmlldGllcywgdGhpcyBoZWxwZXJcbmVuY2Fwc3VsYXRlcyB0aGUgbG9naWMgZm9yIGRldGVybWluaW5nIGhvdyB0byBzaG93IHRoZSBsYWJlbCBvZiB0aGF0XG5maWx0ZXIgaW4gdGhlIFVJLlxuKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGdldEZpbHRlclZhbHVlRGlzcGxheShmaWx0ZXJWYWx1ZSkge1xuICBpZiAoZmlsdGVyVmFsdWUgPT09IHVuZGVmaW5lZCB8fCBmaWx0ZXJWYWx1ZSA9PT0gbnVsbCkgcmV0dXJuIFwiXCI7XG4gIGlmIChmaWx0ZXJWYWx1ZS5oYXNPd25Qcm9wZXJ0eShcIm5hbWVcIikpIHJldHVybiBmaWx0ZXJWYWx1ZS5uYW1lO1xuICByZXR1cm4gU3RyaW5nKGZpbHRlclZhbHVlKTtcbn1cbiJdfQ==