import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import PropTypes from "prop-types";
import React from "react";
import { Result } from "./types";
import { Suggestion } from "./types";
import { appendClassName } from "./view-helpers";

function getRaw(result, value) {
  if (!result[value] || !result[value].raw) return;
  return result[value].raw;
}

function getSnippet(result, value) {
  if (!result[value] || !result[value].snippet) return;
  return result[value].snippet;
}

function getSuggestionTitle(suggestionType, autocompleteSuggestions) {
  if (autocompleteSuggestions.sectionTitle) {
    return autocompleteSuggestions.sectionTitle;
  }

  if (autocompleteSuggestions[suggestionType] && autocompleteSuggestions[suggestionType].sectionTitle) {
    return autocompleteSuggestions[suggestionType].sectionTitle;
  }
}

function Autocomplete(_ref) {
  var autocompleteResults = _ref.autocompleteResults,
      autocompletedResults = _ref.autocompletedResults,
      autocompleteSuggestions = _ref.autocompleteSuggestions,
      autocompletedSuggestions = _ref.autocompletedSuggestions,
      className = _ref.className,
      getItemProps = _ref.getItemProps,
      getMenuProps = _ref.getMenuProps;
  var index = 0;
  return /*#__PURE__*/React.createElement("div", getMenuProps({
    className: appendClassName("sui-search-box__autocomplete-container", className)
  }), /*#__PURE__*/React.createElement("div", null, !!autocompleteSuggestions && Object.entries(autocompletedSuggestions).map(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        suggestionType = _ref3[0],
        suggestions = _ref3[1];

    return /*#__PURE__*/React.createElement(React.Fragment, {
      key: suggestionType
    }, getSuggestionTitle(suggestionType, autocompleteSuggestions) && suggestions.length > 0 && /*#__PURE__*/React.createElement("div", {
      className: "sui-search-box__section-title"
    }, getSuggestionTitle(suggestionType, autocompleteSuggestions)), suggestions.length > 0 && /*#__PURE__*/React.createElement("ul", {
      className: "sui-search-box__suggestion-list"
    }, suggestions.map(function (suggestion) {
      index++;
      return (
        /*#__PURE__*/
        // eslint-disable-next-line react/jsx-key
        React.createElement("li", getItemProps({
          key: suggestion.suggestion || suggestion.highlight,
          index: index - 1,
          item: suggestion
        }), suggestion.highlight ? /*#__PURE__*/React.createElement("span", {
          dangerouslySetInnerHTML: {
            __html: suggestion.highlight
          }
        }) : /*#__PURE__*/React.createElement("span", null, suggestion.suggestion))
      );
    })));
  }), !!autocompleteResults && !!autocompletedResults && autocompletedResults.length > 0 && autocompleteResults.sectionTitle && /*#__PURE__*/React.createElement("div", {
    className: "sui-search-box__section-title"
  }, autocompleteResults.sectionTitle), !!autocompleteResults && !!autocompletedResults && autocompletedResults.length > 0 && /*#__PURE__*/React.createElement("ul", {
    className: "sui-search-box__results-list"
  }, autocompletedResults.map(function (result) {
    index++;
    var titleSnippet = getSnippet(result, autocompleteResults.titleField);
    var titleRaw = getRaw(result, autocompleteResults.titleField);
    return (
      /*#__PURE__*/
      // eslint-disable-next-line react/jsx-key
      React.createElement("li", getItemProps({
        key: result.id.raw,
        index: index - 1,
        item: result
      }), titleSnippet ? /*#__PURE__*/React.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: titleSnippet
        }
      }) : /*#__PURE__*/React.createElement("span", null, titleRaw))
    );
  }))));
}

Autocomplete.propTypes = {
  allAutocompletedItemsCount: PropTypes.number.isRequired,
  autocompleteResults: PropTypes.oneOfType([PropTypes.bool, PropTypes.shape({
    titleField: PropTypes.string.isRequired,
    urlField: PropTypes.string.isRequired,
    linkTarget: PropTypes.string,
    sectionTitle: PropTypes.string
  })]),
  autocompletedResults: PropTypes.arrayOf(Result).isRequired,
  autocompletedSuggestions: PropTypes.objectOf(PropTypes.arrayOf(Suggestion)).isRequired,
  autocompletedSuggestionsCount: PropTypes.number.isRequired,
  autocompleteSuggestions: PropTypes.oneOfType([PropTypes.bool, PropTypes.exact({
    sectionTitle: PropTypes.string
  }), PropTypes.objectOf(PropTypes.exact({
    sectionTitle: PropTypes.string
  }))]),
  getItemProps: PropTypes.func.isRequired,
  getMenuProps: PropTypes.func.isRequired,
  className: PropTypes.string
};
export default Autocomplete;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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