"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowHeightUtils = exports.AUTO_HEIGHT = void 0;

var _predicate = require("../../services/predicate");

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var cellPaddingsToClassMap = {
  s: 'euiDataGridRowCell--paddingSmall',
  m: '',
  l: 'euiDataGridRowCell--paddingLarge'
};
var fontSizesToClassMap = {
  s: 'euiDataGridRowCell--fontSizeSmall',
  m: '',
  l: 'euiDataGridRowCell--fontSizeLarge'
};

function getNumberFromPx(style) {
  return style ? parseInt(style.replace('px', ''), 10) : 0;
}

var AUTO_HEIGHT = 'auto';
exports.AUTO_HEIGHT = AUTO_HEIGHT;
var DEFAULT_HEIGHT = 32; // So that we use lineCount options we should know exactly row height which allow to show defined line count.
// For this we should know paddings and line height. Because of this we should compute styles for cell with grid styles

var RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils() {
    var _this = this;

    _classCallCheck(this, RowHeightUtils);

    _defineProperty(this, "styles", {
      paddingTop: 0,
      paddingBottom: 0,
      lineHeight: 1
    });

    _defineProperty(this, "fakeCell", document.createElement('div'));

    _defineProperty(this, "heightsCache", new Map());

    _defineProperty(this, "timerId", void 0);

    _defineProperty(this, "grid", void 0);

    _defineProperty(this, "lastUpdatedRow", Infinity);

    _defineProperty(this, "getStylesForCell", function (rowHeightsOptions, rowIndex) {
      if (_this.isAutoHeight(rowIndex, rowHeightsOptions)) {
        return {};
      }

      var initialHeight = rowHeightsOptions.rowHeights && rowHeightsOptions.rowHeights[rowIndex];

      if (!initialHeight) {
        initialHeight = rowHeightsOptions.defaultHeight;
      }

      if ((0, _predicate.isObject)(initialHeight) && initialHeight.lineCount) {
        return {
          WebkitLineClamp: initialHeight.lineCount,
          display: '-webkit-box',
          WebkitBoxOrient: 'vertical',
          height: '100%',
          overflow: 'hidden'
        };
      }

      return {
        height: '100%',
        overflow: 'hidden'
      };
    });
  }

  _createClass(RowHeightUtils, [{
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_HEIGHT;
      var visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var rowHeights = this.heightsCache.get(rowIndex) || new Map();
      var adaptedHeight = Math.ceil(height + this.styles.paddingTop + this.styles.paddingBottom);

      if (rowHeights.get(colId) === adaptedHeight) {
        return;
      }

      rowHeights.set(colId, adaptedHeight);
      this.heightsCache.set(rowIndex, rowHeights);
      this.resetRow(visibleRowIndex);
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var visibleColumnIds = new Set(visibleColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      }));
      var didModify = false;
      this.heightsCache.forEach(function (rowHeights) {
        var existingColumnIds = Array.from(rowHeights.keys());
        existingColumnIds.forEach(function (existingColumnId) {
          if (visibleColumnIds.has(existingColumnId) === false) {
            didModify = true;
            rowHeights.delete(existingColumnId);
          }
        });
      });

      if (didModify) {
        this.resetRow(0);
      }
    }
  }, {
    key: "resetRow",
    value: function resetRow(visibleRowIndex) {
      var _this2 = this;

      // save the first row index of batch, reassigning it only
      // if this visible row index less than lastUpdatedRow
      this.lastUpdatedRow = Math.min(this.lastUpdatedRow, visibleRowIndex);
      clearTimeout(this.timerId);
      this.timerId = setTimeout(function () {
        return _this2.resetGrid();
      }, 0);
    }
  }, {
    key: "getRowHeight",
    value: function getRowHeight(rowIndex) {
      var rowHeights = this.heightsCache.get(rowIndex);
      if (rowHeights == null) return 0;
      var rowHeightValues = Array.from(rowHeights.values());

      if (rowHeightValues.length) {
        return Math.max.apply(Math, _toConsumableArray(rowHeightValues));
      }

      return 0;
    }
  }, {
    key: "resetGrid",
    value: function resetGrid() {
      var _this$grid;

      (_this$grid = this.grid) === null || _this$grid === void 0 ? void 0 : _this$grid.resetAfterRowIndex(this.lastUpdatedRow);
      this.lastUpdatedRow = Infinity;
    }
  }, {
    key: "setGrid",
    value: function setGrid(grid) {
      this.grid = grid;
    }
  }, {
    key: "isAutoHeight",
    value: function isAutoHeight(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro;

      if ((rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : (_rowHeightsOptions$ro = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro === void 0 ? void 0 : _rowHeightsOptions$ro[rowIndex]) != null) {
        if (rowHeightsOptions.rowHeights[rowIndex] === AUTO_HEIGHT) {
          return true;
        }
      } else if ((rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight) === AUTO_HEIGHT) {
        return true;
      }

      return false;
    }
  }, {
    key: "isDefinedHeight",
    value: function isDefinedHeight(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro2;

      if (((_rowHeightsOptions$ro2 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro2 === void 0 ? void 0 : _rowHeightsOptions$ro2[rowIndex]) || rowHeightsOptions.defaultHeight) {
        return true;
      }

      return false;
    }
  }, {
    key: "computeStylesForGridCell",
    value: function computeStylesForGridCell(gridStyles, lineHeight) {
      this.fakeCell.className = "\n      euiDataGridRowCell\n      ".concat(cellPaddingsToClassMap[gridStyles.cellPadding], "\n      ").concat(fontSizesToClassMap[gridStyles.fontSize], "\n    "); // @ts-ignore it is valid to set `lineHeight` to undefined

      this.fakeCell.style.lineHeight = lineHeight;
      document.body.appendChild(this.fakeCell);
      var allStyles = getComputedStyle(this.fakeCell);
      this.styles = {
        paddingTop: getNumberFromPx(allStyles.paddingTop),
        paddingBottom: getNumberFromPx(allStyles.paddingBottom),
        lineHeight: getNumberFromPx(allStyles.lineHeight)
      };
      document.body.removeChild(this.fakeCell);
    }
  }, {
    key: "getComputedCellStyles",
    value: function getComputedCellStyles() {
      return this.styles;
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(lineCount) {
      return Math.ceil(lineCount * this.styles.lineHeight + this.styles.paddingTop + this.styles.paddingBottom);
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight, rowIndex) {
      if ((0, _predicate.isObject)(heightOption)) {
        if (heightOption.lineCount) {
          return this.calculateHeightForLineCount(heightOption.lineCount);
        }

        if (heightOption.height) {
          return Math.max(heightOption.height, defaultHeight);
        }
      }

      if (heightOption && (0, _predicate.isNumber)(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }

      if (heightOption === AUTO_HEIGHT && rowIndex) {
        return this.getRowHeight(rowIndex);
      }

      return defaultHeight;
    }
  }]);

  return RowHeightUtils;
}();

exports.RowHeightUtils = RowHeightUtils;