"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tooltip = void 0;
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importStar(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var color_library_wrappers_1 = require("../../common/color_library_wrappers");
var colors_1 = require("../../common/colors");
var mouse_1 = require("../../state/actions/mouse");
var get_chart_rotation_1 = require("../../state/selectors/get_chart_rotation");
var get_chart_theme_1 = require("../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
var get_internal_is_tooltip_visible_1 = require("../../state/selectors/get_internal_is_tooltip_visible");
var get_internal_tooltip_anchor_position_1 = require("../../state/selectors/get_internal_tooltip_anchor_position");
var get_internal_tooltip_info_1 = require("../../state/selectors/get_internal_tooltip_info");
var get_settings_specs_1 = require("../../state/selectors/get_settings_specs");
var get_tooltip_header_formatter_1 = require("../../state/selectors/get_tooltip_header_formatter");
var common_1 = require("../../utils/common");
var portal_1 = require("../portal");
var get_tooltip_settings_1 = require("./get_tooltip_settings");
var TooltipComponent = function (_a) {
    var info = _a.info, zIndex = _a.zIndex, headerFormatter = _a.headerFormatter, position = _a.position, getChartContainerRef = _a.getChartContainerRef, settings = _a.settings, visible = _a.visible, rotation = _a.rotation, chartId = _a.chartId, onPointerMove = _a.onPointerMove, backgroundColor = _a.backgroundColor;
    var chartRef = getChartContainerRef();
    var handleScroll = function () {
        onPointerMove({ x: -1, y: -1 }, Date.now());
    };
    (0, react_1.useEffect)(function () {
        window.addEventListener('scroll', handleScroll, true);
        return function () { return window.removeEventListener('scroll', handleScroll, true); };
    }, []);
    var renderHeader = (0, react_1.useCallback)(function (header) {
        if (!header || !header.isVisible) {
            return null;
        }
        return (react_1.default.createElement("div", { className: "echTooltip__header" }, headerFormatter ? headerFormatter(header) : header.formattedValue));
    }, [headerFormatter]);
    var renderValues = function (values) { return (react_1.default.createElement("div", { className: "echTooltip__list" }, values.map(function (_a, index) {
        var seriesIdentifier = _a.seriesIdentifier, valueAccessor = _a.valueAccessor, label = _a.label, markValue = _a.markValue, formattedValue = _a.formattedValue, formattedMarkValue = _a.formattedMarkValue, color = _a.color, isHighlighted = _a.isHighlighted, isVisible = _a.isVisible;
        if (!isVisible) {
            return null;
        }
        var classes = (0, classnames_1.default)('echTooltip__item', {
            echTooltip__rowHighlighted: isHighlighted,
        });
        var adjustedBGColor = (0, color_library_wrappers_1.colorToRgba)(color)[3] === 0 ? colors_1.Colors.Transparent.keyword : backgroundColor;
        return (react_1.default.createElement("div", { key: seriesIdentifier.key + "__" + valueAccessor + "__" + index, className: classes, style: {
                borderLeftColor: color,
            } },
            react_1.default.createElement("div", { className: "echTooltip__item--backgroundColor", style: { backgroundColor: adjustedBGColor } },
                react_1.default.createElement("div", { className: "echTooltip__item--color", style: { backgroundColor: color } })),
            react_1.default.createElement("div", { className: "echTooltip__item--container" },
                react_1.default.createElement("span", { className: "echTooltip__label" }, label),
                react_1.default.createElement("span", { className: "echTooltip__value" }, formattedValue),
                (0, common_1.isDefined)(markValue) && react_1.default.createElement("span", { className: "echTooltip__markValue" },
                    "\u00A0(",
                    formattedMarkValue,
                    ")"))));
    }))); };
    var renderTooltip = function () {
        if (!info || !visible) {
            return null;
        }
        if (typeof settings !== 'string' && (settings === null || settings === void 0 ? void 0 : settings.customTooltip)) {
            var CustomTooltip = settings.customTooltip;
            return react_1.default.createElement(CustomTooltip, __assign({}, info));
        }
        return (react_1.default.createElement("div", { className: "echTooltip" },
            renderHeader(info.header),
            renderValues(info.values)));
    };
    var popperSettings = (0, react_1.useMemo)(function () {
        var _a;
        if (!settings || typeof settings === 'string') {
            return;
        }
        var placement = settings.placement, fallbackPlacements = settings.fallbackPlacements, boundary = settings.boundary, rest = __rest(settings, ["placement", "fallbackPlacements", "boundary"]);
        return __assign(__assign({}, rest), { placement: placement !== null && placement !== void 0 ? placement : (rotation === 0 || rotation === 180 ? portal_1.Placement.Right : portal_1.Placement.Top), fallbackPlacements: fallbackPlacements !== null && fallbackPlacements !== void 0 ? fallbackPlacements : (rotation === 0 || rotation === 180
                ? [portal_1.Placement.Right, portal_1.Placement.Left, portal_1.Placement.Top, portal_1.Placement.Bottom]
                : [portal_1.Placement.Top, portal_1.Placement.Bottom, portal_1.Placement.Right, portal_1.Placement.Left]), boundary: boundary === 'chart' ? (_a = chartRef.current) !== null && _a !== void 0 ? _a : undefined : boundary });
    }, [settings, chartRef, rotation]);
    if (!visible) {
        return null;
    }
    return (react_1.default.createElement(portal_1.TooltipPortal, { scope: "MainTooltip", zIndex: zIndex + 100, anchor: {
            position: position,
            ref: chartRef.current,
        }, settings: popperSettings, chartId: chartId, visible: visible }, renderTooltip()));
};
TooltipComponent.displayName = 'Tooltip';
var HIDDEN_TOOLTIP_PROPS = {
    zIndex: 0,
    visible: false,
    info: undefined,
    position: null,
    headerFormatter: undefined,
    settings: {},
    rotation: 0,
    chartId: '',
    backgroundColor: colors_1.Colors.Transparent.keyword,
};
var mapDispatchToProps = function (dispatch) {
    return (0, redux_1.bindActionCreators)({ onPointerMove: mouse_1.onPointerMove }, dispatch);
};
var mapStateToProps = function (state) {
    if ((0, get_internal_is_intialized_1.getInternalIsInitializedSelector)(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return HIDDEN_TOOLTIP_PROPS;
    }
    var _a = (0, get_internal_is_tooltip_visible_1.getInternalIsTooltipVisibleSelector)(state), visible = _a.visible, isExternal = _a.isExternal;
    var settingsSpec = (0, get_settings_specs_1.getSettingsSpecSelector)(state);
    var settings = (0, get_tooltip_settings_1.getTooltipSettings)(settingsSpec, isExternal);
    return {
        visible: visible,
        zIndex: state.zIndex,
        info: (0, get_internal_tooltip_info_1.getInternalTooltipInfoSelector)(state),
        position: (0, get_internal_tooltip_anchor_position_1.getInternalTooltipAnchorPositionSelector)(state),
        headerFormatter: (0, get_tooltip_header_formatter_1.getTooltipHeaderFormatterSelector)(state),
        settings: settings,
        rotation: (0, get_chart_rotation_1.getChartRotationSelector)(state),
        chartId: state.chartId,
        backgroundColor: (0, get_chart_theme_1.getChartThemeSelector)(state).background.color,
    };
};
exports.Tooltip = (0, react_1.memo)((0, react_redux_1.connect)(mapStateToProps, mapDispatchToProps)(TooltipComponent));
//# sourceMappingURL=tooltip.js.map