"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVisibleTickSetsSelector = exports.enableDuplicatedTicks = void 0;
var scales_1 = require("../../../../scales");
var constants_1 = require("../../../../scales/constants");
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var axis_type_utils_1 = require("../../utils/axis_type_utils");
var axis_utils_1 = require("../../utils/axis_utils");
var panel_1 = require("../../utils/panel");
var scales_2 = require("../../utils/scales");
var compute_axis_ticks_dimensions_1 = require("./compute_axis_ticks_dimensions");
var compute_series_domains_1 = require("./compute_series_domains");
var compute_small_multiple_scales_1 = require("./compute_small_multiple_scales");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_bar_paddings_1 = require("./get_bar_paddings");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var adaptiveTickCount = true;
function axisMinMax(axisPosition, chartRotation, _a) {
    var width = _a.width, height = _a.height;
    var horizontal = (0, axis_type_utils_1.isHorizontalAxis)(axisPosition);
    var flipped = horizontal
        ? chartRotation === -90 || chartRotation === 180
        : chartRotation === 90 || chartRotation === 180;
    return horizontal ? [flipped ? width : 0, flipped ? 0 : width] : [flipped ? 0 : height, flipped ? height : 0];
}
function enableDuplicatedTicks(axisSpec, scale, offset, fallBackTickFormatter, tickFormatOptions) {
    var allTicks = scale.ticks().map(function (tick) {
        var _a, _b, _c;
        return ({
            value: tick,
            label: ((_a = axisSpec.tickFormat) !== null && _a !== void 0 ? _a : fallBackTickFormatter)(tick, tickFormatOptions),
            axisTickLabel: ((_c = (_b = axisSpec.labelFormat) !== null && _b !== void 0 ? _b : axisSpec.tickFormat) !== null && _c !== void 0 ? _c : fallBackTickFormatter)(tick, tickFormatOptions),
            position: (scale.scale(tick) || 0) + offset,
        });
    });
    return axisSpec.showDuplicatedTicks
        ? allTicks
        : allTicks.filter(function (d, i) { return i < 1 || allTicks[i - 1].axisTickLabel !== d.axisTickLabel; });
}
exports.enableDuplicatedTicks = enableDuplicatedTicks;
function getVisibleTicks(axisSpec, labelBox, totalBarsInCluster, fallBackTickFormatter, rotationOffset, scale, enableHistogramMode, tickFormatOptions) {
    var _a, _b;
    var ticks = scale.ticks();
    var isSingleValueScale = scale.domain[0] === scale.domain[1];
    var makeRaster = enableHistogramMode && scale.bandwidth > 0;
    var ultimateTick = ticks[ticks.length - 1];
    var penultimateTick = ticks[ticks.length - 2];
    if (makeRaster && !isSingleValueScale && typeof penultimateTick === 'number' && typeof ultimateTick === 'number') {
        var computedTickDistance = ultimateTick - penultimateTick;
        var numTicks = scale.minInterval / (computedTickDistance || scale.minInterval);
        for (var i = 1; i <= numTicks; i++)
            ticks.push(i * computedTickDistance + ultimateTick);
    }
    var shift = totalBarsInCluster > 0 ? totalBarsInCluster : 1;
    var band = scale.bandwidth / (1 - scale.barsPadding);
    var halfPadding = (band - scale.bandwidth) / 2;
    var offset = (enableHistogramMode ? -halfPadding : (scale.bandwidth * shift) / 2) + (scale.isSingleValue() ? 0 : rotationOffset);
    var tickFormatter = (_a = axisSpec.tickFormat) !== null && _a !== void 0 ? _a : fallBackTickFormatter;
    var labelFormatter = (_b = axisSpec.labelFormat) !== null && _b !== void 0 ? _b : tickFormatter;
    var firstTickValue = ticks[0];
    var allTicks = makeRaster && isSingleValueScale && typeof firstTickValue === 'number'
        ? [
            {
                value: firstTickValue,
                label: tickFormatter(firstTickValue, tickFormatOptions),
                axisTickLabel: labelFormatter(firstTickValue, tickFormatOptions),
                position: (scale.scale(firstTickValue) || 0) + offset,
            },
            {
                value: firstTickValue + scale.minInterval,
                label: tickFormatter(firstTickValue + scale.minInterval, tickFormatOptions),
                axisTickLabel: labelFormatter(firstTickValue + scale.minInterval, tickFormatOptions),
                position: scale.bandwidth + halfPadding * 2,
            },
        ]
        : enableDuplicatedTicks(axisSpec, scale, offset, fallBackTickFormatter, tickFormatOptions);
    var showOverlappingTicks = axisSpec.showOverlappingTicks, showOverlappingLabels = axisSpec.showOverlappingLabels, position = axisSpec.position;
    var requiredSpace = (0, axis_type_utils_1.isVerticalAxis)(position) ? labelBox.maxLabelBboxHeight / 2 : labelBox.maxLabelBboxWidth / 2;
    return showOverlappingLabels
        ? allTicks
        : __spreadArray([], __read(allTicks), false).sort(function (a, b) { return a.position - b.position; })
            .reduce(function (prev, tick) {
            var tickLabelFits = tick.position >= prev.occupiedSpace + requiredSpace;
            if (tickLabelFits || showOverlappingTicks) {
                prev.visibleTicks.push(tickLabelFits ? tick : __assign(__assign({}, tick), { axisTickLabel: '' }));
                if (tickLabelFits)
                    prev.occupiedSpace = tick.position + requiredSpace;
            }
            else if (adaptiveTickCount && !tickLabelFits && !showOverlappingTicks) {
                prev.visibleTicks.push(__assign(__assign({}, tick), { axisTickLabel: '' }));
            }
            return prev;
        }, { visibleTicks: [], occupiedSpace: -Infinity }).visibleTicks;
}
function getVisibleTickSet(scale, labelBox, _a, axisSpec, _b, groupCount, histogramMode, fallBackTickFormatter) {
    var chartRotation = _a.rotation;
    var timeZone = _b.xDomain.timeZone;
    var vertical = (0, axis_type_utils_1.isVerticalAxis)(axisSpec.position);
    var tickFormatter = vertical ? fallBackTickFormatter : axis_utils_1.defaultTickFormatter;
    var somehowRotated = (vertical && chartRotation === -90) || (!vertical && chartRotation === 180);
    var rotationOffset = histogramMode && somehowRotated ? scale.step : 0;
    var options = { timeZone: timeZone };
    return getVisibleTicks(axisSpec, labelBox, groupCount, tickFormatter, rotationOffset, scale, histogramMode, options);
}
exports.getVisibleTickSetsSelector = (0, create_selector_1.createCustomCachedSelector)([
    get_settings_specs_1.getSettingsSpecSelector,
    compute_axis_ticks_dimensions_1.getJoinedVisibleAxesData,
    compute_series_domains_1.computeSeriesDomainsSelector,
    compute_small_multiple_scales_1.computeSmallMultipleScalesSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    compute_axis_ticks_dimensions_1.getFallBackTickFormatter,
    get_bar_paddings_1.getBarPaddingsSelector,
], getVisibleTickSets);
function getVisibleTickSets(_a, joinedAxesData, _b, smScales, totalGroupsCount, enableHistogramMode, fallBackTickFormatter, barsPadding) {
    var chartRotation = _a.rotation;
    var xDomain = _b.xDomain, yDomains = _b.yDomains;
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)(function (textMeasure) {
        var panel = (0, panel_1.getPanelSize)(smScales);
        return __spreadArray([], __read(joinedAxesData), false).reduce(function (acc, _a) {
            var _b;
            var _c = __read(_a, 2), axisId = _c[0], _d = _c[1], axisSpec = _d.axisSpec, axesStyle = _d.axesStyle, gridLine = _d.gridLine, tickFormatter = _d.tickFormatter;
            var groupId = axisSpec.groupId, integersOnly = axisSpec.integersOnly, position = axisSpec.position;
            var isX = (0, axis_utils_1.isXDomain)(position, chartRotation);
            var yDomain = yDomains.find(function (yd) { return yd.groupId === groupId; });
            var maxTickCount = isX ? xDomain.desiredTickCount : (_b = yDomain === null || yDomain === void 0 ? void 0 : yDomain.desiredTickCount) !== null && _b !== void 0 ? _b : 0;
            var getScale = function (desiredTickCount) {
                var range = axisMinMax(axisSpec.position, chartRotation, panel);
                return isX
                    ? (0, scales_2.computeXScale)({
                        xDomain: __assign(__assign({}, xDomain), { desiredTickCount: desiredTickCount }),
                        totalBarsInCluster: totalGroupsCount,
                        range: range,
                        barsPadding: barsPadding,
                        enableHistogramMode: enableHistogramMode,
                        integersOnly: integersOnly,
                    })
                    : yDomain && new scales_1.ScaleContinuous(__assign(__assign({}, yDomain), { range: range }), __assign(__assign({}, yDomain), { desiredTickCount: desiredTickCount, integersOnly: integersOnly }));
            };
            var getMeasuredTicks = function (scale) {
                var labelBox = (0, compute_axis_ticks_dimensions_1.getLabelBox)(axesStyle, scale, tickFormatter, textMeasure, axisSpec, gridLine);
                return {
                    ticks: getVisibleTickSet(scale, labelBox, { rotation: chartRotation }, axisSpec, { xDomain: xDomain }, totalGroupsCount, enableHistogramMode, fallBackTickFormatter),
                    labelBox: labelBox,
                    scale: scale,
                };
            };
            var fallbackAskedTickCount = 2;
            var fallbackReceivedTickCount = Infinity;
            if (adaptiveTickCount) {
                var previousActualTickCount = NaN;
                for (var triedTickCount = maxTickCount; triedTickCount >= 2; triedTickCount--) {
                    var scale_1 = getScale(triedTickCount);
                    if (!scale_1 || scale_1.ticks().length === previousActualTickCount)
                        continue;
                    var raster = getMeasuredTicks(scale_1);
                    var nonZeroLengthTicks = raster.ticks.filter(function (tick) { return tick.axisTickLabel.length > 0; });
                    var uniqueLabels = new Set(raster.ticks.map(function (tick) { return tick.axisTickLabel; }));
                    var noDuplicates = raster.ticks.length === uniqueLabels.size;
                    var atLeastTwoTicks = uniqueLabels.size >= 2;
                    var allTicksFit = !uniqueLabels.has('');
                    var compliant = axisSpec &&
                        (scale_1.type === constants_1.ScaleType.Time || atLeastTwoTicks) &&
                        (scale_1.type === constants_1.ScaleType.Log || allTicksFit) &&
                        (scale_1.type === constants_1.ScaleType.Time ||
                            (scale_1.type === constants_1.ScaleType.Log
                                ? new Set(nonZeroLengthTicks.map(function (tick) { return tick.axisTickLabel; })).size === nonZeroLengthTicks.length
                                : noDuplicates));
                    previousActualTickCount = scale_1.ticks().length;
                    if (raster && compliant) {
                        return acc.set(axisId, __assign(__assign({}, raster), { ticks: scale_1.type === constants_1.ScaleType.Log ? raster.ticks : nonZeroLengthTicks }));
                    }
                    else if (atLeastTwoTicks && uniqueLabels.size <= fallbackReceivedTickCount) {
                        fallbackReceivedTickCount = uniqueLabels.size;
                        fallbackAskedTickCount = triedTickCount;
                    }
                }
            }
            var scale = getScale(adaptiveTickCount ? fallbackAskedTickCount : maxTickCount);
            var lastResortCandidate = scale && getMeasuredTicks(scale);
            return lastResortCandidate ? acc.set(axisId, lastResortCandidate) : acc;
        }, new Map());
    });
}
//# sourceMappingURL=visible_ticks.js.map