"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTickLabel = void 0;
var axis_utils_1 = require("../../../utils/axis_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderTickLabel(ctx, tick, showTicks, _a) {
    var _b;
    var position = _a.axisSpec.position, dimension = _a.dimension, size = _a.size, debug = _a.debug, axisStyle = _a.axisStyle;
    var labelStyle = axisStyle.tickLabel;
    var tickLabelProps = (0, axis_utils_1.getTickLabelPosition)(axisStyle, tick.position, position, labelStyle.rotation, size, dimension, showTicks, labelStyle.offset, labelStyle.alignment);
    var center = { x: tickLabelProps.x + tickLabelProps.offsetX, y: tickLabelProps.y + tickLabelProps.offsetY };
    if (debug) {
        var maxLabelBboxWidth = dimension.maxLabelBboxWidth, maxLabelBboxHeight = dimension.maxLabelBboxHeight, width = dimension.maxLabelTextWidth, height = dimension.maxLabelTextHeight;
        (0, debug_1.renderDebugRectCenterRotated)(ctx, center, __assign(__assign({}, center), { width: width, height: height }), undefined, undefined, labelStyle.rotation);
        if (labelStyle.rotation % 90 !== 0) {
            (0, debug_1.renderDebugRectCenterRotated)(ctx, center, __assign(__assign({}, center), { width: maxLabelBboxWidth, height: maxLabelBboxHeight }));
        }
    }
    (0, text_1.renderText)(ctx, center, tick.axisTickLabel, {
        fontFamily: labelStyle.fontFamily,
        fontStyle: (_b = labelStyle.fontStyle) !== null && _b !== void 0 ? _b : 'normal',
        fontVariant: 'normal',
        fontWeight: 'normal',
        textColor: labelStyle.fill,
        fontSize: labelStyle.fontSize,
        align: tickLabelProps.horizontalAlign,
        baseline: tickLabelProps.verticalAlign,
    }, labelStyle.rotation, tickLabelProps.textOffsetX, tickLabelProps.textOffsetY);
}
exports.renderTickLabel = renderTickLabel;
//# sourceMappingURL=tick_label.js.map