"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAreas = void 0;
var canvas_1 = require("../../../../renderers/canvas");
var utils_1 = require("../../rendering/utils");
var points_1 = require("./points");
var path_1 = require("./primitives/path");
var area_1 = require("./styles/area");
var line_1 = require("./styles/line");
var panel_transform_1 = require("./utils/panel_transform");
function renderAreas(ctx, imgCanvas, props) {
    var sharedStyle = props.sharedStyle, highlightedLegendItem = props.highlightedLegendItem, areas = props.areas, rotation = props.rotation, clippings = props.clippings, renderingArea = props.renderingArea;
    (0, canvas_1.withContext)(ctx, function () {
        areas.forEach(function (_a) {
            var panel = _a.panel, area = _a.value;
            var seriesAreaLineStyle = area.seriesAreaLineStyle, seriesAreaStyle = area.seriesAreaStyle;
            if (seriesAreaStyle.visible) {
                (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, function () { return renderArea(ctx, imgCanvas, area, sharedStyle, clippings, highlightedLegendItem); }, { area: clippings, shouldClip: true });
            }
            if (seriesAreaLineStyle.visible) {
                (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, function () { return renderAreaLines(ctx, area, sharedStyle, clippings, highlightedLegendItem); }, { area: clippings, shouldClip: true });
            }
        });
        areas.forEach(function (_a) {
            var _b;
            var panel = _a.panel, area = _a.value;
            var seriesPointStyle = area.seriesPointStyle, seriesIdentifier = area.seriesIdentifier, points = area.points;
            var visiblePoints = seriesPointStyle.visible ? points : points.filter(function (_a) {
                var orphan = _a.orphan;
                return orphan;
            });
            if (visiblePoints.length === 0) {
                return;
            }
            var geometryStateStyle = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
            (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, function () { return (0, points_1.renderPoints)(ctx, visiblePoints, geometryStateStyle); }, { area: clippings, shouldClip: ((_b = points[0]) === null || _b === void 0 ? void 0 : _b.value.mark) !== null });
        });
    });
}
exports.renderAreas = renderAreas;
function renderArea(ctx, imgCanvas, glyph, sharedStyle, clippings, highlightedLegendItem) {
    var area = glyph.area, color = glyph.color, transform = glyph.transform, seriesIdentifier = glyph.seriesIdentifier, seriesAreaStyle = glyph.seriesAreaStyle, clippedRanges = glyph.clippedRanges, hideClippedRanges = glyph.hideClippedRanges;
    var geometryStateStyle = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
    var styles = (0, area_1.buildAreaStyles)(ctx, imgCanvas, color, seriesAreaStyle, geometryStateStyle);
    (0, path_1.renderAreaPath)(ctx, transform, area, styles, clippedRanges, clippings, hideClippedRanges);
}
function renderAreaLines(ctx, glyph, sharedStyle, clippings, highlightedLegendItem) {
    var lines = glyph.lines, color = glyph.color, seriesIdentifier = glyph.seriesIdentifier, transform = glyph.transform, seriesAreaLineStyle = glyph.seriesAreaLineStyle, clippedRanges = glyph.clippedRanges, hideClippedRanges = glyph.hideClippedRanges;
    var geometryStateStyle = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
    var styles = (0, line_1.buildLineStyles)(color, seriesAreaLineStyle, geometryStateStyle);
    (0, path_1.renderLinePaths)(ctx, transform, lines, styles, clippedRanges, clippings, hideClippedRanges);
}
//# sourceMappingURL=areas.js.map