"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHeatmapTableSelector = void 0;
var predicate_1 = require("../../../../common/predicate");
var constants_1 = require("../../../../scales/constants");
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var accessor_1 = require("../../../../utils/accessor");
var x_domain_1 = require("../../../xy_chart/domains/x_domain");
var get_api_scales_1 = require("../../../xy_chart/scales/get_api_scales");
var scale_defaults_1 = require("../../specs/scale_defaults");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
exports.getHeatmapTableSelector = (0, create_selector_1.createCustomCachedSelector)([get_heatmap_spec_1.getHeatmapSpecSelector, get_settings_specs_1.getSettingsSpecSelector], function (spec, settingsSpec) {
    var data = spec.data, valueAccessor = spec.valueAccessor, xAccessor = spec.xAccessor, yAccessor = spec.yAccessor, xSortPredicate = spec.xSortPredicate, ySortPredicate = spec.ySortPredicate;
    var xDomain = settingsSpec.xDomain;
    var resultData = data.reduce(function (acc, curr, index) {
        var x = (0, accessor_1.getAccessorValue)(curr, xAccessor);
        var y = (0, accessor_1.getAccessorValue)(curr, yAccessor);
        var value = (0, accessor_1.getAccessorValue)(curr, valueAccessor);
        var _a = __read(acc.extent, 2), min = _a[0], max = _a[1];
        acc.extent = [Math.min(min, value), Math.max(max, value)];
        acc.table.push({
            x: x,
            y: y,
            value: value,
            originalIndex: index,
        });
        if (!acc.xValues.includes(x)) {
            acc.xValues.push(x);
        }
        if (!acc.yValues.includes(y)) {
            acc.yValues.push(y);
        }
        return acc;
    }, {
        table: [],
        xValues: [],
        yValues: [],
        extent: [+Infinity, -Infinity],
    });
    resultData.xDomain = (0, x_domain_1.mergeXDomain)({
        type: (0, get_api_scales_1.getXScaleTypeFromSpec)(spec.xScaleType),
        nice: (0, get_api_scales_1.getXNiceFromSpec)(),
        isBandScale: false,
        desiredTickCount: scale_defaults_1.X_SCALE_DEFAULT.desiredTickCount,
        customDomain: xDomain,
    }, resultData.xValues);
    if (spec.xScaleType === constants_1.ScaleType.Ordinal) {
        resultData.xDomain.domain.sort((0, predicate_1.getPredicateFn)(xSortPredicate));
    }
    resultData.yValues.sort((0, predicate_1.getPredicateFn)(ySortPredicate));
    return resultData;
});
//# sourceMappingURL=get_heatmap_table.js.map