"use strict";

exports.__esModule = true;
exports.registerServices = registerServices;

var _errorLogging = _interopRequireDefault(require("./error-logging"));

var _constants = require("../common/constants");

var _serviceFactory = require("../common/service-factory");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function registerServices() {
  _serviceFactory.serviceCreators['ErrorLogging'] = function (serviceFactory) {
    var _serviceFactory$getSe = serviceFactory.getService([_constants.APM_SERVER, _constants.CONFIG_SERVICE, 'TransactionService']),
        apmServer = _serviceFactory$getSe[0],
        configService = _serviceFactory$getSe[1],
        transactionService = _serviceFactory$getSe[2];

    return new _errorLogging.default(apmServer, configService, transactionService);
  };
}