/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.IOException;
import java.io.OutputStream;

public class KanjiEscapeOutputStream
extends OutputStream {
    protected OutputStream parent;
    private final int MASK = 255;
    private boolean state = true;

    public KanjiEscapeOutputStream(OutputStream out) {
        this.parent = out;
    }

    @Override
    public void write(int b) throws IOException {
        b &= 0xFF;
        if (this.state) {
            if (0 <= b && b <= 127) {
                this.parent.write(b);
            } else {
                this.octprint(b);
                if (129 <= b && b <= 159 || 224 <= b && b <= 252) {
                    this.state = false;
                }
            }
        } else {
            if (64 <= b && b <= 126 || 128 <= b && b <= 252) {
                this.octprint(b);
            } else if (0 <= b && b <= 127) {
                this.parent.write(b);
            } else {
                this.octprint(b);
            }
            this.state = true;
        }
    }

    private void octprint(int b) throws IOException {
        String oct = "\\" + String.format("%o", b & 0xFF);
        for (int i = 0; i < oct.length(); ++i) {
            char bb = oct.charAt(i);
            this.parent.write(bb);
        }
    }
}

