/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public class BasicImageSupport {
    @NotNull
    private static final ColorModel colorModel = BasicImageSupport.createColorModel();

    @NotNull
    public static ColorModel getColorModel() {
        return colorModel;
    }

    @NotNull
    public static BufferedImage createImage(@NotNull int[] nArray, int n, int n2) {
        return BasicImageSupport.createImage(nArray, n, n2, n);
    }

    @NotNull
    public static BufferedImage createImage(@NotNull int[] nArray, int n, int n2, int n3) {
        return BasicImageSupport.createBufferedImage(colorModel, nArray, n, n2, n3);
    }

    @NotNull
    private static ColorModel createColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    }

    @NotNull
    private static BufferedImage createBufferedImage(@NotNull ColorModel colorModel, @NotNull int[] nArray, int n, int n2, int n3) {
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        int[] nArray2 = new int[]{0xFF0000, 65280, 255, -16777216};
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n3, nArray2, null);
        return new BufferedImage(colorModel, writableRaster, true, null);
    }
}

