/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarLayoutConfiguration;

public class ScrollBarThumbLayoutConfiguration
extends ScrollBarLayoutConfiguration {
    private final int value;
    private final float thumbExtent;

    public ScrollBarThumbLayoutConfiguration(@NotNull ScrollBarConfiguration scrollBarConfiguration, int n) {
        super(scrollBarConfiguration);
        this.value = n;
        this.thumbExtent = scrollBarConfiguration.getThumbExtent();
    }

    public ScrollBarThumbLayoutConfiguration(@NotNull AquaUIPainter.ScrollBarWidget scrollBarWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.Orientation orientation, float f, int n) {
        super(scrollBarWidget, size, orientation);
        this.value = n;
        this.thumbExtent = f;
    }

    public int getValue() {
        return this.value;
    }

    public float getThumbExtent() {
        return this.thumbExtent;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration = (ScrollBarThumbLayoutConfiguration)object;
        return this.value == scrollBarThumbLayoutConfiguration.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + " " + this.value;
    }
}

