/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.fc.BasicBrowserUI;
import org.violetlib.aqua.fc.BrowserCellRenderer;
import org.violetlib.aqua.fc.BrowserPreviewRenderer;
import org.violetlib.aqua.fc.BrowserUI;
import org.violetlib.aqua.fc.DefaultColumnCellRenderer;

public class JBrowser
extends JComponent
implements Scrollable {
    private static final String uiClassID = "BrowserUI";
    private TreePath expandedPath;
    private boolean expandedPathIsLeaf;
    private int fixedCellWidth = 175;
    private int columnMinimumWidth = 150;
    private int columnMinimumHeight = 100;
    private TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    private transient SelectionModeUpdater selectionModeUpdater = new SelectionModeUpdater();
    private transient TreeSelectionUpdater treeSelectionUpdater = new TreeSelectionUpdater();
    private TreeRootHandler treeRootHandler = new TreeRootHandler();
    private transient ColumnMouseListener columnMouseListener = new ColumnMouseListener();
    private transient ColumnKeyListener columnKeyListener = new ColumnKeyListener();
    private ListCellRenderer cellRenderer;
    private PreviewColumn previewColumn;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String PREVIEW_RENDERER_PROPERTY = "previewRenderer";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String FIXED_CELL_WIDTH_PROPERTY = "fixedCellWidth";
    public static final String COLUMN_MINIMUM_WIDTH = "columnMinimumWidth";
    public static final String COLUMN_MINIMUM_HEIGHT = "columnMinimumHeight";
    public static final String COLUMNS_RESIZABLE_PROPERTY = "columnsResizable";
    private Object prototypeCellValue;
    private boolean isShowCellTips;
    private Point cellTipOrigin = new Point(0, 1);
    private boolean dragEnabled;
    private boolean columnsResizable = true;
    private boolean shouldFillPreviewColumn = false;
    private boolean isPreviewColumnScrollable = false;
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public JBrowser() {
        this(JBrowser.getDefaultTreeModel());
    }

    public JBrowser(Object[] objectArray) {
        this(JBrowser.createTreeModel(objectArray));
        this.expandRoot();
    }

    public JBrowser(Vector vector) {
        this(JBrowser.createTreeModel(vector));
        this.expandRoot();
    }

    public JBrowser(Hashtable hashtable) {
        this(JBrowser.createTreeModel(hashtable));
        this.expandRoot();
    }

    public JBrowser(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JBrowser(TreeNode treeNode, boolean bl) {
        this(new DefaultTreeModel(treeNode, bl));
    }

    public JBrowser(TreeModel treeModel) {
        this.initComponents();
        this.selectionModel = new DefaultTreeSelectionModel();
        this.selectionModel.setSelectionMode(1);
        this.selectionModel.addPropertyChangeListener(this.selectionModeUpdater);
        this.selectionModel.addTreeSelectionListener(this.treeSelectionUpdater);
        this.setOpaque(true);
        this.updateUI();
        this.setModel(treeModel);
        this.setFocusable(false);
    }

    @Override
    public BrowserUI getUI() {
        return (BrowserUI)this.ui;
    }

    public void setUI(BrowserUI browserUI) {
        super.setUI(browserUI);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BrowserUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBrowserUI());
        }
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setPrototypeCellValue(Object object) {
        this.prototypeCellValue = object;
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl;
        int n = this.getListColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getColumnList(i).setDragEnabled(bl);
        }
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        super.setTransferHandler(transferHandler);
        int n = this.getListColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getColumnList(i).setTransferHandler(transferHandler);
        }
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JBrowser");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    protected static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            defaultMutableTreeNode = new JTree.DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    private void expandRoot() {
        this.selectionModel.clearSelection();
        this.expandPath(new TreePath(this.treeModel.getRoot()));
    }

    @Nullable
    public TreePath getClosestPathForLocation(int n, int n2) {
        for (Component component = this.getComponentAt(n, n2); component != null; component = component.getComponentAt(n, n2)) {
            n -= component.getX();
            n2 -= component.getY();
            if (!(component instanceof JList)) continue;
            JList jList = (JList)component;
            ColumnListModel columnListModel = (ColumnListModel)jList.getModel();
            int n3 = jList.locationToIndex(new Point(n, n2));
            if (n3 != -1) {
                return columnListModel.path.pathByAddingChild(columnListModel.getElementAt(n3));
            }
            return null;
        }
        return null;
    }

    @Nullable
    public Rectangle getPathBounds(TreePath treePath) {
        if (treePath.getPathCount() <= this.getListColumnCount()) {
            JList jList = this.getColumnList(treePath.getPathCount() - 1);
            int n = treePath.getPathCount() > 1 ? this.treeModel.getIndexOfChild(treePath.getPathComponent(treePath.getPathCount() - 2), treePath.getLastPathComponent()) : this.treeModel.getIndexOfChild(null, treePath.getLastPathComponent());
            Rectangle rectangle = jList.getCellBounds(n, n);
            rectangle.x += jList.getLocation().x + jList.getParent().getLocation().x + jList.getParent().getParent().getLocation().x;
            rectangle.y += jList.getLocation().y + jList.getParent().getLocation().y + jList.getParent().getParent().getLocation().y;
            return rectangle;
        }
        return null;
    }

    public void setShowCellTips(boolean bl) {
        boolean bl2 = this.isShowCellTips;
        if (bl2 != bl) {
            this.isShowCellTips = bl;
            String string = bl ? "cell tip" : null;
            int n = this.getListColumnCount();
            for (int i = 0; i < n; ++i) {
                this.getColumnList(i).setToolTipText(string);
            }
            this.firePropertyChange("showCellTips", bl2, bl);
        }
    }

    public boolean isShowCellTips() {
        return this.isShowCellTips;
    }

    public void setShowCellTipOrigin(Point point) {
        Point point2 = this.cellTipOrigin;
        this.cellTipOrigin = point == null ? new Point(0, 0) : (Point)point.clone();
        this.firePropertyChange("cellTipOrigin", point2, point);
    }

    public Point getCellTipOrigin() {
        return (Point)this.cellTipOrigin.clone();
    }

    public boolean isPathSelected(TreePath treePath) {
        TreePath[] treePathArray = this.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!treePathArray[i].equals(treePath)) continue;
            return true;
        }
        return false;
    }

    public void addSelectionPath(TreePath treePath) {
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            int n;
            JList jList = this.getColumnList(i);
            if (jList.isSelectedIndex(n = this.treeModel.getIndexOfChild(i == 0 ? null : treePath.getPathComponent(i - 1), treePath.getPathComponent(i)))) continue;
            if (i < treePath.getPathCount() - 1) {
                jList.setSelectionInterval(n, n);
                continue;
            }
            jList.addSelectionInterval(n, n);
        }
    }

    public void ensurePathIsVisible(TreePath treePath) {
        TreePath treePath2 = this.selectionModel.getSelectionPath();
        if (treePath2 != null && (treePath.isDescendant(treePath2) || treePath2.isDescendant(treePath))) {
            if (!this.isValid()) {
                this.setSize(this.getPreferredSize());
                this.doLayout();
            }
            for (int i = 0; i < treePath.getPathCount() - 1 && i < this.getListColumnCount(); ++i) {
                JList jList = this.getColumnList(i);
                int n = this.findListElement(jList, treePath.getPathComponent(i + 1));
                Rectangle rectangle = jList.getCellBounds(n, n);
                if (n == -1 || rectangle == null) continue;
                rectangle.height += 20;
                jList.scrollRectToVisible(rectangle);
            }
            Component component = this.getComponent(this.getColumnCount() - 1);
            if (component != null && component.getBounds() != null) {
                this.scrollRectToVisible(component.getBounds());
            }
        }
    }

    private int findListElement(@NotNull JList jList, Object object) {
        ListModel listModel = jList.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!listModel.getElementAt(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectionPath(TreePath treePath) {
        this.selectionModel.setSelectionPath(treePath);
    }

    public void removeSelectionPath(TreePath treePath) {
        if (treePath.getPathCount() <= this.getListColumnCount()) {
            JList jList = this.getColumnList(treePath.getPathCount() - 1);
            int n = this.treeModel.getIndexOfChild(treePath.getPathComponent(treePath.getPathCount() - 2), treePath.getLastPathComponent());
            jList.removeSelectionInterval(n, n);
        }
    }

    public TreePath getPathForLocation(int n, int n2) {
        return this.getClosestPathForLocation(n, n2);
    }

    public void clearSelection() {
        this.setSelectionPath(new TreePath(this.treeModel.getRoot()));
    }

    public void setFixedCellWidth(int n) {
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setFixedCellWidth(n);
        }
        this.revalidate();
        this.repaint();
        this.firePropertyChange(FIXED_CELL_WIDTH_PROPERTY, n2, this.fixedCellWidth);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setColumnMinimumWidth(int n) {
        if (n != this.columnMinimumWidth) {
            int n2 = this.columnMinimumWidth;
            this.columnMinimumWidth = n;
            this.revalidate();
            this.repaint();
            this.firePropertyChange(COLUMN_MINIMUM_WIDTH, n2, n);
        }
    }

    public int getColumnMinimumWidth() {
        return this.columnMinimumWidth;
    }

    public void setColumnMinimumHeight(int n) {
        if (n != this.columnMinimumHeight) {
            int n2 = this.columnMinimumHeight;
            this.columnMinimumHeight = n;
            this.revalidate();
            this.repaint();
            this.firePropertyChange(COLUMN_MINIMUM_HEIGHT, n2, n);
        }
    }

    public int getColumnMinimumHeight() {
        return this.columnMinimumHeight;
    }

    public void setColumnWidth(int n, int n2) {
        ListColumn listColumn = this.getListColumn(n);
        if (listColumn != null) {
            listColumn.setFixedCellWidth(n2);
        }
    }

    public int getColumnWidth(int n) {
        ListColumn listColumn = this.getListColumn(n);
        if (listColumn != null) {
            return listColumn.getFixedCellWidth();
        }
        return 0;
    }

    public int getColumnPreferredWidth(int n) {
        ListColumn listColumn = this.getListColumn(n);
        if (listColumn != null) {
            return listColumn.getColumnPreferredWidth();
        }
        return 0;
    }

    public void setPreviewColumnWidth(int n) {
        if (this.previewColumn != null) {
            this.previewColumn.setDesignatedWidth(n);
        }
    }

    public int getPreviewColumnWidth() {
        if (this.previewColumn == null) {
            return this.getFixedCellWidth();
        }
        return this.previewColumn.getPreferredSize().width;
    }

    public boolean isPreviewColumnFilled() {
        return this.shouldFillPreviewColumn;
    }

    public void setPreviewColumnFilled(boolean bl) {
        boolean bl2 = this.shouldFillPreviewColumn;
        this.shouldFillPreviewColumn = bl;
        if (bl2 != bl) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isPreviewColumnScrollable() {
        return this.isPreviewColumnScrollable;
    }

    public void setPreviewColumnScrollable(boolean bl) {
        boolean bl2 = this.isPreviewColumnScrollable;
        this.isPreviewColumnScrollable = bl;
        if (bl2 != bl) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setColumnsResizable(boolean bl) {
        boolean bl2 = this.columnsResizable;
        this.columnsResizable = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof Column)) continue;
            Column column = (Column)component;
            column.setResizable(bl);
        }
        this.firePropertyChange(COLUMNS_RESIZABLE_PROPERTY, bl2, bl);
    }

    public boolean isColumnsResizable() {
        return this.columnsResizable;
    }

    public void setColumnCellRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setCellRenderer(listCellRenderer);
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, listCellRenderer2, listCellRenderer);
    }

    public ListCellRenderer getColumnCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(BrowserCellRenderer browserCellRenderer) {
        BrowserCellRenderer browserCellRenderer2 = this.getCellRenderer();
        if (browserCellRenderer != null) {
            this.setColumnCellRenderer(new BrowserCellRendererWrapper(browserCellRenderer));
        } else {
            this.setColumnCellRenderer(new DefaultColumnCellRenderer(this));
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, browserCellRenderer2, browserCellRenderer);
    }

    public BrowserCellRenderer getCellRenderer() {
        return this.cellRenderer instanceof BrowserCellRendererWrapper ? ((BrowserCellRendererWrapper)this.cellRenderer).browserCellRenderer : null;
    }

    public void setPreviewRenderer(BrowserPreviewRenderer browserPreviewRenderer) {
        BrowserPreviewRenderer browserPreviewRenderer2 = null;
        if (browserPreviewRenderer == null) {
            if (this.previewColumn != null) {
                browserPreviewRenderer2 = this.previewColumn.getRenderer();
                this.repaint(this.previewColumn.getBounds());
                this.remove(this.previewColumn);
                this.previewColumn = null;
            }
        } else if (this.previewColumn == null) {
            this.previewColumn = new PreviewColumn(browserPreviewRenderer);
            if (this.getDropTarget() != null) {
                new DropTarget(this.previewColumn, this.getDropTarget().getDefaultActions(), this.getDropTarget());
            }
        } else {
            browserPreviewRenderer2 = this.previewColumn.getRenderer();
            this.previewColumn.setRenderer(browserPreviewRenderer);
        }
        this.firePropertyChange(PREVIEW_RENDERER_PROPERTY, browserPreviewRenderer2, browserPreviewRenderer);
    }

    private int getColumnCount() {
        return this.getComponentCount();
    }

    private int getListColumnCount() {
        int n = this.getComponentCount();
        if (this.previewColumn != null && this.previewColumn.getParent() == this) {
            return n - 1;
        }
        return n;
    }

    @Override
    public void setDropTarget(DropTarget dropTarget) {
        super.setDropTarget(dropTarget);
        if (dropTarget != null) {
            int n = this.getListColumnCount();
            for (int i = 0; i < n; ++i) {
                new DropTarget(this.getColumnList(i), this.getDropTarget().getDefaultActions(), this.getDropTarget());
            }
        }
        if (this.previewColumn != null) {
            new DropTarget(this.previewColumn, this.getDropTarget().getDefaultActions(), this.getDropTarget());
        }
    }

    private Column getColumn(int n) {
        return (Column)this.getComponent(n);
    }

    @Nullable
    private ListColumn getListColumn(int n) {
        Component component = this.getComponent(n);
        if (component instanceof ListColumn) {
            return (ListColumn)component;
        }
        return null;
    }

    @NotNull
    private JList getColumnList(int n) {
        ListColumn listColumn = this.getListColumn(n);
        if (listColumn != null) {
            return listColumn.getList();
        }
        throw new IllegalArgumentException("Invalid list column index: " + n);
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this.treeSelectionUpdater);
            this.selectionModel.removePropertyChangeListener(this.selectionModeUpdater);
        }
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            treeSelectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = treeSelectionModel;
        if (treeSelectionModel != null) {
            this.selectionModel.addTreeSelectionListener(this.treeSelectionUpdater);
            this.selectionModel.addPropertyChangeListener(this.selectionModeUpdater);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, this.selectionModel);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionMode(int n) {
        this.selectionModel.setSelectionMode(n);
    }

    public TreePath getSelectionPath() {
        if (this.getListColumnCount() == 0) {
            return null;
        }
        JList jList = this.getColumnList(this.getListColumnCount() - 1);
        ColumnListModel columnListModel = (ColumnListModel)jList.getModel();
        int n = jList.getSelectedIndex();
        Object var4_4 = n == -1 || n >= columnListModel.getSize() ? null : jList.getSelectedValue();
        return var4_4 == null ? columnListModel.path : columnListModel.path.pathByAddingChild(var4_4);
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])this.getListeners(KeyListener.class);
    }

    public void updatePreviewColumn() {
        if (this.previewColumn != null) {
            boolean bl;
            boolean bl2 = this.previewColumn.getParent() != null;
            TreePath[] treePathArray = this.getSelectionPaths();
            switch (treePathArray == null ? 0 : treePathArray.length) {
                case 0: {
                    this.remove(this.previewColumn);
                    break;
                }
                case 1: {
                    if (this.treeModel.isLeaf(treePathArray[0].getLastPathComponent())) {
                        this.previewColumn.updateSelection(treePathArray);
                        this.add(this.previewColumn);
                        break;
                    }
                    this.remove(this.previewColumn);
                    break;
                }
                default: {
                    this.previewColumn.updateSelection(treePathArray);
                    this.add(this.previewColumn);
                }
            }
            boolean bl3 = bl = this.previewColumn.getParent() != null;
            if (bl != bl2) {
                this.previewColumnVisibilityChanged(bl);
            }
            this.revalidate();
            this.repaint();
        }
    }

    protected void previewColumnVisibilityChanged(boolean bl) {
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(TreeSelectionListener.class, treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(TreeSelectionListener.class, treeSelectionListener);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)objectArray[i + 1]).valueChanged(treeSelectionEvent);
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.treeModel;
        if (treeModel2 != null) {
            treeModel2.removeTreeModelListener(this.treeRootHandler);
        }
        this.treeModel = treeModel;
        if (treeModel != null) {
            treeModel.addTreeModelListener(this.treeRootHandler);
        }
        for (int i = this.getListColumnCount() - 1; i >= 0; --i) {
            this.removeLastListColumn();
        }
        if (this.treeModel != null) {
            this.expandedPath = null;
            this.expandRoot();
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, this.treeModel);
    }

    private void expandPath(TreePath treePath) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = treePath == null || this.treeModel.isLeaf(treePath.getLastPathComponent());
        int n3 = this.expandedPath == null ? 0 : (n2 = this.expandedPath.getPathCount() - (this.expandedPathIsLeaf ? 1 : 0));
        int n4 = treePath == null ? 0 : (n = treePath.getPathCount() - (bl ? 1 : 0));
        if (this.expandedPath == null || !this.expandedPath.equals(treePath) || this.expandedPathIsLeaf != bl) {
            Serializable serializable;
            int n5;
            if (n2 == n) {
                TreePath treePath2 = null;
                for (n5 = 0; n5 < n; ++n5) {
                    treePath2 = treePath2 == null ? new TreePath(treePath.getPathComponent(0)) : treePath2.pathByAddingChild(treePath.getPathComponent(n5));
                    JList jList = this.getColumnList(n5);
                    serializable = (ColumnListModel)jList.getModel();
                    ((ColumnListModel)serializable).setPath(treePath2);
                }
            } else {
                for (int i = this.getListColumnCount() - 1; i >= n; --i) {
                    if (this.getColumnList(i).isFocusOwner()) {
                        this.removeListColumn(i > 0 ? i - 1 : i);
                        continue;
                    }
                    this.removeListColumn(i);
                }
                if (treePath != null) {
                    TreePath treePath3 = null;
                    int n6 = this.getListColumnCount();
                    for (n5 = 0; n5 < n6; ++n5) {
                        treePath3 = treePath3 == null ? new TreePath(treePath.getPathComponent(0)) : treePath3.pathByAddingChild(treePath.getPathComponent(n5));
                        serializable = this.getColumnList(n5);
                        ColumnListModel columnListModel = (ColumnListModel)((JList)serializable).getModel();
                        columnListModel.setPath(treePath3);
                    }
                }
                if (treePath != null) {
                    List<Object> list = Arrays.asList(treePath.getPath());
                    for (n5 = this.getListColumnCount(); n5 < n; ++n5) {
                        this.addColumn(new TreePath(list.subList(0, n5 + 1).toArray()));
                    }
                }
                if (n > 0) {
                    this.revalidate();
                }
                this.repaint();
            }
            this.expandedPath = treePath;
            this.expandedPathIsLeaf = bl;
            if (treePath != null) {
                for (int i = 0; i < treePath.getPathCount() - 1; ++i) {
                    this.getColumnList(i).setSelectedIndex(this.treeModel.getIndexOfChild(treePath.getPathComponent(i), treePath.getPathComponent(i + 1)));
                }
            }
        }
    }

    protected void addColumn(@NotNull TreePath treePath) {
        int n;
        JList jList = this.createColumnList(new ColumnListModel(treePath, this.treeModel));
        if (this.isShowCellTips) {
            jList.setToolTipText("cell tip");
        }
        if (this.getDropTarget() != null) {
            new DropTarget(jList, this.getDropTarget().getDefaultActions(), this.getDropTarget());
        }
        if (this.cellRenderer != null) {
            jList.setCellRenderer(this.cellRenderer);
        }
        if (this.prototypeCellValue != null) {
            jList.setPrototypeCellValue(this.prototypeCellValue);
        }
        jList.setSelectionModel(new ColumnSelectionModel());
        switch (this.selectionModel.getSelectionMode()) {
            case 2: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        jList.setSelectionMode(n);
        jList.addMouseListener(this.columnMouseListener);
        jList.addKeyListener(this.columnKeyListener);
        jList.setFixedCellWidth(this.fixedCellWidth);
        jList.setDragEnabled(this.getDragEnabled());
        jList.setTransferHandler(this.getTransferHandler());
        ListColumn listColumn = new ListColumn(jList, treePath.getPathCount() - 1);
        this.add((Component)listColumn, this.getListColumnCount());
    }

    @NotNull
    protected JList createColumnList(@NotNull ColumnListModel columnListModel) {
        return new ColumnList(columnListModel);
    }

    protected void removeLastListColumn() {
        this.removeListColumn(this.getListColumnCount() - 1);
    }

    protected void removeListColumn(int n) {
        JList jList = this.getColumnList(n);
        Column column = (Column)this.getComponent(n);
        column.remove(jList);
        this.remove(column);
        jList.removeMouseListener(this.columnMouseListener);
        jList.removeKeyListener(this.columnKeyListener);
        ((ColumnListModel)jList.getModel()).dispose();
    }

    private void initComponents() {
        this.setLayout(new BrowserLayout());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = new Dimension();
        if (this.getComponentCount() == 0) {
            JScrollPane jScrollPane = new JScrollPane();
            JList<Object> jList = new JList<Object>();
            jList.setPrototypeCellValue(this.prototypeCellValue);
            jScrollPane.setViewportView(jList);
            dimension.setSize(jScrollPane.getPreferredSize());
            dimension.width *= 2;
        } else {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Dimension dimension2 = this.getComponent(i).getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width += dimension2.width;
            }
        }
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        block11: {
            Component[] componentArray;
            block10: {
                componentArray = this.getComponents();
                n3 = 0;
                if (n2 <= 0) break block10;
                switch (n) {
                    case 0: {
                        for (int i = componentArray.length - 1; i >= 0; --i) {
                            Rectangle rectangle2 = componentArray[i].getBounds();
                            if (rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) continue;
                            n3 = Math.min(10, rectangle2.x + rectangle2.width - rectangle.x - rectangle.width);
                        }
                        break block11;
                    }
                    case 1: {
                        n3 = 10;
                    }
                }
                break block11;
            }
            switch (n) {
                case 0: {
                    for (int i = 0; i < componentArray.length; ++i) {
                        Rectangle rectangle3 = componentArray[i].getBounds();
                        if (rectangle3.x >= rectangle.x) continue;
                        n3 = Math.min(10, rectangle.x - rectangle3.x);
                    }
                    break;
                }
                case 1: {
                    n3 = 10;
                }
            }
        }
        return n3;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        block12: {
            Component[] componentArray;
            block11: {
                componentArray = this.getComponents();
                n3 = 0;
                if (n2 <= 0) break block11;
                switch (n) {
                    case 0: {
                        for (int i = componentArray.length - 1; i >= 0; --i) {
                            Rectangle rectangle2 = componentArray[i].getBounds();
                            if (rectangle2.x > rectangle.x) {
                                n3 = rectangle2.x - rectangle.x;
                                continue;
                            }
                            if (rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) continue;
                            n3 = rectangle2.x - rectangle.x;
                        }
                        break block12;
                    }
                    case 1: {
                        n3 = 10;
                    }
                }
                break block12;
            }
            switch (n) {
                case 0: {
                    for (int i = 0; i < componentArray.length; ++i) {
                        Rectangle rectangle3 = componentArray[i].getBounds();
                        if (rectangle3.x + rectangle3.width >= rectangle.x) continue;
                        n3 = rectangle.x - rectangle3.x;
                    }
                    if (n3 != 0) break;
                    n3 = rectangle.x - componentArray[0].getBounds().x;
                    break;
                }
                case 1: {
                    n3 = 10;
                }
            }
        }
        return n3;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
        }
    }

    @Override
    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
        }
    }

    @Override
    public void requestFocus() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            this.getColumnList(treePath.getPathCount() - 2).requestFocus();
        } else {
            this.getColumnList(this.getListColumnCount() - 1).requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            return this.getColumnList(treePath.getPathCount() - 2).requestFocusInWindow();
        }
        return this.getColumnList(this.getListColumnCount() - 1).requestFocusInWindow();
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string;
        if (object != null && (string = object.toString()) != null) {
            return string;
        }
        return "";
    }

    protected ListUI getColumnListUI(ListUI listUI) {
        return listUI;
    }

    protected JScrollPane createScrollPane(@Nullable JComponent jComponent) {
        return new JBrowserScrollPane(jComponent);
    }

    protected class BorderSizeHandle
    extends SizeHandleBase {
        public BorderSizeHandle(int n) {
            super(n);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(this);
            Color color = aquaAppearance.getColor("controlBackground");
            Color color2 = aquaAppearance.getColor("separator");
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color2);
            graphics.fillRect(this.getWidth() - 1, 0, 1, this.getHeight());
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(1, 100000);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, 10);
        }
    }

    protected class IconSizeHandle
    extends SizeHandleBase {
        private int width;
        private int height;

        public IconSizeHandle(int n) {
            super(n);
            this.width = 15;
            this.height = 15;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(this);
            Color color = aquaAppearance.getColor("legacyScrollBarTrack");
            Color color2 = aquaAppearance.getColor("legacyScrollBarInnerBorder");
            Color color3 = aquaAppearance.getColor("legacyScrollBarOuterBorder");
            Color color4 = aquaAppearance.getColor("scrollPaneGrabber");
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width, this.height);
            if (color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(0, 0, 1, this.height);
            }
            if (color3 != null) {
                graphics.setColor(color3);
                graphics.fillRect(this.width - 1, 0, 1, this.height);
            }
            graphics.setColor(color4);
            graphics.fillRect(5, 4, 1, 7);
            graphics.fillRect(9, 4, 1, 7);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && this.column >= 0) {
                JBrowser.this.setColumnWidth(this.column, Math.max(JBrowser.this.getColumnMinimumWidth(), JBrowser.this.getColumnPreferredWidth(this.column)));
            }
        }
    }

    protected abstract class SizeHandleBase
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        protected int column;
        protected int startMouseX;
        protected int startWidth;

        public SizeHandleBase(int n) {
            this.column = n;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setCursor(Cursor.getPredefinedCursor(11));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.startMouseX >= 0) {
                int n = this.toScreenX(mouseEvent.getPoint());
                int n2 = n - this.startMouseX;
                if (this.column < 0) {
                    JBrowser.this.setPreviewColumnWidth(Math.max(this.startWidth + n2, 0));
                } else {
                    JBrowser.this.setColumnWidth(this.column, Math.max(this.startWidth + n2, JBrowser.this.getColumnMinimumWidth()));
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.startMouseX = this.toScreenX(mouseEvent.getPoint());
            this.startWidth = this.column < 0 ? JBrowser.this.getPreviewColumnWidth() : JBrowser.this.getColumnWidth(this.column);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.startMouseX >= 0) {
                int n = this.toScreenX(mouseEvent.getPoint());
                int n2 = n - this.startMouseX;
                if (this.column < 0) {
                    JBrowser.this.setPreviewColumnWidth(Math.max(this.startWidth + n2, 0));
                } else {
                    JBrowser.this.setColumnWidth(this.column, Math.max(this.startWidth + n2, JBrowser.this.getColumnMinimumWidth()));
                }
            }
            this.startMouseX = -1;
        }

        protected int toScreenX(Point point) {
            SwingUtilities.convertPointToScreen(point, this);
            return point.x;
        }
    }

    protected class JBrowserScrollPane
    extends JScrollPane {
        public JBrowserScrollPane(JComponent jComponent) {
            super(jComponent, 22, 31);
            this.setBorder(null);
            this.setFocusable(false);
            this.getVerticalScrollBar().setFocusable(false);
            this.getHorizontalScrollBar().setFocusable(false);
            this.setLayout(new BrowserScrollPaneLayout());
        }
    }

    protected class PreviewColumn
    extends Column {
        @NotNull
        private BrowserPreviewRenderer renderer;
        int designatedWidth;
        @Nullable
        Component currentComponent;

        public PreviewColumn(BrowserPreviewRenderer browserPreviewRenderer) {
            super(null, -1);
            this.renderer = browserPreviewRenderer;
        }

        @NotNull
        public BrowserPreviewRenderer getRenderer() {
            return this.renderer;
        }

        public void setRenderer(@NotNull BrowserPreviewRenderer browserPreviewRenderer) {
            if (browserPreviewRenderer != this.renderer) {
                this.renderer = browserPreviewRenderer;
            }
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            if (this.getComponentCount() > 0) {
                Dimension dimension = super.getMinimumSize();
                return new Dimension(dimension.width, Math.max(dimension.height, JBrowser.this.columnMinimumHeight));
            }
            return new Dimension(JBrowser.this.getFixedCellWidth(), JBrowser.this.columnMinimumHeight);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = Math.max(this.designatedWidth, dimension.width);
            int n2 = Math.max(JBrowser.this.columnMinimumHeight, dimension.height);
            return new Dimension(n, n2);
        }

        public void setDesignatedWidth(int n) {
            if (n > 0) {
                Dimension dimension = this.getMinimumSize();
                int n2 = dimension.width;
                this.designatedWidth = Math.max(n2, n);
            } else {
                this.designatedWidth = 0;
            }
            this.revalidate();
            this.repaint();
        }

        public void updateSelection(@NotNull TreePath[] treePathArray) {
            Component component = this.renderer.getPreviewRendererComponent(JBrowser.this, treePathArray);
            this.removeAll();
            this.add(component);
            if (this.designatedWidth > 0) {
                Dimension dimension = component.getMinimumSize();
                int n = dimension.width;
                if (n > this.designatedWidth) {
                    this.designatedWidth = n;
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    protected class ListColumn
    extends Column {
        public ListColumn(JList jList, int n) {
            super(jList, n);
        }

        @NotNull
        public JList getList() {
            try {
                return (JList)this.getView();
            }
            catch (ClassCastException classCastException) {
                throw new AssertionError("Unexpected exception", classCastException);
            }
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            int n = JBrowser.this.getColumnMinimumWidth();
            int n2 = JBrowser.this.getColumnMinimumHeight();
            return new Dimension(n, n2);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = Math.max(dimension.width, JBrowser.this.getColumnMinimumWidth());
            int n2 = Math.max(dimension.height, JBrowser.this.getColumnMinimumHeight());
            return new Dimension(n, n2);
        }

        public int getColumnPreferredWidth() {
            JList jList = this.getList();
            int n = jList.getFixedCellWidth();
            jList.setFixedCellWidth(-1);
            int n2 = jList.getPreferredSize().width;
            jList.setFixedCellWidth(n);
            return n2;
        }

        public int getFixedCellWidth() {
            JList jList = this.getList();
            return jList.getFixedCellWidth();
        }

        public void setFixedCellWidth(int n) {
            JList jList = this.getList();
            jList.setFixedCellWidth(n);
            this.revalidate();
            this.repaint();
        }
    }

    protected abstract class Column
    extends JPanel {
        private JScrollPane scrollPane;
        private Component sizeHandle;
        private int columnIndex;

        protected Column(JComponent jComponent, int n) {
            this.columnIndex = n;
            this.setLayout(new BorderLayout());
            if (n >= 0 || JBrowser.this.isPreviewColumnScrollable()) {
                this.scrollPane = JBrowser.this.createScrollPane(jComponent);
                this.add(this.scrollPane);
                this.configureFromScrollBars();
                this.scrollPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("AquaOverlayScrollBars".equals(propertyChangeEvent.getPropertyName())) {
                            Column.this.configureFromScrollBars();
                        }
                    }
                });
            } else if (jComponent != null) {
                this.add(jComponent);
            }
        }

        protected void configureFromScrollBars() {
            boolean bl = Boolean.TRUE.equals(this.scrollPane.getClientProperty("AquaOverlayScrollBars"));
            if (this.sizeHandle != null) {
                this.remove(this.sizeHandle);
                this.scrollPane.setCorner("LOWER_RIGHT_CORNER", null);
            }
            if (bl) {
                this.sizeHandle = new BorderSizeHandle(this.columnIndex);
                this.add(this.sizeHandle, "East");
            } else {
                this.sizeHandle = new IconSizeHandle(this.columnIndex);
                this.sizeHandle.setVisible(JBrowser.this.isColumnsResizable());
                this.scrollPane.setCorner("LOWER_RIGHT_CORNER", this.sizeHandle);
            }
        }

        protected Component getView() {
            return this.scrollPane != null ? this.scrollPane.getViewport().getView() : this.getComponent(0);
        }

        public void setResizable(boolean bl) {
            if (this.sizeHandle != null) {
                this.sizeHandle.setVisible(bl);
            }
        }
    }

    private class BrowserCellRendererWrapper
    extends JPanel
    implements ListCellRenderer,
    Accessible {
        private BrowserCellRenderer browserCellRenderer;
        private Component browserCellRendererComponent;
        private JLabel arrowLabel;
        protected Icon expandedIcon = null;
        protected Icon selectedExpandedIcon = null;
        protected Icon focusedSelectedExpandedIcon = null;

        public BrowserCellRendererWrapper(BrowserCellRenderer browserCellRenderer) {
            this.browserCellRenderer = browserCellRenderer;
            this.expandedIcon = UIManager.getIcon("Browser.expandedIcon");
            this.selectedExpandedIcon = UIManager.getIcon("Browser.selectedExpandedIcon");
            this.focusedSelectedExpandedIcon = UIManager.getIcon("Browser.focusedSelectedExpandedIcon");
            this.setLayout(new BorderLayout());
            this.arrowLabel = new ArrowLabel();
            this.setOpaque(true);
            this.arrowLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
            this.arrowLabel.setIcon(this.expandedIcon);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = AquaFocusHandler.hasFocus(jList);
            boolean bl4 = JBrowser.this.getModel().isLeaf(object);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.arrowLabel.setForeground(jList.getSelectionForeground());
                this.arrowLabel.setIcon(bl3 ? this.focusedSelectedExpandedIcon : this.selectedExpandedIcon);
            } else {
                this.setBackground(AquaColors.CLEAR);
                this.arrowLabel.setForeground(jList.getForeground());
                this.arrowLabel.setIcon(this.expandedIcon);
            }
            this.arrowLabel.setVisible(!JBrowser.this.getModel().isLeaf(object));
            boolean bl5 = false;
            int n2 = JBrowser.this.expandedPath.getPathCount();
            for (int i = 0; i < n2; ++i) {
                if (JBrowser.this.expandedPath.getPathComponent(i) != object) continue;
                bl5 = true;
                break;
            }
            this.browserCellRendererComponent = this.browserCellRenderer.getBrowserCellRendererComponent(JBrowser.this, object, bl, bl5, bl4, n, bl3 && jList.getLeadSelectionIndex() == n);
            this.removeAll();
            this.add(this.browserCellRendererComponent, "Center");
            this.add((Component)this.arrowLabel, "East");
            Border border = UIManager.getBorder(bl2 ? "List.focusCellHighlightBorder" : "List.cellNoFocusBorder");
            if (border == null) {
                border = DEFAULT_NO_FOCUS_BORDER;
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.browserCellRendererComponent != null) {
                this.browserCellRendererComponent.setFont(font);
            }
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, long l, long l2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        protected class ArrowLabel
        extends JLabel {
            protected ArrowLabel() {
            }

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long l, int n, int n2, int n3, int n4) {
            }

            @Override
            public void repaint(Rectangle rectangle) {
            }

            @Override
            protected void firePropertyChange(String string, Object object, Object object2) {
                if (string != null && string.equals("text")) {
                    super.firePropertyChange(string, object, object2);
                }
            }

            @Override
            public void firePropertyChange(String string, short s, short s2) {
            }

            @Override
            public void firePropertyChange(String string, int n, int n2) {
            }

            @Override
            public void firePropertyChange(String string, long l, long l2) {
            }

            @Override
            public void firePropertyChange(String string, float f, float f2) {
            }

            @Override
            public void firePropertyChange(String string, double d, double d2) {
            }

            @Override
            public void firePropertyChange(String string, boolean bl, boolean bl2) {
            }
        }
    }

    private class TreeRootHandler
    implements TreeModelListener {
        private TreeRootHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getPath().length == 1) {
                for (int i = JBrowser.this.getListColumnCount() - 1; i >= 0; --i) {
                    JBrowser.this.removeLastListColumn();
                }
                JBrowser.this.expandedPath = null;
                JBrowser.this.expandRoot();
                JBrowser.this.setSelectionPath(treeModelEvent.getTreePath());
            }
        }
    }

    private static class ColumnSelectionModel
    implements ListSelectionModel,
    Cloneable,
    Serializable {
        private static final int MIN = -1;
        private static final int MAX = Integer.MAX_VALUE;
        private int selectionMode = 2;
        private int minIndex = Integer.MAX_VALUE;
        private int maxIndex = -1;
        private int anchorIndex = -1;
        private int leadIndex = -1;
        private int firstAdjustedIndex = Integer.MAX_VALUE;
        private int lastAdjustedIndex = -1;
        private boolean isAdjusting = false;
        private int firstChangedIndex = Integer.MAX_VALUE;
        private int lastChangedIndex = -1;
        private BitSet value = new BitSet(32);
        protected EventListenerList listenerList = new EventListenerList();
        protected boolean leadAnchorNotificationEnabled = true;

        private ColumnSelectionModel() {
        }

        @Override
        public int getMinSelectionIndex() {
            return this.isSelectionEmpty() ? -1 : this.minIndex;
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.maxIndex;
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.isAdjusting;
        }

        @Override
        public int getSelectionMode() {
            return this.selectionMode;
        }

        @Override
        public void setSelectionMode(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.selectionMode = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid selectionMode");
                }
            }
        }

        @Override
        public boolean isSelectedIndex(int n) {
            return n < this.minIndex || n > this.maxIndex ? false : this.value.get(n);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.minIndex > this.maxIndex;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listenerList.add(ListSelectionListener.class, listSelectionListener);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
        }

        public ListSelectionListener[] getListSelectionListeners() {
            return (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
        }

        protected void fireValueChanged(boolean bl) {
            if (this.lastChangedIndex == -1) {
                return;
            }
            int n = this.firstChangedIndex;
            int n2 = this.lastChangedIndex;
            this.firstChangedIndex = Integer.MAX_VALUE;
            this.lastChangedIndex = -1;
            this.fireValueChanged(n, n2, bl);
        }

        protected void fireValueChanged(int n, int n2) {
            this.fireValueChanged(n, n2, this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int n, int n2, boolean bl) {
            Object[] objectArray = this.listenerList.getListenerList();
            ListSelectionEvent listSelectionEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ListSelectionListener.class) continue;
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
            }
        }

        private void fireValueChanged() {
            if (this.lastAdjustedIndex == -1) {
                return;
            }
            if (this.getValueIsAdjusting()) {
                this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
                this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
            }
            int n = this.firstAdjustedIndex;
            int n2 = this.lastAdjustedIndex;
            this.firstAdjustedIndex = Integer.MAX_VALUE;
            this.lastAdjustedIndex = -1;
            this.fireValueChanged(n, n2);
        }

        public EventListener[] getListeners(Class clazz) {
            return this.listenerList.getListeners(clazz);
        }

        private void markAsDirty(int n) {
            this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, n);
            this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, n);
        }

        private void set(int n) {
            if (this.value.get(n)) {
                return;
            }
            this.value.set(n);
            this.markAsDirty(n);
            this.minIndex = Math.min(this.minIndex, n);
            this.maxIndex = Math.max(this.maxIndex, n);
        }

        private void clear(int n) {
            if (!this.value.get(n)) {
                return;
            }
            this.value.clear(n);
            this.markAsDirty(n);
            if (n == this.minIndex) {
                ++this.minIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                    ++this.minIndex;
                }
            }
            if (n == this.maxIndex) {
                --this.maxIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                    --this.maxIndex;
                }
            }
            if (this.isSelectionEmpty()) {
                this.minIndex = Integer.MAX_VALUE;
                this.maxIndex = -1;
            }
        }

        public void setLeadAnchorNotificationEnabled(boolean bl) {
            this.leadAnchorNotificationEnabled = bl;
        }

        public boolean isLeadAnchorNotificationEnabled() {
            return this.leadAnchorNotificationEnabled;
        }

        private void updateLeadAnchorIndices(int n, int n2) {
            if (this.leadAnchorNotificationEnabled) {
                if (this.anchorIndex != n) {
                    if (this.anchorIndex != -1) {
                        this.markAsDirty(this.anchorIndex);
                    }
                    this.markAsDirty(n);
                }
                if (this.leadIndex != n2) {
                    if (this.leadIndex != -1) {
                        this.markAsDirty(this.leadIndex);
                    }
                    this.markAsDirty(n2);
                }
            }
            this.anchorIndex = n;
            this.leadIndex = n2;
        }

        private boolean contains(int n, int n2, int n3) {
            return n3 >= n && n3 <= n2;
        }

        private void changeSelection(int n, int n2, int n3, int n4, boolean bl) {
            for (int i = Math.min(n3, n); i <= Math.max(n4, n2); ++i) {
                boolean bl2 = this.contains(n, n2, i);
                boolean bl3 = this.contains(n3, n4, i);
                if (bl3 && bl2) {
                    if (bl) {
                        bl2 = false;
                    } else {
                        bl3 = false;
                    }
                }
                if (bl3) {
                    this.set(i);
                }
                if (!bl2) continue;
                this.clear(i);
            }
            this.fireValueChanged();
        }

        private void changeSelection(int n, int n2, int n3, int n4) {
            this.changeSelection(n, n2, n3, n4, true);
        }

        @Override
        public void clearSelection() {
            this.removeSelectionInterval(this.minIndex, this.maxIndex);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0) {
                n = n2;
            }
            this.updateLeadAnchorIndices(n, n2);
            int n3 = this.minIndex;
            int n4 = this.maxIndex;
            int n5 = Math.min(n, n2);
            int n6 = Math.max(n, n2);
            this.changeSelection(n3, n4, n5, n6);
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(n, n2);
                return;
            }
            this.updateLeadAnchorIndices(n, n2);
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            int n5 = Math.min(n, n2);
            int n6 = Math.max(n, n2);
            this.changeSelection(n3, n4, n5, n6);
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            this.updateLeadAnchorIndices(n, n2);
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            int n5 = Integer.MAX_VALUE;
            int n6 = -1;
            if (this.getSelectionMode() != 2 && n3 > this.minIndex && n4 < this.maxIndex) {
                n4 = this.maxIndex;
            }
            this.changeSelection(n3, n4, n5, n6);
        }

        private void setState(int n, boolean bl) {
            if (bl) {
                this.set(n);
            } else {
                this.clear(n);
            }
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
            int n3;
            int n4 = bl ? n : n + 1;
            int n5 = n4 + n2 - 1;
            for (n3 = this.maxIndex; n3 >= n4; --n3) {
                this.setState(n3 + n2, this.value.get(n3));
            }
            n3 = 0;
            for (int i = n4; i <= n5; ++i) {
                this.setState(i, n3 != 0);
            }
            if (n <= this.leadIndex) {
                this.leadIndex += n2;
            }
            this.fireValueChanged();
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            int n5 = n4 - n3 + 1;
            for (int i = n3; i <= this.maxIndex; ++i) {
                this.setState(i, this.value.get(i + n5));
            }
            if (this.leadIndex >= n2) {
                this.leadIndex = this.leadIndex - (n2 - n) - 1;
            } else if (this.leadIndex >= n) {
                this.leadIndex = n;
            }
            this.fireValueChanged();
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
            if (bl != this.isAdjusting) {
                this.isAdjusting = bl;
                this.fireValueChanged(bl);
            }
        }

        public String toString() {
            String string = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
            return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + string;
        }

        public Object clone() throws CloneNotSupportedException {
            ColumnSelectionModel columnSelectionModel = (ColumnSelectionModel)super.clone();
            columnSelectionModel.value = (BitSet)this.value.clone();
            columnSelectionModel.listenerList = new EventListenerList();
            return columnSelectionModel;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.anchorIndex;
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.leadIndex;
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            this.updateLeadAnchorIndices(n, this.leadIndex);
            this.anchorIndex = n;
            this.fireValueChanged();
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            int n2 = this.anchorIndex;
            if (n2 == -1 || n == -1) {
                return;
            }
            if (this.leadIndex == -1) {
                this.leadIndex = n;
            }
            boolean bl = this.value.get(this.anchorIndex);
            if (this.getSelectionMode() == 0) {
                n2 = n;
                bl = true;
            }
            int n3 = Math.min(this.anchorIndex, this.leadIndex);
            int n4 = Math.max(this.anchorIndex, this.leadIndex);
            int n5 = Math.min(n2, n);
            int n6 = Math.max(n2, n);
            this.updateLeadAnchorIndices(n2, n);
            if (bl) {
                this.changeSelection(n3, n4, n5, n6);
            } else {
                this.changeSelection(n5, n6, n3, n4, false);
            }
        }
    }

    private class ColumnKeyListener
    implements KeyListener {
        private ColumnKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Object object;
            JList jList = (JList)keyEvent.getComponent();
            ColumnListModel columnListModel = (ColumnListModel)jList.getModel();
            TreePath treePath = columnListModel.path;
            if (keyEvent.getKeyCode() == 37) {
                if (treePath.getPathCount() > 1) {
                    keyEvent.consume();
                    jList.clearSelection();
                    object = JBrowser.this.getColumnList(treePath.getPathCount() - 2);
                    JBrowser.this.selectionModel.setSelectionPath(treePath);
                    object.requestFocus();
                }
            } else if (keyEvent.getKeyCode() == 39) {
                object = JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 1);
                if (object.getSelectedIndex() == -1 && object.getModel().getSize() != 0) {
                    keyEvent.consume();
                    object.setSelectedIndex(0);
                    JBrowser.this.selectionModel.setSelectionPath(((ColumnListModel)object.getModel()).path.pathByAddingChild(object.getSelectedValue()));
                }
                object.requestFocus();
            } else {
                TreePath treePath2;
                object = jList.getSelectedIndices();
                if (((int[])object).length == 0) {
                    treePath2 = columnListModel.path;
                    JBrowser.this.selectionModel.setSelectionPath(treePath2);
                    if (JBrowser.this.getListColumnCount() > 1) {
                        JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 2).requestFocus();
                    }
                } else if (((int[])object).length == 1) {
                    treePath2 = treePath.pathByAddingChild(jList.getSelectedValue());
                    JBrowser.this.selectionModel.setSelectionPath(treePath2);
                } else {
                    treePath2 = treePath.pathByAddingChild(columnListModel.getElementAt(jList.getLeadSelectionIndex()));
                    TreePath[] treePathArray = new TreePath[((Object)object).length];
                    int n = -1;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        treePathArray[i] = columnListModel.path.pathByAddingChild(columnListModel.getElementAt((int)object[i]));
                        if (!treePathArray[i].equals(treePath2)) continue;
                        n = i;
                    }
                    if (n >= 0) {
                        treePathArray[n] = treePathArray[treePathArray.length - 1];
                        treePathArray[treePathArray.length - 1] = treePath2;
                    }
                    JBrowser.this.selectionModel.setSelectionPaths(treePathArray);
                }
            }
            if (!keyEvent.isConsumed()) {
                object = JBrowser.this.getKeyListeners();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i].keyReleased(keyEvent);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                KeyListener[] keyListenerArray = JBrowser.this.getKeyListeners();
                for (int i = 0; i < keyListenerArray.length; ++i) {
                    keyListenerArray[i].keyTyped(keyEvent);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                KeyListener[] keyListenerArray = JBrowser.this.getKeyListeners();
                for (int i = 0; i < keyListenerArray.length; ++i) {
                    keyListenerArray[i].keyPressed(keyEvent);
                }
            }
        }
    }

    private class ColumnMouseListener
    extends MouseAdapter {
        private ColumnMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getComponent();
            EventListener[] eventListenerArray = JBrowser.this.getListeners(MouseListener.class);
            if (eventListenerArray.length > 0) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                for (Container container = jList; container != JBrowser.this; container = container.getParent()) {
                    n += ((Component)container).getX();
                    n2 += ((Component)container).getY();
                }
                MouseEvent mouseEvent2 = new MouseEvent(JBrowser.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((MouseListener)eventListenerArray[i]).mouseReleased(mouseEvent2);
                }
            }
            this.updateExpandedState(jList);
        }

        private void updateExpandedState(JList jList) {
            ColumnListModel columnListModel = (ColumnListModel)jList.getModel();
            TreePath treePath = columnListModel.path;
            int[] nArray = jList.getSelectedIndices();
            if (nArray.length == 0) {
                TreePath treePath2 = columnListModel.path;
                JBrowser.this.selectionModel.setSelectionPath(treePath2);
            } else if (nArray.length == 1) {
                TreePath treePath3 = treePath.pathByAddingChild(jList.getSelectedValue());
                JBrowser.this.selectionModel.setSelectionPath(treePath3);
            } else {
                int n = jList.getLeadSelectionIndex();
                if (n < 0 || n >= columnListModel.getSize()) {
                    TreePath[] treePathArray = new TreePath[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        treePathArray[i] = columnListModel.path.pathByAddingChild(columnListModel.getElementAt(nArray[i]));
                    }
                    JBrowser.this.selectionModel.setSelectionPaths(treePathArray);
                } else {
                    TreePath treePath4 = treePath.pathByAddingChild(columnListModel.getElementAt(n));
                    TreePath[] treePathArray = new TreePath[nArray.length];
                    int n2 = -1;
                    for (int i = 0; i < nArray.length; ++i) {
                        treePathArray[i] = columnListModel.path.pathByAddingChild(columnListModel.getElementAt(nArray[i]));
                        if (!treePathArray[i].equals(treePath4)) continue;
                        n2 = i;
                    }
                    if (n2 != -1) {
                        treePathArray[n2] = treePathArray[treePathArray.length - 1];
                        treePathArray[treePathArray.length - 1] = treePath4;
                    }
                    JBrowser.this.selectionModel.setSelectionPaths(treePathArray);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getComponent();
            EventListener[] eventListenerArray = JBrowser.this.getListeners(MouseListener.class);
            if (eventListenerArray.length > 0) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                for (Container container = jList; container != JBrowser.this; container = container.getParent()) {
                    n += ((Component)container).getX();
                    n2 += ((Component)container).getY();
                }
                MouseEvent mouseEvent2 = new MouseEvent(JBrowser.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((MouseListener)eventListenerArray[i]).mouseClicked(mouseEvent2);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getComponent();
            EventListener[] eventListenerArray = JBrowser.this.getListeners(MouseListener.class);
            if (eventListenerArray.length > 0) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                for (Container container = jList; container != JBrowser.this; container = container.getParent()) {
                    n += ((Component)container).getX();
                    n2 += ((Component)container).getY();
                }
                MouseEvent mouseEvent2 = new MouseEvent(JBrowser.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((MouseListener)eventListenerArray[i]).mousePressed(mouseEvent2);
                }
            }
        }
    }

    private class SelectionModeUpdater
    implements Serializable,
    PropertyChangeListener {
        private SelectionModeUpdater() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("selectionMode")) {
                int n;
                switch (JBrowser.this.selectionModel.getSelectionMode()) {
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 4: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                for (int i = 0; i < JBrowser.this.getListColumnCount(); ++i) {
                    JBrowser.this.getColumnList(i).getSelectionModel().setSelectionMode(n);
                }
            }
        }
    }

    private class TreeSelectionUpdater
    implements Serializable,
    TreeSelectionListener {
        private TreeSelectionUpdater() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Serializable serializable;
            int n;
            switch (JBrowser.this.selectionModel.getSelectionCount()) {
                case 0: {
                    JBrowser.this.expandPath(new TreePath(JBrowser.this.treeModel.getRoot()));
                    n = JBrowser.this.getListColumnCount();
                    if (n <= 0) break;
                    JBrowser.this.getColumnList(n - 1).clearSelection();
                    break;
                }
                case 1: {
                    TreePath treePath = JBrowser.this.selectionModel.getSelectionPath();
                    JBrowser.this.expandPath(treePath);
                    if (JBrowser.this.treeModel.isLeaf(treePath.getLastPathComponent())) break;
                    int n2 = JBrowser.this.getListColumnCount();
                    JBrowser.this.getColumnList(n2 - 1).clearSelection();
                    break;
                }
                default: {
                    int n3;
                    TreePath treePath = JBrowser.this.selectionModel.getLeadSelectionPath();
                    TreePath treePath2 = treePath.getParentPath();
                    JBrowser.this.expandPath(treePath2);
                    if (treePath2 == null) break;
                    serializable = JBrowser.this.getColumnList(treePath2.getPathCount() - 1);
                    TreePath[] treePathArray = JBrowser.this.selectionModel.getSelectionPaths();
                    int[] nArray = new int[treePathArray.length];
                    int n4 = -1;
                    for (n3 = 0; n3 < treePathArray.length; ++n3) {
                        nArray[n3] = JBrowser.this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePathArray[n3].getLastPathComponent());
                        if (!treePathArray[n3].equals(treePath)) continue;
                        n4 = n3;
                    }
                    n3 = nArray[n4];
                    nArray[n4] = nArray[nArray.length - 1];
                    nArray[nArray.length - 1] = n3;
                    int n5 = ((JList)serializable).getAnchorSelectionIndex();
                    ((JList)serializable).setSelectedIndices(nArray);
                    if (n5 < 0 || !((JList)serializable).isSelectedIndex(n5)) break;
                    ((JList)serializable).getSelectionModel().setAnchorSelectionIndex(n5);
                    break;
                }
            }
            JBrowser.this.requestFocusInWindow();
            JBrowser.this.updatePreviewColumn();
            if (JBrowser.this.getParent() != null) {
                JBrowser.this.getParent().validate();
            }
            if ((n = JBrowser.this.getComponentCount() - 1) >= 0) {
                Rectangle rectangle = JBrowser.this.getComponent(n).getBounds();
                if (n > 0) {
                    serializable = JBrowser.this.getComponent(n - 1).getBounds();
                    rectangle.add((Rectangle)serializable);
                }
                JBrowser.this.scrollRectToVisible(rectangle);
                JBrowser.this.getComponent(n).repaint();
            }
            if (JBrowser.this.listenerList.getListenerCount(TreeSelectionListener.class) != 0) {
                TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(JBrowser.this);
                JBrowser.this.fireValueChanged(treeSelectionEvent2);
            }
        }
    }

    private class ColumnListModel
    extends AbstractListModel
    implements TreeModelListener {
        private TreePath path;
        private TreeModel model;
        private int size;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            int n = this.getSize();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.getElementAt(i));
            }
            stringBuilder.append("} #");
            stringBuilder.append(this.hashCode());
            return stringBuilder.toString();
        }

        public ColumnListModel(TreePath treePath, TreeModel treeModel) {
            this.path = treePath;
            this.model = treeModel;
            treeModel.addTreeModelListener(this);
            this.updateSize();
        }

        public void setPath(TreePath treePath) {
            if (treePath != this.path) {
                int n = this.getSize();
                this.path = treePath;
                this.updateSize();
                int n2 = this.getSize();
                if (Math.min(n, n2) > 0) {
                    this.fireContentsChanged(this, Math.min(n, n2), Math.min(n, n2));
                }
                if (n2 < n) {
                    this.fireIntervalRemoved(this, n2, n - 1);
                } else if (n2 > n) {
                    this.fireIntervalAdded(this, n, n2 - 1);
                }
            }
        }

        public void dispose() {
            this.model.removeTreeModelListener(this);
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private void updateSize() {
            this.size = this.model.getChildCount(this.path.getLastPathComponent());
        }

        @Override
        public Object getElementAt(int n) {
            return this.model.getChild(this.path.getLastPathComponent(), n);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getTreePath().equals(this.path)) {
                int[] nArray = treeModelEvent.getChildIndices();
                this.fireContentsChanged(this, nArray[0], nArray[nArray.length - 1]);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getTreePath().equals(this.path)) {
                int n;
                this.updateSize();
                int[] nArray = treeModelEvent.getChildIndices();
                int n2 = 0;
                do {
                    int n3 = nArray[n2];
                    for (n = n2 + 1; n < nArray.length && nArray[n] == n3 + n - n2; ++n) {
                    }
                    this.fireIntervalAdded(this, n3, nArray[n - 1]);
                } while ((n2 = n) < nArray.length);
            } else if (this.path.getPathCount() == 1 && JBrowser.this.expandedPath != null && JBrowser.this.expandedPathIsLeaf && treeModelEvent.getTreePath().equals(JBrowser.this.expandedPath)) {
                JBrowser.this.expandPath(JBrowser.this.expandedPath);
            }
            this.ensureSelectionVisible();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getTreePath().equals(this.path)) {
                int n;
                this.updateSize();
                int[] nArray = treeModelEvent.getChildIndices();
                int n2 = 0;
                int n3 = 0;
                do {
                    int n4 = nArray[n2];
                    for (n = n2 + 1; n < nArray.length && nArray[n] == n4 + n - n2; ++n) {
                    }
                    this.fireIntervalRemoved(this, n4 - n3, nArray[n - 1] - n3);
                    n3 += nArray[n - 1] - n4 + 1;
                } while ((n2 = n) < nArray.length);
                if (JBrowser.this.selectionModel.getSelectionCount() > 0) {
                    TreePath[] treePathArray = JBrowser.this.selectionModel.getSelectionPaths();
                    Object[] objectArray = treeModelEvent.getChildren();
                    for (int i = 0; i < objectArray.length; ++i) {
                        TreePath treePath = treeModelEvent.getTreePath().pathByAddingChild(objectArray[i]);
                        for (int j = 0; j < treePathArray.length; ++j) {
                            if (!treePath.isDescendant(treePathArray[j])) continue;
                            treePathArray[j] = treeModelEvent.getTreePath();
                        }
                        JBrowser.this.setSelectionPaths(treePathArray);
                    }
                }
                this.ensureSelectionVisible();
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.equals(this.path) || this.path.getPathCount() == 1 && treePath.getPathCount() == 1) {
                int n = this.getSize();
                this.path = treePath;
                this.updateSize();
                int n2 = this.getSize();
                this.path = treePath;
                int n3 = n2 - n;
                if (n3 < 0) {
                    if (n2 > 0) {
                        this.fireContentsChanged(this, 0, n2 - 1);
                    }
                    this.fireIntervalRemoved(this, n2, n - 1);
                } else if (n3 > 0) {
                    if (n > 0) {
                        this.fireContentsChanged(this, 0, n - 1);
                    }
                    this.fireIntervalAdded(this, n, n2 - 1);
                } else {
                    this.fireContentsChanged(this, 0, n - 1);
                }
                JBrowser.this.setSelectionPath(treePath);
            }
        }

        private void ensureSelectionVisible() {
            int n;
            int n2;
            ListSelectionModel listSelectionModel;
            JList jList = JBrowser.this.getColumnList(this.path.getPathCount() - 1);
            if (jList != null && !(listSelectionModel = jList.getSelectionModel()).isSelectionEmpty() && (n2 = listSelectionModel.getMinSelectionIndex()) == (n = listSelectionModel.getMaxSelectionIndex())) {
                jList.ensureIndexIsVisible(n2);
            }
        }
    }

    protected static class BrowserLayout
    implements LayoutManager2 {
        private int minimumWidth = 0;
        private int minimumHeight = 0;
        private int preferredWidth = 0;
        private int preferredHeight = 0;
        private boolean sizeUnknown = true;

        protected BrowserLayout() {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
            this.sizeUnknown = true;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        private void setSizes(Container container) {
            int n = container.getComponentCount();
            this.minimumWidth = 0;
            this.minimumHeight = 0;
            this.preferredWidth = 0;
            this.preferredHeight = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getMinimumSize();
                this.minimumWidth += dimension.width;
                this.minimumHeight = Math.max(this.minimumHeight, dimension.height);
                Dimension dimension2 = component.getPreferredSize();
                this.preferredWidth += dimension2.width;
                this.preferredHeight = Math.max(this.preferredHeight, dimension2.height);
            }
            this.sizeUnknown = false;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            this.setSizes(container);
            Insets insets = container.getInsets();
            int n = this.preferredWidth + insets.left + insets.right;
            int n2 = this.preferredHeight + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            this.setSizes(container);
            Insets insets = container.getInsets();
            int n = this.minimumWidth + insets.left + insets.right;
            int n2 = this.minimumHeight + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(100000, 100000);
        }

        @Override
        public void layoutContainer(Container container) {
            JBrowser jBrowser = (JBrowser)container;
            Insets insets = container.getInsets();
            int n = container.getHeight() - (insets.top + insets.bottom);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = 0;
            int n5 = insets.left;
            int n6 = insets.top;
            boolean bl = false;
            boolean bl2 = false;
            if (this.sizeUnknown) {
                this.setSizes(container);
            }
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                n5 += n3;
                dimension.height = n;
                int n7 = dimension.width;
                int n8 = dimension.height;
                if (component == jBrowser.previewColumn && jBrowser.shouldFillPreviewColumn) {
                    int n9 = container.getWidth() - n5 - insets.right;
                    n7 = Math.max(n7, n9);
                }
                component.setBounds(n5, n6, n7, n8);
                n3 = n7;
                n4 = n8;
            }
        }
    }

    protected static class BrowserScrollPaneLayout
    extends ScrollPaneLayout
    implements UIResource {
        protected BrowserScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            boolean bl;
            super.layoutContainer(container);
            boolean bl2 = this.lowerRight != null && this.lowerRight.isVisible();
            boolean bl3 = this.vsb != null && this.vsb.isVisible();
            boolean bl4 = bl = this.hsb != null && this.hsb.isVisible();
            if (bl2 && bl3 && !bl) {
                Dimension dimension = this.lowerRight.getPreferredSize();
                Dimension dimension2 = this.vsb.getSize();
                this.vsb.setSize(dimension2.width, dimension2.height - dimension.height);
                this.lowerRight.setBounds(this.vsb.getX(), this.vsb.getY() + this.vsb.getHeight(), dimension2.width, dimension.height);
            }
        }
    }

    protected class ColumnList
    extends JList {
        public ColumnList(ColumnListModel columnListModel) {
            super(columnListModel);
        }

        @Override
        public void updateUI() {
            ListUI listUI = (ListUI)UIManager.getUI(this);
            this.setUI(JBrowser.this.getColumnListUI(listUI));
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)listCellRenderer));
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            int n = this.locationToIndex(point);
            if (n != -1 && (rectangle = this.getCellBounds(n, n)).contains(point)) {
                Object e = this.getModel().getElementAt(n);
                Component component = this.getCellRenderer().getListCellRendererComponent(this, e, n, false, false);
                if (component.getPreferredSize().width > this.getWidth()) {
                    return JBrowser.this.convertValueToText(e, false, false, false, n, false);
                }
            }
            return null;
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            int n = this.locationToIndex(point);
            if (n != -1 && (rectangle = this.getCellBounds(n, n)).contains(point)) {
                Object e = this.getModel().getElementAt(n);
                Component component = this.getCellRenderer().getListCellRendererComponent(this, e, n, false, false);
                if (component.getPreferredSize().width > this.getWidth()) {
                    Point point2 = rectangle.getLocation();
                    point2.x += ((JBrowser)JBrowser.this).cellTipOrigin.x;
                    point2.y += ((JBrowser)JBrowser.this).cellTipOrigin.y;
                    return point2;
                }
            }
            return null;
        }

        @Override
        public String toString() {
            String string = "ColumnList";
            ColumnListModel columnListModel = (ColumnListModel)this.getModel();
            return string + ": " + columnListModel;
        }
    }
}

