/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.text.Caret;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaCaret;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaTextComponentBorder;
import org.violetlib.aqua.AquaTextComponentDelegatedUIBase;
import org.violetlib.aqua.AquaTextComponentUIDelegate;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.Border2D;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaTextComponentUIBase
extends AquaTextComponentDelegatedUIBase
implements FocusRingOutlineProvider,
AquaComponentUI {
    private AquaFocusHandler handler;
    private boolean oldDragState;
    @NotNull
    protected BasicContextualColors colors = AquaColors.TEXT_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    protected AquaTextComponentUIBase(@NotNull AquaTextComponentUIDelegate aquaTextComponentUIDelegate) {
        super(aquaTextComponentUIDelegate);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.handler = this.createFocusHandler();
        this.editor.addFocusListener(this.handler);
        this.editor.addPropertyChangeListener(this.handler);
        AquaUtilControlSize.addSizePropertyListener(this.editor);
        AppearanceManager.installListener(this.editor);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.editor);
        AquaUtilControlSize.removeSizePropertyListener(this.editor);
        this.editor.removeFocusListener(this.handler);
        this.editor.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.editor.getDragEnabled();
            this.editor.setDragEnabled(true);
        }
        super.installDefaults();
        LookAndFeel.installProperty(this.editor, "opaque", false);
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.editor.setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        aquaKeyBindings.setDefaultAction(this.getKeymapName());
    }

    @NotNull
    protected AquaFocusHandler createFocusHandler() {
        return new AquaFocusHandler();
    }

    @Override
    protected void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("enabled".equals(string)) {
            this.configureAppearanceContext(null);
        }
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.editor);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(this.editor, this.appearanceContext, this.colors);
        this.editor.repaint();
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        if (this.editor.isEnabled()) {
            boolean bl = AquaFocusHandler.isActive(this.editor);
            boolean bl2 = AquaFocusHandler.hasFocus(this.editor);
            return bl ? (bl2 ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.DISABLED;
    }

    @Override
    public void update(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    protected void paintSafely(@NotNull Graphics graphics) {
        float f;
        float f2;
        Border2D border2D;
        Insets2D insets2D;
        Border border;
        Color color = this.getBackground();
        this.paintBackgroundSafely(graphics, color);
        if (graphics instanceof Graphics2D && (border = this.editor.getBorder()) instanceof Border2D && (insets2D = (border2D = (Border2D)((Object)border)).getBorderInsets2D(this.editor)) != null && (f2 = insets2D.getTop()) - (f = (float)Math.floor(f2)) > 0.001f) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(0.0, f2 - f);
            super.paintSafely(graphics2D);
            graphics2D.dispose();
            return;
        }
        super.paintSafely(graphics);
    }

    @Nullable
    protected Color getBackground() {
        return this.editor.getBackground();
    }

    protected void paintBackgroundSafely(@NotNull Graphics graphics, @Nullable Color color) {
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextComponentBorder) {
            AquaTextComponentBorder aquaTextComponentBorder = (AquaTextComponentBorder)border;
            aquaTextComponentBorder.paintBackground(this.editor, graphics, color);
        } else if (color != null && this.editor.isOpaque() && color.getAlpha() > 0) {
            int n = this.editor.getWidth();
            int n2 = this.editor.getHeight();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
        }
    }

    @Override
    protected void paintBackground(@NotNull Graphics graphics) {
    }

    @Override
    @NotNull
    protected Caret createCaret() {
        return new AquaCaret();
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border instanceof FocusRingOutlineProvider) {
            FocusRingOutlineProvider focusRingOutlineProvider = (FocusRingOutlineProvider)((Object)border);
            return focusRingOutlineProvider.getFocusRingOutline(jComponent);
        }
        return new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }
}

