/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OptionallyFocusableComponentHandler;

public class AquaFullKeyboardFocusableHandler
implements ChangeListener {
    public static final String OPTIONAL_FOCUSABILITY_HANDLER_KEY = "Aqua.optionalFocusabilityHandler";
    private static final String CLIENT_PROPERTY_KEY = "FullKeyboardFocusListener";
    private final JComponent c;

    public AquaFullKeyboardFocusableHandler(JComponent jComponent) {
        this.c = jComponent;
        this.update();
        OSXSystemProperties.addChangeListener(this);
    }

    public void dispose() {
        OSXSystemProperties.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    private void update() {
        boolean bl = OSXSystemProperties.isFullKeyboardAccessEnabled();
        Object object = this.c.getClientProperty(OPTIONAL_FOCUSABILITY_HANDLER_KEY);
        if (object instanceof OptionallyFocusableComponentHandler) {
            OptionallyFocusableComponentHandler optionallyFocusableComponentHandler = (OptionallyFocusableComponentHandler)object;
            optionallyFocusableComponentHandler.updateFocusability(this.c, bl);
        } else {
            this.c.setFocusable(bl);
        }
    }

    public static void addListener(JComponent jComponent) {
        AquaFullKeyboardFocusableHandler aquaFullKeyboardFocusableHandler = new AquaFullKeyboardFocusableHandler(jComponent);
        jComponent.putClientProperty(CLIENT_PROPERTY_KEY, aquaFullKeyboardFocusableHandler);
    }

    public static void removeListener(JComponent jComponent) {
        AquaFullKeyboardFocusableHandler aquaFullKeyboardFocusableHandler = (AquaFullKeyboardFocusableHandler)jComponent.getClientProperty(CLIENT_PROPERTY_KEY);
        if (aquaFullKeyboardFocusableHandler != null) {
            jComponent.putClientProperty(CLIENT_PROPERTY_KEY, null);
            aquaFullKeyboardFocusableHandler.dispose();
        }
    }
}

