/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.YosemiteLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class ElCapitanLayoutInfo
extends YosemiteLayoutInfo {
    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellLayoutConfiguration toolBarItemWellLayoutConfiguration = new ToolBarItemWellLayoutConfiguration();
            return this.getToolBarItemWellLayoutInfo(toolBarItemWellLayoutConfiguration);
        }
        AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return BasicLayoutInfo.getInstance();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return BasicLayoutInfo.getInstance();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 14, 12, 10), JNRUtils.size(size, 14, 12, 10));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 16, 14, 10), JNRUtils.size(size, 16, 14, 10));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 21, 19, 15), JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 21, 18, 15), JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return BasicLayoutInfo.getInstance();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return BasicLayoutInfo.createFixedHeight(17.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 22, 18, 15));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 24, 20, 17));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 20, 17, 14), JNRUtils.size(size, 21, 18, 15));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return BasicLayoutInfo.createFixed(18.0f, 18.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 21, 18, 15), JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 23, 20, 17), JNRUtils.size(size, 23, 20, 17));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return BasicLayoutInfo.createFixed(9.0f, 9.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 19, 17, 15));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return BasicLayoutInfo.createMinimum(44.0f, 23.0f);
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
        AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            f = JNRUtils.size(size, 1, 2, 1);
            f2 = JNRUtils.size(size, 2, 2, 2);
            f4 = f3 = (float)JNRUtils.size(size, 4, 4, 3);
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            f = 1.0f;
            f2 = 1.0f;
            f3 = 1.0f;
            f4 = 1.0f;
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            f = JNRUtils.size(size, 1, 2, 1);
            f2 = JNRUtils.size(size, 2, 2, 2);
            f4 = f3 = (float)JNRUtils.size(size, 4, 4, 3);
        } else {
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
                f = 1.0f;
                f2 = 1.0f;
                f3 = 1.0f;
                f4 = 1.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
                f2 = 1.0f;
                f = 1.0f;
                f3 = f4 = (float)JNRUtils.size(size, 4, 3, 3);
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                f = 2.0f;
                f2 = 2.0f;
                f3 = f4 = (float)JNRUtils.size(size, 6, 5, 5);
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
                f2 = 1.0f;
                f = 1.0f;
                f4 = 4.0f;
                f3 = 4.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
                f = 0.51f;
                f2 = 1.49f;
                f4 = 3.0f;
                f3 = 3.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
                f3 = f4 = JNRUtils.size2D(size, 4.0f, 3.5f, 3.0f);
                f = f4;
                f2 = f + 1.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
                f4 = 3.0f;
                f3 = 3.0f;
                f2 = f = 3.5f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
                f3 = f4 = JNRUtils.size2D(size, 3.5f, 3.0f, 2.5f);
                f = f4;
                f2 = f + 1.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR) {
                f = f2 = JNRUtils.size2D(size, 4.5f, 4.0f, 3.5f);
                f3 = f4 = JNRUtils.size2D(size, 3.5f, 3.0f, 2.5f);
            } else {
                if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
                    return null;
                }
                if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
                    f = JNRUtils.size(size, 1, 1, 1);
                    f2 = JNRUtils.size(size, 1, 1, 1);
                    f4 = f3 = (float)JNRUtils.size(size, 7, 6, 6);
                } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
                    f = 2.0f;
                    f2 = 3.0f;
                    f4 = 4.0f;
                    f3 = 4.0f;
                } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
                    // empty if block
                }
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(buttonLayoutConfiguration);
        return Insetters.createFixed(f, f3, f2, f4, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getSegmentedButtonLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonLayoutConfiguration.getSize();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 22, 19, 16));
            }
            case BUTTON_SEGMENTED_INSET: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 22, 18, 15));
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 24, 20, 17));
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 21, 19, 17));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getSegmentedButtonLabelInsets(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration) {
        float f;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonLayoutConfiguration.getWidget();
        AquaUIPainter.Position position = segmentedButtonLayoutConfiguration.getPosition();
        LayoutInfo layoutInfo = this.getLayoutInfo(segmentedButtonLayoutConfiguration);
        float f2 = 1.0f;
        float f3 = 2.0f;
        float f4 = f = 1.0f;
        float f5 = 3.0f;
        boolean bl = position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.ONLY;
        boolean bl2 = position == AquaUIPainter.Position.LAST || position == AquaUIPainter.Position.ONLY;
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: {
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                f5 = 0.0f;
                f4 = 3.0f;
                f = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f3 = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                f2 = 0.5f;
                f3 = 1.5f;
                f5 = 2.0f;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                f2 = 0.5f;
                f3 = 1.5f;
                f5 = 0.0f;
                f4 = 3.0f;
                f = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f3 = 1.0f;
                f5 = 0.0f;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (bl) {
            f += f5;
        }
        if (bl2) {
            f4 += f5;
        }
        return Insetters.createFixed(f2, f, f3, f4, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getComboBoxLayoutInfo(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxLayoutConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(size, 14, 11, 11));
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED) {
            float f = JNRUtils.size(size, 22, 18, 15);
            float f2 = JNRUtils.size(size, 27, 24, 22);
            return BasicLayoutInfo.create(false, f2, true, f);
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            float f = JNRUtils.size(size, 24, 20, 17);
            float f3 = JNRUtils.size(size, 27, 24, 22);
            return BasicLayoutInfo.create(false, f3, true, f);
        }
        float f = JNRUtils.size(size, 22, 19, 15);
        float f4 = JNRUtils.size(size, 27, 24, 22);
        return BasicLayoutInfo.create(false, f4, true, f);
    }

    @Override
    @NotNull
    protected LayoutInfo getPopUpButtonLayoutInfo(@NotNull PopupButtonLayoutConfiguration popupButtonLayoutConfiguration) {
        boolean bl;
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonLayoutConfiguration.getPopupButtonWidget();
        AquaUIPainter.Size size = popupButtonLayoutConfiguration.getSize();
        boolean bl2 = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl3 = bl = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((bl2 || bl) && size == AquaUIPainter.Size.MINI) {
            size = AquaUIPainter.Size.SMALL;
        }
        switch (popupButtonWidget) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN: {
                float f = JNRUtils.size(size, 22, 19, 16);
                float f2 = JNRUtils.size(size, 25, 24, 20);
                return BasicLayoutInfo.create(false, f2, true, f);
            }
            case BUTTON_POP_UP_CELL: 
            case BUTTON_POP_DOWN_CELL: {
                return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(size, 12, 10, 10));
            }
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 23, 20, 17));
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                return BasicLayoutInfo.createFixedHeight(22.0f);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: {
                float f = JNRUtils.size(size, 22, 18, 15);
                float f3 = JNRUtils.size(size, 25, 24, 20);
                return BasicLayoutInfo.create(false, f3, true, f);
            }
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                float f = JNRUtils.size(size, 24, 20, 17);
                float f4 = JNRUtils.size(size, 25, 24, 20);
                return BasicLayoutInfo.create(false, f4, true, f);
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                return BasicLayoutInfo.createFixedHeight(21.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected LayoutInfo getTextFieldLayoutInfo(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldLayoutConfiguration.getWidget();
        if (textFieldWidget.isRound() || textFieldWidget.isSearch()) {
            if (textFieldWidget.isToolbar()) {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(textFieldLayoutConfiguration.getSize(), 24, 20, 17));
            }
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(textFieldLayoutConfiguration.getSize(), 22, 19, 17));
        }
        return BasicLayoutInfo.getInstance();
    }
}

