/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.violetlib.aqua.AquaColorChooserDialog;
import org.violetlib.aqua.AquaNativeColorChooser;
import org.violetlib.aqua.SharedColorChooserOwner;

public class AquaSharedColorChooser {
    private static boolean useNativeChooser = true;
    private static AquaSharedColorChooser INSTANCE;
    private boolean isInitialized;
    private JColorChooser sharedChooser;
    private JDialog sharedDialog;
    private WindowListener windowListener;
    private ComponentListener componentListener;
    private ChangeListener changeListener;
    private SharedColorChooserOwner currentOwner;

    public static boolean connect(SharedColorChooserOwner sharedColorChooserOwner, Color color, boolean bl) {
        AquaSharedColorChooser aquaSharedColorChooser = AquaSharedColorChooser.getInstance();
        return aquaSharedColorChooser.connectToOwner(sharedColorChooserOwner, color, bl);
    }

    public static void disconnect(SharedColorChooserOwner sharedColorChooserOwner) {
        AquaSharedColorChooser aquaSharedColorChooser = AquaSharedColorChooser.getInstance();
        aquaSharedColorChooser.disconnectOwner(sharedColorChooserOwner);
    }

    private static AquaSharedColorChooser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AquaSharedColorChooser();
        }
        return INSTANCE;
    }

    private AquaSharedColorChooser() {
    }

    public boolean connectToOwner(SharedColorChooserOwner sharedColorChooserOwner, Color color, boolean bl) {
        Object object;
        if (this.currentOwner == sharedColorChooserOwner) {
            return true;
        }
        if (this.currentOwner != null) {
            object = this.currentOwner;
            this.currentOwner = null;
            object.disconnected();
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            if (!useNativeChooser) {
                this.windowListener = new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        AquaSharedColorChooser.this.dismiss();
                    }

                    @Override
                    public void windowIconified(WindowEvent windowEvent) {
                        AquaSharedColorChooser.this.dismiss();
                    }
                };
                this.componentListener = new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent componentEvent) {
                        super.componentHidden(componentEvent);
                        AquaSharedColorChooser.this.dismiss();
                    }
                };
                this.changeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        AquaSharedColorChooser.this.apply();
                    }
                };
                this.sharedChooser = new JColorChooser();
                object = this.sharedChooser.getSelectionModel();
                object.addChangeListener(this.changeListener);
                this.sharedDialog = new AquaColorChooserDialog((Frame)null, "", false, null, this.sharedChooser);
                this.sharedDialog.addWindowListener(this.windowListener);
                this.sharedDialog.addComponentListener(this.componentListener);
            }
        }
        this.currentOwner = sharedColorChooserOwner;
        if (this.sharedDialog != null) {
            this.sharedDialog.setVisible(true);
            return true;
        }
        return AquaNativeColorChooser.display(sharedColorChooserOwner, color, bl);
    }

    public void disconnectOwner(SharedColorChooserOwner sharedColorChooserOwner) {
        if (sharedColorChooserOwner == this.currentOwner) {
            this.currentOwner = null;
            if (useNativeChooser && this.isInitialized) {
                AquaNativeColorChooser.disconnect();
            }
        }
    }

    private void apply() {
        if (this.currentOwner != null) {
            this.currentOwner.applyColor(this.sharedChooser.getColor());
        }
    }

    private void dismiss() {
        if (this.currentOwner != null) {
            SharedColorChooserOwner sharedColorChooserOwner = this.currentOwner;
            this.currentOwner = null;
            sharedColorChooserOwner.disconnected();
        }
    }
}

