/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import sun.awt.image.MultiResolutionCachedImage;
import sun.awt.image.MultiResolutionImage;

public class Aqua8MappedMultiResolutionImage
extends MultiResolutionCachedImage {
    private final Image baseImage;
    private final Image mappedBaseImage;
    private final Function<Image, Image> mapper;

    public Aqua8MappedMultiResolutionImage(MultiResolutionImage multiResolutionImage, Function<Image, Image> function) {
        super(Aqua8MappedMultiResolutionImage.getImageWidth(multiResolutionImage), Aqua8MappedMultiResolutionImage.getImageHeight(multiResolutionImage), new MyVariantMapper(multiResolutionImage, function));
        this.baseImage = (Image)multiResolutionImage;
        this.mappedBaseImage = function.apply(this.baseImage);
        this.mapper = function;
    }

    private static int getImageWidth(MultiResolutionImage multiResolutionImage) {
        int n = ((Image)multiResolutionImage).getWidth(null);
        if (n < 0) {
            throw new IllegalStateException("Multiresolution image has unknown width");
        }
        return n;
    }

    private static int getImageHeight(MultiResolutionImage multiResolutionImage) {
        int n = ((Image)multiResolutionImage).getHeight(null);
        if (n < 0) {
            throw new IllegalStateException("Multiresolution image has unknown height");
        }
        return n;
    }

    @Override
    public List<Image> getResolutionVariants() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        MultiResolutionImage multiResolutionImage = (MultiResolutionImage)this.baseImage;
        for (Image image : multiResolutionImage.getResolutionVariants()) {
            Image image2 = this.mapper.apply(image);
            arrayList.add(image2);
        }
        return arrayList;
    }

    @Override
    public Aqua8MappedMultiResolutionImage map(Function<Image, Image> function) {
        return new Aqua8MappedMultiResolutionImage((MultiResolutionImage)this, function);
    }

    @Override
    protected Image getBaseImage() {
        return this.mappedBaseImage;
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.baseImage.getWidth(imageObserver);
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.baseImage.getHeight(imageObserver);
    }

    private static class MyVariantMapper
    implements BiFunction<Integer, Integer, Image> {
        private final MultiResolutionImage source;
        private final Function<Image, Image> mapper;

        public MyVariantMapper(MultiResolutionImage multiResolutionImage, Function<Image, Image> function) {
            this.source = multiResolutionImage;
            this.mapper = function;
        }

        @Override
        public Image apply(Integer n, Integer n2) {
            Image image = this.source.getResolutionVariant(n.intValue(), n2.intValue());
            return this.mapper.apply(image);
        }
    }
}

