/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultRowSorter;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.violetlib.treetable.DefaultTreeTableSorter;
import org.violetlib.treetable.TreeColumnModel;
import org.violetlib.treetable.TreeTableSorter;
import org.violetlib.treetable.event.TreeTableSorterEvent;
import org.violetlib.treetable.event.TreeTableSorterListener;

public class DefaultTreeTableSorter<T extends TreeModel, C extends TreeColumnModel, I>
implements TreeTableSorter<T, C>,
TreeTableSorter.SortCycle {
    public static final List<SortOrder> ASCENDING_DESCENDING = Collections.unmodifiableList(Arrays.asList(SortOrder.ASCENDING, SortOrder.DESCENDING));
    public static final List<SortOrder> ASCENDING_DESCENDING_UNSORTED = Collections.unmodifiableList(Arrays.asList(SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED));
    public static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo((Comparable)object2);
        }
    };
    protected EventListenerList listenerList = new EventListenerList();
    private T treeModel;
    private C columnModel;
    private IdentityHashMap<Object, NodeSorter> sorters;
    private List<? extends RowSorter.SortKey> sortKeys = Collections.emptyList();
    private boolean[] isSortable;
    private Comparator[] comparators;
    private RowFilter<? super T, ? super I> rowFilter;
    private List<SortOrder> sortCycle = ASCENDING_DESCENDING;
    private int maxSortKeys = 3;
    private boolean sortsOnUpdates;

    public DefaultTreeTableSorter(T t, C c) {
        this.treeModel = t;
        this.columnModel = c;
        this.sorters = new IdentityHashMap();
        this.sorters.put(t.getRoot(), new NodeSorter(t.getRoot()));
    }

    public NodeSorter getRowSorter(Object object) {
        return this.sorters.get(object);
    }

    public NodeSorter getRowSorter(TreePath treePath) {
        IdentityHashMap<Object, NodeSorter> identityHashMap = this.sorters;
        NodeSorter nodeSorter = (NodeSorter)identityHashMap.get(treePath.getPathComponent(0));
        int n = treePath.getPathCount();
        for (int i = 1; i < n; ++i) {
            Object object = treePath.getPathComponent(i);
            nodeSorter = nodeSorter.getChildSorter(object, identityHashMap);
        }
        return nodeSorter;
    }

    public T getTreeModel() {
        return this.treeModel;
    }

    public C getTreeColumnModel() {
        return this.columnModel;
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setSortsOnUpdates(boolean bl) {
        this.sortsOnUpdates = bl;
    }

    public int getMaxSortKeys() {
        return this.maxSortKeys;
    }

    public void setMaxSortKeys(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid max");
        }
        this.maxSortKeys = n;
    }

    public void setSortable(int n, boolean bl) {
        this.checkColumn(n);
        if (this.isSortable == null) {
            if (bl) {
                return;
            }
            this.isSortable = new boolean[this.columnModel.getColumnCount()];
            Arrays.fill(this.isSortable, true);
        }
        this.isSortable[n] = bl;
    }

    public boolean isSortable(int n) {
        return this.isSortable == null || this.isSortable[n];
    }

    public void setComparator(int n, Comparator<?> comparator) {
        this.checkColumn(n);
        if (this.comparators == null) {
            if (comparator == null) {
                return;
            }
            this.comparators = new Comparator[this.columnModel.getColumnCount()];
        }
        this.comparators[n] = comparator;
    }

    boolean isComparatorSet(int n) {
        return this.comparators != null && this.comparators[n] != null;
    }

    public Comparator<?> getComparator(int n) {
        if (this.isComparatorSet(n)) {
            return this.comparators[n];
        }
        Class<?> clazz = this.columnModel.getColumnClass(n);
        if (clazz == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    public void setRowFilter(RowFilter<? super T, ? super I> rowFilter) {
        if (rowFilter == null && this.rowFilter == null) {
            return;
        }
        this.rowFilter = rowFilter;
        this.sort();
    }

    public RowFilter<? super T, ? super I> getRowFilter() {
        return this.rowFilter;
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> list) {
        List<? extends RowSorter.SortKey> list2 = this.sortKeys;
        this.sortKeys = list != null && !list.isEmpty() ? Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(list)) : Collections.emptyList();
        if (!this.sortKeys.equals(list2)) {
            this.fireSortOrderChanged();
            this.sort();
        }
    }

    @Override
    public void toggleSortOrder(int n) {
        this.checkColumn(n);
        if (this.isSortable(n)) {
            List<RowSorter.SortKey> list = DefaultTreeTableSorter.toggleSortOrder(this.getSortKeys(), this.getSortCycle(), n, this.getMaxSortKeys());
            this.setSortKeys(list);
        }
    }

    static List<RowSorter.SortKey> toggleSortOrder(List<? extends RowSorter.SortKey> list, List<SortOrder> list2, int n, int n2) {
        int n3;
        List<RowSorter.SortKey> list3 = new ArrayList<RowSorter.SortKey>(list);
        for (n3 = list3.size() - 1; n3 >= 0 && ((RowSorter.SortKey)list3.get(n3)).getColumn() != n; --n3) {
        }
        if (n3 == -1) {
            RowSorter.SortKey sortKey = new RowSorter.SortKey(n, list2.get(0));
            list3.add(0, sortKey);
        } else if (n3 == 0) {
            RowSorter.SortKey sortKey = (RowSorter.SortKey)list3.get(0);
            int n4 = list2.indexOf((Object)sortKey.getSortOrder());
            if (n4 < 0 || ++n4 >= list2.size()) {
                n4 = 0;
            }
            list3.set(0, new RowSorter.SortKey(sortKey.getColumn(), list2.get(n4)));
        } else {
            list3.remove(n3);
            list3.add(0, new RowSorter.SortKey(n, list2.get(0)));
        }
        if (list3.size() > n2) {
            list3 = list3.subList(0, n2);
        }
        return list3;
    }

    @Override
    public List<SortOrder> getSortCycle() {
        return this.sortCycle;
    }

    @Override
    public void setSortCycle(List<SortOrder> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.sortCycle = list;
    }

    private void checkColumn(int n) {
        if (n < 0 || n >= this.columnModel.getColumnCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void sort() {
        this.getRowSorter(this.treeModel.getRoot()).sort(true);
        this.fireSorterChanged();
    }

    @Override
    public void addTreeTableSorterListener(TreeTableSorterListener treeTableSorterListener) {
        this.listenerList.add(TreeTableSorterListener.class, treeTableSorterListener);
    }

    @Override
    public void removeTreeTableSorterListener(TreeTableSorterListener treeTableSorterListener) {
        this.listenerList.remove(TreeTableSorterListener.class, treeTableSorterListener);
    }

    protected void fireSortOrderChanged() {
        this.fire(new TreeTableSorterEvent(this));
    }

    protected void fireSorterChanged() {
        this.fire(new TreeTableSorterEvent(this, null));
    }

    protected void fireRowSorterChanged(TreePath treePath) {
        this.fire(new TreeTableSorterEvent(this, treePath));
    }

    private void fire(TreeTableSorterEvent treeTableSorterEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeTableSorterListener.class) continue;
            ((TreeTableSorterListener)objectArray[i + 1]).sorterChanged(treeTableSorterEvent);
        }
    }

    @Override
    public void structureChanged(TreePath treePath, boolean bl) {
        if (bl) {
            this.sorters.clear();
            this.sorters.put(this.treeModel.getRoot(), new NodeSorter(this.treeModel.getRoot()));
        } else {
            NodeSorter nodeSorter = this.getRowSorter(treePath.getLastPathComponent());
            nodeSorter.removeAllChildren(this.sorters);
        }
    }

    @Override
    public void nodesRemoved(TreePath treePath, Object[] objectArray) {
        NodeSorter nodeSorter = this.getRowSorter(treePath.getLastPathComponent());
        if (nodeSorter != null) {
            nodeSorter.remove(objectArray, this.sorters);
        }
    }

    @Override
    public void setVisible(TreePath treePath, List<TreePath> list, boolean bl) {
        NodeSorter nodeSorter = this.getRowSorter(treePath);
        nodeSorter.setVisible(bl);
        if (bl) {
            for (TreePath treePath2 : list) {
                NodeSorter nodeSorter2 = nodeSorter;
                int n = treePath2.getPathCount();
                for (int i = treePath.getPathCount(); i < n; ++i) {
                    Object object = treePath2.getPathComponent(i);
                    nodeSorter2 = nodeSorter2.getChildSorter(object, this.sorters);
                    nodeSorter2.setVisible(true);
                }
            }
            nodeSorter.sort(true);
        }
    }

    public class NodeSorter
    extends DefaultRowSorter<T, I>
    implements TreeTableSorter.SortCycle {
        private NodeSorter parent;
        private Map<Object, NodeSorter> children;
        private List<SortOrder> sortCycle = ASCENDING_DESCENDING_UNSORTED;
        private boolean visible;
        private boolean firePathEvent = true;

        public NodeSorter(Object object) {
            this(null, object);
            this.setVisible(true);
        }

        public NodeSorter(NodeSorter nodeSorter, Object object) {
            this.parent = nodeSorter;
            this.setModelWrapper(new TreeTableWrapper(object));
            this.children = this.createChildren();
            if (this.parent != null) {
                this.setMaxSortKeys(Integer.MAX_VALUE);
            }
        }

        protected Map<Object, NodeSorter> createChildren() {
            return new IdentityHashMap<Object, NodeSorter>(((TreeModel)this.getModel()).getChildCount(this.getNode()));
        }

        public NodeSorter getParent() {
            return this.parent;
        }

        DefaultTreeTableSorter<T, C, I> getMaster() {
            return DefaultTreeTableSorter.this;
        }

        NodeSorter getChildSorter(Object object, Map<Object, NodeSorter> map) {
            NodeSorter nodeSorter = this.children.get(object);
            if (nodeSorter == null && map != null) {
                nodeSorter = new NodeSorter(this, object);
                this.children.put(object, nodeSorter);
                map.put(object, nodeSorter);
            }
            return nodeSorter;
        }

        protected org.violetlib.treetable.DefaultTreeTableSorter$NodeSorter.TreeTableWrapper getTreeTableModelWrapper() {
            return (TreeTableWrapper)this.getModelWrapper();
        }

        public Object getNode() {
            return this.getTreeTableModelWrapper().getNode();
        }

        public C getColumnModel() {
            return this.getTreeTableModelWrapper().getColumnModel();
        }

        @Override
        public Comparator<?> getComparator(int n) {
            Comparator<?> comparator = super.getComparator(n);
            return comparator != null ? comparator : this.getMaster().getComparator(n);
        }

        @Override
        protected boolean useToString(int n) {
            if (super.getComparator(n) != null || this.getMaster().isComparatorSet(n)) {
                return false;
            }
            Class<?> clazz = this.getColumnModel().getColumnClass(n);
            if (clazz == String.class) {
                return false;
            }
            return !Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            List<RowSorter.SortKey> list = super.getSortKeys();
            return !list.isEmpty() ? list : this.getMaster().getSortKeys();
        }

        @Override
        public int getMaxSortKeys() {
            int n = super.getMaxSortKeys();
            return n < Integer.MAX_VALUE ? n : this.getMaster().getMaxSortKeys();
        }

        @Override
        public RowFilter<? super T, ? super I> getRowFilter() {
            RowFilter rowFilter = super.getRowFilter();
            if (rowFilter != null) {
                return rowFilter;
            }
            return this.getMaster().getRowFilter();
        }

        @Override
        public boolean getSortsOnUpdates() {
            return this.getMaster().getSortsOnUpdates();
        }

        @Override
        public boolean isSortable(int n) {
            return this.getMaster().isSortable(n);
        }

        @Override
        public void setSortCycle(List<SortOrder> list) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.sortCycle = list;
        }

        @Override
        public List<SortOrder> getSortCycle() {
            return this.sortCycle;
        }

        @Override
        public void toggleSortOrder(int n) {
            DefaultTreeTableSorter.this.checkColumn(n);
            if (this.isSortable(n)) {
                List<RowSorter.SortKey> list = DefaultTreeTableSorter.toggleSortOrder(super.getSortKeys(), this.getSortCycle(), n, this.getMaxSortKeys());
                this.setSortKeys(list);
            }
        }

        @Override
        public void setSortsOnUpdates(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSortable(int n, boolean bl) {
            throw new UnsupportedOperationException();
        }

        void sort(boolean bl) {
            if (!this.isVisible()) {
                return;
            }
            this.firePathEvent = false;
            try {
                super.sort();
            }
            finally {
                this.firePathEvent = true;
            }
            if (!bl) {
                return;
            }
            for (NodeSorter nodeSorter : this.children.values()) {
                nodeSorter.sort(bl);
            }
        }

        @Override
        protected void fireRowSorterChanged(int[] nArray) {
            super.fireRowSorterChanged(nArray);
            if (this.firePathEvent) {
                this.getMaster().fireRowSorterChanged(this.getPathToRoot());
            }
        }

        private TreePath getPathToRoot() {
            if (this.parent == null) {
                return new TreePath(this.getNode());
            }
            return this.parent.getPathToRoot().pathByAddingChild(this.getNode());
        }

        @Override
        public void allRowsChanged() {
            this.getTreeTableModelWrapper().updateRowCount();
            super.allRowsChanged();
        }

        @Override
        public void rowsDeleted(int n, int n2) {
            this.getTreeTableModelWrapper().updateRowCount();
            super.rowsDeleted(n, n2);
        }

        @Override
        public void rowsInserted(int n, int n2) {
            this.getTreeTableModelWrapper().updateRowCount();
            super.rowsInserted(n, n2);
        }

        public void setVisible(boolean bl) {
            if (this.visible != bl) {
                this.visible = bl;
                if (bl) {
                    this.sort(true);
                }
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        void removeAllChildren(Map<Object, NodeSorter> map) {
            for (Map.Entry<Object, NodeSorter> entry : this.children.entrySet()) {
                map.remove(entry.getKey());
                entry.getValue().removeAllChildren(map);
            }
            this.children.clear();
        }

        void remove(Object[] objectArray, Map<Object, NodeSorter> map) {
            for (Object object : objectArray) {
                NodeSorter nodeSorter = this.children.remove(object);
                if (nodeSorter == null) continue;
                nodeSorter.removeAllChildren(map);
            }
        }

        protected class TreeTableWrapper
        extends DefaultRowSorter.ModelWrapper<T, I> {
            private Object node;
            private int rowCount;

            public TreeTableWrapper(Object object) {
                this.node = object;
                this.updateRowCount();
            }

            public Object getNode() {
                return this.node;
            }

            public C getColumnModel() {
                return DefaultTreeTableSorter.this.columnModel;
            }

            @Override
            public int getColumnCount() {
                return DefaultTreeTableSorter.this.columnModel.getColumnCount();
            }

            @Override
            public I getIdentifier(int n) {
                return DefaultTreeTableSorter.this.treeModel.getChild(this.node, n);
            }

            @Override
            public T getModel() {
                return DefaultTreeTableSorter.this.treeModel;
            }

            @Override
            public int getRowCount() {
                return this.rowCount;
            }

            public void updateRowCount() {
                this.rowCount = DefaultTreeTableSorter.this.treeModel.getChildCount(this.node);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return DefaultTreeTableSorter.this.columnModel.getValueAt(DefaultTreeTableSorter.this.treeModel.getChild(this.node, n), n2);
            }
        }
    }
}

