/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.TreeTableCellEditor;
import org.violetlib.treetable.TreeTableCellRenderer;

public class CellEditorContainer<E extends CellEditor>
extends Container
implements TreeTableCellEditor,
TableCellEditor {
    protected E editor;
    protected transient TreeTableCellRenderer renderer;
    protected transient Component rendererComponent;
    protected transient Dimension rendererSize;
    protected transient Component editingComponent;
    protected transient int iconOffset;

    public CellEditorContainer(E e) {
        this.editor = e;
    }

    public void clearState() {
        this.removeAll();
        this.renderer = null;
        this.rendererSize = null;
        this.editingComponent = null;
    }

    @Override
    public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2) {
        return this.getEditorComponent(treeTable, object, bl, n, n2, false, false, false);
    }

    @Override
    public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        return this.getEditorComponent(treeTable, object, bl, n, n2, true, bl2, bl3);
    }

    private Component getEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (this.editingComponent != null) {
            this.remove(this.editingComponent);
        }
        this.renderer = treeTable.getCellRenderer(n, n2);
        this.rendererComponent = this.renderer.getTreeTableCellRendererComponent(treeTable, object, bl, true, n, n2, bl3, bl4);
        Component component = this.rendererComponent;
        Dimension dimension = this.rendererSize = component == null ? null : component.getPreferredSize();
        if (bl2) {
            Icon icon;
            JLabel jLabel = component instanceof JLabel ? (JLabel)component : null;
            Icon icon2 = icon = jLabel == null ? null : jLabel.getIcon();
            this.iconOffset = icon != null ? jLabel.getIconTextGap() + icon.getIconWidth() : (jLabel == null ? 4 : jLabel.getIconTextGap());
            --this.iconOffset;
        } else {
            this.iconOffset = 0;
        }
        Component component2 = this.editingComponent = bl2 ? this.getCellEditorComponent(treeTable, object, bl, n, n2, bl3, bl4) : this.getCellEditorComponent(treeTable, object, bl, n, n2);
        if (this.editingComponent != null) {
            this.add(this.editingComponent);
        }
        return this;
    }

    protected Component getCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        if (this.editor instanceof TreeTableCellEditor) {
            return ((TreeTableCellEditor)this.editor).getTreeTableCellEditorComponent(treeTable, object, bl, n, n2, bl2, bl3);
        }
        return null;
    }

    protected Component getCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2) {
        if (this.editor instanceof TreeTableCellEditor) {
            return ((TreeTableCellEditor)this.editor).getTreeTableCellEditorComponent(treeTable, object, bl, n, n2);
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.editor.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.editor.isCellEditable(eventObject);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.editor.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.editor.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void doLayout() {
        if (this.editingComponent != null) {
            int n;
            int n2;
            if (this.getComponentOrientation().isLeftToRight()) {
                n2 = this.iconOffset;
                n = this.getWidth() - n2;
            } else {
                n2 = 0;
                n = this.getWidth() - this.iconOffset;
            }
            this.editingComponent.setBounds(n2, 0, n, this.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.editingComponent != null) {
            Dimension dimension = this.editingComponent.getPreferredSize();
            dimension.width += this.iconOffset + 5;
            if (this.rendererSize != null) {
                dimension.height = Math.max(dimension.height, this.rendererSize.height);
            }
            return dimension;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        throw new UnsupportedOperationException();
    }
}

