/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererPainter;

public abstract class CachingRendererPainter
extends RendererPainter {
    private static boolean isCachingEnabled = CachingRendererPainter.getDefaultCachingEnabled();

    private static boolean getDefaultCachingEnabled() {
        String string = System.getProperty("VAqua.enableCaching");
        if ("false".equals(string)) {
            System.err.println("VAqua caching disabled");
            return false;
        }
        return true;
    }

    public static void setCachingEnabled(boolean bl) {
        if (bl != isCachingEnabled) {
            isCachingEnabled = bl;
            System.err.println("VAqua caching " + (isCachingEnabled ? "enabled" : "disabled"));
        }
    }

    protected CachingRendererPainter(@NotNull Renderer renderer, float f, float f2) {
        super(renderer, f, f2);
    }

    @Override
    @Nullable
    protected Image getImage(int n, int n2, int n3) {
        ImageCache.PixelsKey pixelsKey = this.createKey(n, n2, n3);
        if (pixelsKey != null && isCachingEnabled) {
            ImageCache imageCache = ImageCache.getInstance();
            Image image = imageCache.getImage(pixelsKey);
            if (image != null) {
                return image;
            }
            image = this.createImage(n, n2, n3);
            if (image != null) {
                imageCache.setImage(pixelsKey, image);
            }
            return image;
        }
        return this.createImage(n, n2, n3);
    }

    @Nullable
    protected abstract ImageCache.PixelsKey createKey(int var1, int var2, int var3);
}

