/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanAggregator;
import org.apache.avro.ipc.trace.TracePlugin;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestEndToEndTracing {
    Protocol advancedProtocol = Protocol.parse("{\"protocol\": \"Advanced\", \"messages\": { \"w\": { \"request\": [{\"name\": \"req\", \"type\": \"int\"}],    \"response\": \"int\"},\"x\": { \"request\": [{\"name\": \"req\", \"type\": \"int\"}],    \"response\": \"int\"},\"y\": { \"request\": [{\"name\": \"req\", \"type\": \"int\"}],    \"response\": \"int\"} } }");

    @Test
    public void testTraceAndCollectionMemory() throws Exception {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.storageType = TracePlugin.StorageType.MEMORY;
        this.testTraceAndCollection(conf);
    }

    @Test
    public void testTraceAndCollectionDisk() throws Exception {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.storageType = TracePlugin.StorageType.DISK;
        conf.buffer = false;
        this.testTraceAndCollection(conf);
    }

    public void testTraceAndCollection(TracePluginConfiguration conf) throws Exception {
        conf.storageType = TracePlugin.StorageType.MEMORY;
        conf.traceProb = 1.0;
        conf.port = 51010;
        conf.clientPort = 12346;
        TracePlugin aPlugin = new TracePlugin(conf);
        conf.port = 51011;
        conf.clientPort = 12347;
        TracePlugin bPlugin = new TracePlugin(conf);
        conf.port = 51012;
        conf.clientPort = 12348;
        TracePlugin cPlugin = new TracePlugin(conf);
        conf.port = 51013;
        conf.clientPort = 12349;
        TracePlugin dPlugin = new TracePlugin(conf);
        RecursingResponder bRes = new RecursingResponder(this.advancedProtocol, bPlugin);
        bRes.addRPCPlugin(bPlugin);
        HttpServer server1 = new HttpServer((Responder)bRes, 21005);
        server1.start();
        EndpointResponder cRes = new EndpointResponder(this.advancedProtocol);
        cRes.addRPCPlugin(cPlugin);
        HttpServer server2 = new HttpServer((Responder)cRes, 21006);
        server2.start();
        EndpointResponder dRes = new EndpointResponder(this.advancedProtocol);
        dRes.addRPCPlugin(dPlugin);
        HttpServer server3 = new HttpServer((Responder)dRes, 21007);
        server3.start();
        HttpTransceiver trans = new HttpTransceiver(new URL("http://localhost:21005"));
        GenericRequestor r = new GenericRequestor(this.advancedProtocol, trans);
        r.addRPCPlugin(aPlugin);
        GenericData.Record params = new GenericData.Record(this.advancedProtocol.getMessages().get("w").getRequest());
        params.put("req", (Object)1);
        r.request("w", params);
        Thread.sleep(1000L);
        ArrayList<Span> allSpans = new ArrayList<Span>();
        allSpans.addAll(aPlugin.storage.getAllSpans());
        allSpans.addAll(bPlugin.storage.getAllSpans());
        allSpans.addAll(cPlugin.storage.getAllSpans());
        allSpans.addAll(dPlugin.storage.getAllSpans());
        SpanAggregator.SpanAggregationResults results = SpanAggregator.getFullSpans(allSpans);
        SpanAggregator.TraceFormationResults traces = SpanAggregator.getTraces(results.completeSpans);
        Assert.assertEquals((long)1L, (long)traces.traces.size());
        Assert.assertEquals((long)0L, (long)traces.rejectedSpans.size());
        String string1 = traces.traces.get(0).printWithTiming();
        Assert.assertTrue((boolean)string1.contains("w"));
        Assert.assertTrue((boolean)string1.contains("x"));
        Assert.assertTrue((string1.indexOf("x") != string1.lastIndexOf("x") ? 1 : 0) != 0);
        String string2 = traces.traces.get(0).printBrief();
        Assert.assertTrue((boolean)string2.contains("w"));
        Assert.assertTrue((boolean)string2.contains("x"));
        Assert.assertTrue((string2.indexOf("x") != string2.lastIndexOf("x") ? 1 : 0) != 0);
        System.out.println(traces.traces.get(0).printWithTiming());
        System.out.println(traces.traces.get(0).printBrief());
        server1.close();
        server2.close();
        server3.close();
        aPlugin.httpServer.close();
        aPlugin.clientFacingServer.stop();
        bPlugin.httpServer.close();
        bPlugin.clientFacingServer.stop();
        cPlugin.httpServer.close();
        cPlugin.clientFacingServer.stop();
        dPlugin.httpServer.close();
        dPlugin.clientFacingServer.stop();
    }

    private static class SleepyResponder
    extends GenericResponder {
        public SleepyResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            try {
                Thread.sleep((Long)((GenericRecord)request).get("millis"));
            }
            catch (InterruptedException e) {
                throw new AvroRemoteException(e);
            }
            return null;
        }
    }

    static class EndpointResponder
    extends GenericResponder {
        public EndpointResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            GenericRecord inParams = (GenericRecord)request;
            Integer currentCount = (Integer)inParams.get("req");
            return currentCount + 1;
        }
    }

    static class RecursingResponder
    extends GenericResponder {
        HttpTransceiver transC = new HttpTransceiver(new URL("http://localhost:21006"));
        HttpTransceiver transD = new HttpTransceiver(new URL("http://localhost:21007"));
        GenericRequestor reqC;
        GenericRequestor reqD;
        Protocol protocol;

        public RecursingResponder(Protocol local, RPCPlugin plugin) throws Exception {
            super(local);
            this.reqC = new GenericRequestor(local, this.transC);
            this.reqC.addRPCPlugin(plugin);
            this.reqD = new GenericRequestor(local, this.transD);
            this.reqD.addRPCPlugin(plugin);
            this.protocol = local;
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws IOException {
            Assert.assertTrue((boolean)"w".equals(message.getName()));
            GenericRecord inParams = (GenericRecord)request;
            Integer currentCount = (Integer)inParams.get("req");
            Assert.assertTrue((boolean)currentCount.equals(1));
            GenericData.Record paramsC = new GenericData.Record(this.protocol.getMessages().get("x").getRequest());
            paramsC.put("req", (Object)(currentCount + 1));
            Integer returnC = (Integer)this.reqC.request("x", paramsC);
            Assert.assertTrue((boolean)returnC.equals(currentCount + 2));
            GenericData.Record paramsD = new GenericData.Record(this.protocol.getMessages().get("x").getRequest());
            paramsD.put("req", (Object)(currentCount + 3));
            Integer returnD = (Integer)this.reqD.request("x", paramsD);
            Assert.assertTrue((boolean)returnD.equals(currentCount + 4));
            return currentCount + 5;
        }
    }
}

