/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.nio.ByteBuffer;
import java.util.Map;
import junit.framework.Assert;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;

public final class RPCMetaTestPlugin
extends RPCPlugin {
    protected final String key;

    public RPCMetaTestPlugin(String keyname) {
        this.key = keyname;
    }

    @Override
    public void clientStartConnect(RPCContext context) {
        ByteBuffer buf = ByteBuffer.wrap("ap".getBytes());
        context.requestHandshakeMeta().put(this.key, buf);
    }

    @Override
    public void serverConnecting(RPCContext context) {
        Assert.assertNotNull(context.requestHandshakeMeta());
        Assert.assertNotNull(context.responseHandshakeMeta());
        Assert.assertNull(context.getRequestPayload());
        Assert.assertNull(context.getResponsePayload());
        if (!context.requestHandshakeMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = context.requestHandshakeMeta().get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array());
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (String)"ap", (String)partialstr);
        buf = ByteBuffer.wrap((partialstr + "ac").getBytes());
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseHandshakeMeta().put(this.key, buf);
    }

    @Override
    public void clientFinishConnect(RPCContext context) {
        Map<String, ByteBuffer> handshakeMeta = context.responseHandshakeMeta();
        Assert.assertNull(context.getRequestPayload());
        Assert.assertNull(context.getResponsePayload());
        Assert.assertNotNull(handshakeMeta);
        if (!handshakeMeta.containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = handshakeMeta.get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array());
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (String)"apac", (String)partialstr);
        buf = ByteBuffer.wrap((partialstr + "he").getBytes());
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        handshakeMeta.put(this.key, buf);
        this.checkRPCMetaMap(handshakeMeta);
    }

    @Override
    public void clientSendRequest(RPCContext context) {
        ByteBuffer buf = ByteBuffer.wrap("ap".getBytes());
        context.requestCallMeta().put(this.key, buf);
        Assert.assertNotNull((Object)context.getMessage());
        Assert.assertNotNull(context.getRequestPayload());
        Assert.assertNull(context.getResponsePayload());
    }

    @Override
    public void serverReceiveRequest(RPCContext context) {
        Map<String, ByteBuffer> meta = context.requestCallMeta();
        Assert.assertNotNull(meta);
        Assert.assertNotNull((Object)context.getMessage());
        Assert.assertNull(context.getResponsePayload());
        if (!meta.containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = meta.get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array());
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (String)"ap", (String)partialstr);
        buf = ByteBuffer.wrap((partialstr + "a").getBytes());
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        meta.put(this.key, buf);
    }

    @Override
    public void serverSendResponse(RPCContext context) {
        Assert.assertNotNull(context.requestCallMeta());
        Assert.assertNotNull(context.responseCallMeta());
        Assert.assertNotNull(context.getResponsePayload());
        if (!context.requestCallMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = context.requestCallMeta().get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array());
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (String)"apa", (String)partialstr);
        buf = ByteBuffer.wrap((partialstr + "c").getBytes());
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseCallMeta().put(this.key, buf);
    }

    @Override
    public void clientReceiveResponse(RPCContext context) {
        Assert.assertNotNull(context.responseCallMeta());
        Assert.assertNotNull(context.getRequestPayload());
        if (!context.responseCallMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = context.responseCallMeta().get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array());
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (String)"apac", (String)partialstr);
        buf = ByteBuffer.wrap((partialstr + "he").getBytes());
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseCallMeta().put(this.key, buf);
        this.checkRPCMetaMap(context.responseCallMeta());
    }

    protected void checkRPCMetaMap(Map<String, ByteBuffer> rpcMeta) {
        Assert.assertNotNull(rpcMeta);
        Assert.assertTrue((String)"key not present in map", (boolean)rpcMeta.containsKey(this.key));
        ByteBuffer keybuf = rpcMeta.get(this.key);
        Assert.assertNotNull((Object)keybuf);
        Assert.assertTrue((String)"key BB had nothing remaining", (keybuf.remaining() > 0 ? 1 : 0) != 0);
        String str = new String(keybuf.array());
        Assert.assertEquals((String)"apache", (String)str);
    }
}

